/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.ejt.internal.util.JavaVersionUtil;
import com.install4j.api.launcher.StartupNotification;
import com.install4j.runtime.alert.AlertType;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.NoHelper;
import com.install4j.runtime.util.VersionCheck;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import javax.accessibility.AccessibilityProvider;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class Java9Helper
extends NoHelper {
    private static boolean JETBRAINS_WORKAROUND = JavaVersionUtil.JETBRAINS_JRE && !VersionCheck.checkJavaVersionCompatible("11.0.12", System.getProperty("java.version"));

    @Override
    public void requestForeground() {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
            desktop.requestForeground(true);
        }
    }

    @Override
    public void setMacStartupListener(StartupNotification.Listener startupListener) {
        if (JETBRAINS_WORKAROUND) {
            super.setMacStartupListener(startupListener);
        } else {
            Desktop desktop = Desktop.getDesktop();
            if (startupListener != null) {
                if (desktop.isSupported(Desktop.Action.APP_OPEN_FILE)) {
                    desktop.setOpenFileHandler(e -> {
                        for (File file : e.getFiles()) {
                            startupListener.startupPerformed(file.getAbsolutePath());
                        }
                    });
                }
                if (desktop.isSupported(Desktop.Action.APP_OPEN_URI)) {
                    desktop.setOpenURIHandler(openURIEvent -> {
                        URI uri = openURIEvent.getURI();
                        if (uri != null) {
                            startupListener.startupPerformed(uri.toString());
                        }
                    });
                }
            }
        }
    }

    @Override
    public void setMacHandleQuit(boolean handleQuit) {
        if (JETBRAINS_WORKAROUND) {
            super.setMacHandleQuit(handleQuit);
        } else {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                desktop.setQuitHandler((e, response) -> {
                    if (handleQuit) {
                        response.performQuit();
                    } else {
                        response.cancelQuit();
                    }
                });
            }
        }
    }

    @Override
    public void setMacQuitHandler(Runnable runnable) {
        if (JETBRAINS_WORKAROUND) {
            super.setMacQuitHandler(runnable);
        } else {
            Desktop desktop = Desktop.getDesktop();
            if (runnable != null && desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                desktop.setQuitHandler((e, response) -> {
                    response.cancelQuit();
                    runnable.run();
                });
            }
        }
    }

    @Override
    public void setMacAboutHandler(Runnable runnable) {
        if (JETBRAINS_WORKAROUND) {
            super.setMacAboutHandler(runnable);
        } else {
            Desktop desktop = Desktop.getDesktop();
            if (runnable != null && desktop.isSupported(Desktop.Action.APP_ABOUT)) {
                desktop.setAboutHandler(e -> runnable.run());
            }
        }
    }

    @Override
    public void setMacPreferencesHandler(Runnable runnable) {
        if (JETBRAINS_WORKAROUND) {
            super.setMacPreferencesHandler(runnable);
        } else {
            Desktop desktop = Desktop.getDesktop();
            if (runnable != null && desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
                desktop.setPreferencesHandler(e -> runnable.run());
            }
        }
    }

    @Override
    public void addReads(String moduleName) {
        try {
            Optional<Module> optionalModule = ModuleLayer.boot().findModule(moduleName);
            optionalModule.ifPresent(module -> Java9Helper.class.getModule().addReads((Module)module));
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
        }
    }

    @Override
    public long getPid() {
        try {
            return ((ProcessHandle)ProcessHandle.class.getMethod("current", new Class[0]).invoke(null, new Object[0])).pid();
        }
        catch (Throwable e) {
            return super.getPid();
        }
    }

    @Override
    public boolean isJavaFxWindowShown() {
        try {
            Class<?> windowClass = Class.forName("javafx.stage.Window");
            Method isShowingMethod = windowClass.getMethod("isShowing", new Class[0]);
            for (Object window : (Collection)windowClass.getMethod("getWindows", new Class[0]).invoke(null, new Object[0])) {
                if (!Boolean.TRUE.equals(isShowingMethod.invoke(window, new Object[0]))) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException, IOException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        for (AlertType alertType : AlertType.values()) {
            ImageIcon icon = (ImageIcon)new CustomOptionPaneUI().getIconForType(alertType.getOptionType());
            Image sourceImage = icon.getImage();
            if (sourceImage instanceof MultiResolutionImage) {
                BufferedImage image = (BufferedImage)((MultiResolutionImage)((Object)sourceImage)).getResolutionVariant(64.0, 64.0);
                Java9Helper.writeImage(alertType, "@2x", image);
                continue;
            }
            Java9Helper.writeImage(alertType, "", (BufferedImage)sourceImage);
        }
    }

    private static void writeImage(AlertType alertType, String postFix, BufferedImage image) throws IOException {
        ImageIO.write((RenderedImage)image, "png", new File("C:\\Users\\ingo\\projects\\install4j\\modules\\install4j_runtime\\resources\\com\\install4j\\runtime\\installer\\frontend\\icons", "alert_windows_" + alertType.name().toLowerCase(Locale.ENGLISH) + postFix + ".png"));
    }

    @Override
    public String getAccessibilityProviderName() {
        return super.getAccessibilityProviderName();
    }

    public static class EmptyAccessibilityProvider
    extends AccessibilityProvider {
        @Override
        public String getName() {
            return "com.install4j.runtime.EmptyAccessibilityProvider";
        }

        @Override
        public void activate() {
        }
    }

    private static class CustomOptionPaneUI
    extends BasicOptionPaneUI {
        private CustomOptionPaneUI() {
            this.installUI(new JOptionPane());
        }

        @Override
        protected Icon getIconForType(int messageType) {
            return super.getIconForType(messageType);
        }
    }
}

