/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CommonFileUtil {
    public static long pumpCharStream(Reader reader, Writer writer) throws IOException {
        int c;
        long count = 0L;
        while ((c = reader.read()) != -1) {
            if (writer != null) {
                writer.write(c);
            }
            ++count;
        }
        if (writer != null) {
            writer.flush();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LinkedList<String> readLines(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            LinkedList<String> linkedList = CommonFileUtil.readLines(fis);
            return linkedList;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @NotNull
    public static LinkedList<String> readLines(InputStream fis) throws IOException {
        String line;
        LinkedList<String> lineList = new LinkedList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        while ((line = br.readLine()) != null) {
            while (line.endsWith("\r") || line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            lineList.add(line);
        }
        return lineList;
    }

    public static void emptyDirectory(File dir) {
        Set<File> emptySet = Collections.emptySet();
        CommonFileUtil.emptyDirectory(dir, emptySet);
    }

    public static void deleteDirectory(File dir) {
        Set<File> emptySet = Collections.emptySet();
        CommonFileUtil.deleteDirectory(dir, emptySet);
    }

    public static void emptyDirectory(File dir, Set<File> excludedFiles) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (excludedFiles.contains(file.getAbsoluteFile())) continue;
            if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
                CommonFileUtil.deleteDirectory(file, excludedFiles);
                file.delete();
                continue;
            }
            file.delete();
        }
    }

    public static void deleteDirectory(File dir, Set<File> excludedFiles) {
        CommonFileUtil.emptyDirectory(dir, excludedFiles);
        dir.delete();
    }

    public static void copyStream(InputStream is, File targetFile) throws IOException, InterruptedException {
        CommonFileUtil.copyStream(is, targetFile, null, 0L);
    }

    public static void copyStream(InputStream is, File targetFile, CopyProgressListener progressListener, long modificationTime) throws IOException, InterruptedException {
        CommonFileUtil.copyStream(is, targetFile, progressListener, modificationTime, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream is, File targetFile, CopyProgressListener progressListener, long modificationTime, boolean close) throws IOException, InterruptedException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            CommonFileUtil.pumpStream(is, (OutputStream)fos, progressListener);
        }
        finally {
            if (is != null && close) {
                is.close();
            }
        }
        if (modificationTime != 0L) {
            targetFile.setLastModified(modificationTime);
        }
    }

    public static long pumpStream(InputStream is, OutputStream os) throws IOException {
        return CommonFileUtil.pumpStream(is, os, false);
    }

    public static long pumpStream(InputStream is, OutputStream os, boolean xor) throws IOException {
        try {
            return CommonFileUtil.pumpStream(is, os, null, xor);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static long pumpStream(InputStream is, OutputStream os, CopyProgressListener copyProgressListener) throws IOException, InterruptedException {
        return CommonFileUtil.pumpStream(is, os, copyProgressListener, false);
    }

    public static long pumpStream(InputStream is, OutputStream os, CopyProgressListener copyProgressListener, boolean xor) throws IOException, InterruptedException {
        return CommonFileUtil.pumpStream(is, os, copyProgressListener, xor, Long.MAX_VALUE);
    }

    public static long pumpStream(InputStream is, OutputStream os, CopyProgressListener copyProgressListener, boolean xor, long maxLength) throws IOException, InterruptedException {
        int currentRead;
        long count;
        int toBeWritten;
        byte[] buf = new byte[65536];
        for (count = 0L; count < maxLength && (currentRead = is.read(buf)) != -1; count += (long)toBeWritten) {
            toBeWritten = (int)Math.min((long)currentRead, maxLength - count);
            if (xor) {
                for (int i = 0; i < toBeWritten; ++i) {
                    buf[i] = (byte)(buf[i] ^ 0x88);
                }
            }
            os.write(buf, 0, toBeWritten);
            if (copyProgressListener == null) continue;
            copyProgressListener.progressPerformed(toBeWritten);
        }
        return count;
    }

    public static interface CopyProgressListener {
        public void progressPerformed(long var1) throws InterruptedException;
    }
}

