/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ExternalFile;
import com.install4j.runtime.beans.formcomponents.AbstractLabelComponent;
import com.install4j.runtime.beans.formcomponents.FontStyle;
import com.install4j.runtime.beans.formcomponents.FontType;
import com.install4j.runtime.beans.formcomponents.LinkLabelContainer;
import com.install4j.runtime.util.HyperlinkLabel;
import com.install4j.runtime.util.IconHelper;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;

public abstract class AbstractLabelWithIconComponent
extends AbstractLabelComponent {
    private ExternalFile labelIconFile = null;
    private int iconTextGap = 4;
    private JLabel label;

    public ExternalFile getLabelIconFile() {
        return this.replaceWithTextOverride("labelIconFile", this.labelIconFile, ExternalFile.class);
    }

    public void setLabelIconFile(ExternalFile labelIconFile) {
        this.labelIconFile = labelIconFile;
    }

    public int getIconTextGap() {
        return this.replaceWithTextOverride("iconTextGap", this.iconTextGap);
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.getLabelText().trim().isEmpty()) {
            this.initializeLabel(this.label, this.getRawLabelText());
        }
    }

    protected JLabel createLabel() {
        this.label = this.createLabel(this.getRawLabelText(), this.getLabelIconFile(), this.getIconTextGap(), this.getLabelColor(), this.getLabelFont(), this.getLabelFontType(), this.getLabelFontStyle(), this.getLabelFontSizePercent());
        return this.label;
    }

    protected JLabel createLabel(String rawLabelText, ExternalFile labelIconFile, int iconTextGap, Color labelColor, Font labelFont, FontType fontType, FontStyle fontStyle, int fontSizePercent) {
        JLabel label = new JLabel();
        if (labelIconFile != null) {
            IconHelper.withIcon(labelIconFile, this.getContext(), icon -> {
                label.setIcon(icon);
                return null;
            });
        }
        label.setIconTextGap(iconTextGap);
        this.applyLabelColorAndFont(labelColor, labelFont, fontType, fontStyle, fontSizePercent, label);
        if (!rawLabelText.trim().isEmpty()) {
            this.initializeLabel(label, rawLabelText);
        }
        return label;
    }

    protected void initializeLabel(JLabel label, String rawLabelText) {
        this.getFormEnvironment().bindTextWithVariables(rawLabelText, label);
    }

    protected void initializeLinkLabel(HyperlinkLabel linkLabel, LinkLabelContainer linkLabelContainer) {
        Color linkLabelActiveColor;
        linkLabel.setText(linkLabelContainer.getHyperlinkText());
        Color linkLabelColor = linkLabelContainer.getLinkLabelColor();
        if (linkLabelColor != null) {
            linkLabel.setPassiveColor(linkLabelColor);
        }
        if ((linkLabelActiveColor = linkLabelContainer.getLinkLabelActiveColor()) != null) {
            linkLabel.setActiveColor(linkLabelActiveColor);
        }
        this.applyFont(linkLabelContainer.getLinkLabelFont(), linkLabelContainer.getLinkLabelFontType(), linkLabelContainer.getLinkLabelFontStyle(), linkLabelContainer.getLinkLabelFontSizePercent(), linkLabel);
    }

    protected JLabel getLabel() {
        return this.label;
    }
}

