/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.helper.FileAttributesHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.LauncherVariables;
import com.install4j.runtime.launcher.integration.LauncherIntegration;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.PosixFileAttributes;

public class FullLauncherHelper
implements LauncherHelper {
    @Override
    public void initIntegration() {
        LauncherIntegration.init();
    }

    @Override
    public void setUnattended(boolean value) {
        InstallerUtil.setUnattended(true);
    }

    @Override
    public String[] initVariables(Class<?> mainClass, String[] args) {
        return LauncherVariables.init(mainClass, args);
    }

    @Override
    public String replaceVariables(String value) {
        return LauncherVariables.replaceVariables(value);
    }

    @Override
    public String replaceVariables(String value, StringUtil.ReplacementCallback replacementCallback) {
        return LauncherVariables.replaceVariables(value, replacementCallback);
    }

    @Override
    public void setPosixFilePermissions(File file, String permissions) {
        if (!LauncherUtil.isWindows()) {
            UnixFileSystem.setMode(permissions, file);
        }
    }

    @Override
    public String getUnixOwner(File file) {
        if (!LauncherUtil.isWindows()) {
            try {
                PosixFileAttributes attributes = FileAttributesHelper.getFileAttributes(file);
                return attributes.owner().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void watchDirectory(File directory, String dirMode, String threadName, final Runnable runnable) {
        try {
            final WatchService watcher = FileSystems.getDefault().newWatchService();
            directory.mkdirs();
            UnixFileSystem.setMode(dirMode, directory);
            directory.toPath().register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
            new Thread(threadName){
                {
                    super(x0);
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    while (true) {
                        try {
                            WatchKey watchKey;
                            boolean valid;
                            do {
                                watchKey = watcher.take();
                                runnable.run();
                                watchKey.pollEvents();
                            } while (valid = watchKey.reset());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public File getInstallerFile(String fileName) {
        return InstallerUtil.getInstallerFile(fileName);
    }

    @Override
    public void exit(int exitCode) {
        InstallerUtil.exit(exitCode);
    }

    @Override
    public long getPid() {
        return VersionSpecificHelper.getPid();
    }
}

