/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.List;
import mediathek.config.Daten;
import mediathek.daten.DatenDownload;
import mediathek.gui.messages.DownloadInfoUpdateAvailableEvent;
import mediathek.gui.messages.TimerEvent;
import mediathek.tool.BandwidthFormatter;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;

public class DownloadInfos {
    private long bandwidth;
    private long timeRestAllDownloads;
    private long timeRestAktDownloads;
    private long byteAktDownloads;
    private long byteAlleDownloads;
    private int anzDownloadsRun;
    private String bandwidthStr = "";

    public DownloadInfos() {
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    public long getByteAktDownloads() {
        return this.byteAktDownloads;
    }

    public long getByteAlleDownloads() {
        return this.byteAlleDownloads;
    }

    public String getBandwidthStr() {
        return this.bandwidthStr;
    }

    @Handler
    private void handleTimerEvent(TimerEvent e) {
        this.makeDownloadInfos();
    }

    private void makeDownloadInfos() {
        this.resetData();
        List<DatenDownload> aktivDownloads = Daten.getInstance().getListeDownloads().getListOfStartsNotFinished(-1);
        for (DatenDownload download : aktivDownloads) {
            ++this.anzDownloadsRun;
            this.byteAlleDownloads += download.mVFilmSize.getSize() > 0L ? download.mVFilmSize.getSize() : 0L;
            if (download.start == null || download.start.status != 2) continue;
            this.bandwidth += download.start.bandbreite;
            this.byteAktDownloads += download.mVFilmSize.getAktSize() > 0L ? download.mVFilmSize.getAktSize() : 0L;
            if (download.start.restSekunden <= this.timeRestAktDownloads) continue;
            this.timeRestAktDownloads = download.start.restSekunden;
        }
        aktivDownloads.clear();
        if (this.bandwidth < 0L) {
            this.bandwidth = 0L;
        }
        if (this.bandwidth > 0L) {
            long b = this.byteAlleDownloads - this.byteAktDownloads;
            this.timeRestAllDownloads = b <= 0L ? 0L : b / this.bandwidth;
            if (this.timeRestAllDownloads < this.timeRestAktDownloads) {
                this.timeRestAllDownloads = this.timeRestAktDownloads;
            }
            if (this.anzDownloadsRun == 1) {
                this.timeRestAllDownloads = 0L;
            }
        }
        this.bandwidthStr = BandwidthFormatter.format(this.bandwidth);
        MessageBus.getMessageBus().publishAsync((Object)new DownloadInfoUpdateAvailableEvent());
    }

    private void resetData() {
        this.anzDownloadsRun = 0;
        this.byteAlleDownloads = 0L;
        this.byteAktDownloads = 0L;
        this.timeRestAktDownloads = 0L;
        this.timeRestAllDownloads = 0L;
        this.bandwidth = 0L;
    }
}

