/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmediathek/tool/BandwidthFormatter;", "", "<init>", "()V", "KB", "", "MB", "GB", "format", "", "bytesPerSecond", "MediathekView"})
public final class BandwidthFormatter {
    @NotNull
    public static final BandwidthFormatter INSTANCE = new BandwidthFormatter();
    private static final long KB = 1000L;
    private static final long MB = 1000000L;
    private static final long GB = 1000000000L;

    private BandwidthFormatter() {
    }

    @JvmStatic
    @NotNull
    public static final String format(long bytesPerSecond) {
        String string;
        if (bytesPerSecond <= 1L) {
            string = "";
        } else if (bytesPerSecond >= 1000000000L) {
            Locale locale = Locale.GERMANY;
            String string2 = "%.1f GB/s";
            Object[] objectArray = new Object[]{(double)bytesPerSecond / (double)1000000000L};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else if (bytesPerSecond >= 1000000L) {
            Locale locale = Locale.GERMANY;
            String string4 = "%.1f MB/s";
            Object[] objectArray = new Object[]{(double)bytesPerSecond / (double)1000000L};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else if (bytesPerSecond >= 1000L) {
            Locale locale = Locale.GERMANY;
            String string6 = "%,d KB/s";
            Object[] objectArray = new Object[]{bytesPerSecond / 1000L};
            String string7 = String.format(locale, string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        } else {
            Locale locale = Locale.GERMANY;
            String string8 = "%,d B/s";
            Object[] objectArray = new Object[]{bytesPerSecond};
            String string9 = String.format(locale, string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
        }
        return string;
    }
}

