/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import mediathek.controller.history.SeenHistoryController;
import mediathek.mainwindow.MediathekGui;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptimizeHistoryDbAction
extends AbstractAction {
    private final MediathekGui mediathekGui;
    private static final Logger logger = LogManager.getLogger();

    public OptimizeHistoryDbAction(MediathekGui mediathekGui) {
        this.mediathekGui = mediathekGui;
        this.putValue("Name", "History-Datenbank optimieren...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try (SeenHistoryController controller = new SeenHistoryController();){
            SeenHistoryController.DuplicateSearchResult dupes = controller.checkDuplicates();
            logger.trace("{} duplicates found in history", (Object)(dupes.total() - dupes.distinct()));
            controller.removeDuplicates();
            dupes = controller.checkDuplicates();
            logger.trace("{} duplicates found in history after cleanup", (Object)(dupes.total() - dupes.distinct()));
            controller.performDatabaseCompact();
            JOptionPane.showMessageDialog(this.mediathekGui, "Datenbankoptimierung abgeschlossen.", "MediathekView", 1);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.mediathekGui, ex.getMessage(), "MediathekView", 0);
        }
    }
}

