/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bookmark;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.beans.BeanTableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.gui.bookmark.BookmarkAddedAtComparator;
import mediathek.gui.bookmark.BookmarkData;
import mediathek.gui.bookmark.BookmarkDataList;
import mediathek.gui.bookmark.BookmarkEditNoteDialog;
import mediathek.gui.bookmark.BookmarkTableColumnSettingsManager;
import mediathek.gui.bookmark.renderer.AddedAtCellRenderer;
import mediathek.gui.bookmark.renderer.AvailableUntilCellRenderer;
import mediathek.gui.bookmark.renderer.CenteredCellRenderer;
import mediathek.gui.bookmark.renderer.FilmLengthCellRenderer;
import mediathek.gui.bookmark.renderer.NoteCellRenderer;
import mediathek.gui.bookmark.renderer.SeenCellRenderer;
import mediathek.gui.tabs.tab_film.FilmDescriptionPanel;
import mediathek.mainwindow.MediathekGui;
import mediathek.swing.IconOnlyButton;
import mediathek.swing.IconUtils;
import mediathek.swing.NoIconMenuItem;
import mediathek.swing.table.GlazedSortKeysPersister;
import mediathek.swing.table.IconHeaderCellRenderer;
import mediathek.swing.table.TableUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome6.FontAwesomeRegular;
import org.kordamp.ikonli.fontawesome6.FontAwesomeSolid;
import org.kordamp.ikonli.materialdesign2.MaterialDesignE;
import org.kordamp.ikonli.materialdesign2.MaterialDesignN;

public class BookmarkDialog
extends JDialog {
    private static final int COLUMN_SEEN = 0;
    private static final int COLUMN_SENDER = 1;
    private static final int COLUMN_THEMA = 2;
    private static final int COLUMN_TITLE = 3;
    private static final int COLUMN_DAUER = 4;
    private static final int COLUMN_SENDEDATUM = 5;
    private static final int COLUMN_AVAILABLE_UNTIL = 6;
    private static final int COLUMN_NORMAL_QUALITY_URL = 7;
    private static final int COLUMN_NOTIZ = 8;
    private static final int COLUMN_HASHCODE = 9;
    private static final int COLUM_BOOKMARK_ADDED_AT = 10;
    private static final String CONFIG_PREFIX = "ui.bookmark-dialog";
    private static final String BOOKMARK_POS_X = "ui.bookmark-dialog.x";
    private static final String BOOKMARK_POS_Y = "ui.bookmark-dialog.y";
    private static final String BOOKMARK_WIDTH = "ui.bookmark-dialog.width";
    private static final String BOOKMARK_HEIGHT = "ui.bookmark-dialog.height";
    private final FilmDescriptionPanel filmDescriptionPanel = new FilmDescriptionPanel();
    private final JTextArea noteArea = new JTextArea();
    private final JTable table = new JTable();
    private final AddNoteAction addNoteAction = new AddNoteAction(this);
    private final MarkSeenAction markSeenAction = new MarkSeenAction(this);
    private final MarkUnseenAction markUnseenAction = new MarkUnseenAction(this);
    private final RemoveNoteAction removeNoteAction = new RemoveNoteAction(this);
    private final DeleteBookmarkAction deleteBookmarkAction = new DeleteBookmarkAction(this);
    private DefaultEventSelectionModel<BookmarkData> selectionModel;
    private BookmarkTableColumnSettingsManager<BookmarkData> tableColumnSettingsManager;
    private GlazedSortKeysPersister<BookmarkData> sortPersister;

    public BookmarkDialog(Frame owner) {
        super(owner);
        this.setTitle("Merkliste verwalten");
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.setupToolBar();
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.setupNoteArea();
        this.getContentPane().add((Component)this.createTabbedPane(), "South");
        this.setupTable();
        TableUtils.fitColumnHeaders(this.table, 5);
        this.installListener();
        this.restoreBounds();
        this.addNoteAction.setEnabled(this.selectionModel.getSelected().size() == 1 && !this.selectionModel.getSelected().isEmpty());
    }

    private void installTableContextMenu() {
        this.table.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ BookmarkDialog this$0;
            {
                BookmarkDialog bookmarkDialog = this$0;
                Objects.requireNonNull(bookmarkDialog);
                this.this$0 = bookmarkDialog;
            }

            private JPopupMenu createPopupMenu() {
                JPopupMenu popup = new JPopupMenu();
                NoIconMenuItem menuItem = new NoIconMenuItem(this.this$0.addNoteAction);
                popup.add(menuItem);
                menuItem = new NoIconMenuItem(this.this$0.removeNoteAction);
                popup.add(menuItem);
                popup.addSeparator();
                menuItem = new NoIconMenuItem(this.this$0.markSeenAction);
                popup.add(menuItem);
                menuItem = new NoIconMenuItem(this.this$0.markUnseenAction);
                popup.add(menuItem);
                popup.addSeparator();
                menuItem = new NoIconMenuItem(this.this$0.deleteBookmarkAction);
                popup.add(menuItem);
                return popup;
            }

            private void showPopup(MouseEvent e) {
                EventList selectedItems;
                if (!e.isPopupTrigger()) {
                    return;
                }
                int row = this.this$0.table.rowAtPoint(e.getPoint());
                if (row != -1 && !this.this$0.table.isRowSelected(row)) {
                    this.this$0.table.getSelectionModel().setSelectionInterval(row, row);
                }
                if ((selectedItems = this.this$0.selectionModel.getSelected()).isEmpty()) {
                    return;
                }
                JPopupMenu popup = this.createPopupMenu();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }
        });
    }

    private void installListener() {
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ BookmarkDialog this$0;
            {
                BookmarkDialog bookmarkDialog = this$0;
                Objects.requireNonNull(bookmarkDialog);
                this.this$0 = bookmarkDialog;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.saveBounds();
                this.this$0.tableColumnSettingsManager.save();
                this.this$0.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.this$0.saveBounds();
            }
        });
    }

    private void saveBounds() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.lock(LockMode.WRITE);
        try {
            Rectangle b = this.getBounds();
            config.setProperty(BOOKMARK_POS_X, (Object)b.x);
            config.setProperty(BOOKMARK_POS_Y, (Object)b.y);
            config.setProperty(BOOKMARK_WIDTH, (Object)b.width);
            config.setProperty(BOOKMARK_HEIGHT, (Object)b.height);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreBounds() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.lock(LockMode.READ);
        try {
            int x = config.getInt(BOOKMARK_POS_X, 100);
            int y = config.getInt(BOOKMARK_POS_Y, 100);
            int w = config.getInt(BOOKMARK_WIDTH, 800);
            int h = config.getInt(BOOKMARK_HEIGHT, 600);
            this.setBounds(x, y, w, h);
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void setupNoteArea() {
        this.noteArea.setLineWrap(true);
        this.noteArea.setWrapStyleWord(true);
        this.noteArea.setEditable(false);
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab("Beschreibung", this.filmDescriptionPanel);
        JPanel notePanel = new JPanel(new BorderLayout());
        notePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        notePanel.add((Component)this.noteArea, "Center");
        tabbedPane.addTab("Notizen", notePanel);
        return tabbedPane;
    }

    private TableFormat<BookmarkData> getTableFormat() {
        String[] propertyNames = new String[]{"seen", "sender", "thema", "title", "dauer", "sendedatum", "AvailableUntil", "NormalQualityUrl", "note", "filmHashCode", "BookmarkAdded"};
        String[] columnLabels = new String[]{"Gesehen", "Sender", "Thema", "Titel", "Dauer", "Sendedatum", "Verf\u00fcgbar bis", "URL", "Notiz", "Hash Code", "hinzugef\u00fcgt am"};
        return new BeanTableFormat(BookmarkData.class, propertyNames, columnLabels);
    }

    private void disableSortableColumns(TableComparatorChooser<BookmarkData> comparatorChooser) {
        comparatorChooser.getComparatorsForColumn(7).clear();
        comparatorChooser.getComparatorsForColumn(9).clear();
        comparatorChooser.getComparatorsForColumn(8).clear();
        comparatorChooser.getComparatorsForColumn(0).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTable() {
        SortedList sortedList;
        ObservableElementList.Connector personConnector = GlazedLists.beanConnector(BookmarkData.class);
        EventList<BookmarkData> sourceEventList = Daten.getInstance().getListeBookmarkList().getEventList();
        sourceEventList.getReadWriteLock().readLock().lock();
        try {
            ObservableElementList observedBookmarks = new ObservableElementList(Daten.getInstance().getListeBookmarkList().getEventList(), personConnector);
            sortedList = new SortedList((EventList)observedBookmarks, (Comparator)new BookmarkAddedAtComparator());
        }
        finally {
            sourceEventList.getReadWriteLock().readLock().unlock();
        }
        AdvancedTableModel model = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)sortedList, this.getTableFormat());
        this.selectionModel = new DefaultEventSelectionModel((EventList)sortedList);
        this.selectionModel.addListSelectionListener(l -> {
            if (!l.getValueIsAdjusting()) {
                this.addNoteAction.setEnabled(this.selectionModel.getSelected().size() == 1 && !this.selectionModel.getSelected().isEmpty());
                this.updateInfoTabs();
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setModel((TableModel)model);
        this.table.setSelectionModel((ListSelectionModel)this.selectionModel);
        TableComparatorChooser comparatorChooser = TableComparatorChooser.install((JTable)this.table, (SortedList)sortedList, (Object)TableComparatorChooser.MULTIPLE_COLUMN_MOUSE);
        this.disableSortableColumns((TableComparatorChooser<BookmarkData>)comparatorChooser);
        this.sortPersister = new GlazedSortKeysPersister(CONFIG_PREFIX, comparatorChooser);
        this.sortPersister.restoreSortState();
        comparatorChooser.addSortActionListener(actionEvent -> this.sortPersister.saveSortState());
        this.setupCellRenderers();
        this.tableColumnSettingsManager = new BookmarkTableColumnSettingsManager(this.table, CONFIG_PREFIX, comparatorChooser);
        this.tableColumnSettingsManager.load();
        this.tableColumnSettingsManager.installContextMenu();
        this.installTableContextMenu();
    }

    private void setupCellRenderers() {
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn colSeen = columnModel.getColumn(0);
        colSeen.setCellRenderer(new SeenCellRenderer());
        colSeen.setHeaderRenderer(new IconHeaderCellRenderer((Icon)IconUtils.of((Ikon)MaterialDesignE.EYE), "Gesehen"));
        columnModel.getColumn(1).setCellRenderer(new CenteredCellRenderer());
        columnModel.getColumn(4).setCellRenderer(new FilmLengthCellRenderer());
        columnModel.getColumn(5).setCellRenderer(new CenteredCellRenderer());
        columnModel.getColumn(6).setCellRenderer(new AvailableUntilCellRenderer());
        TableColumn colNote = columnModel.getColumn(8);
        colNote.setCellRenderer(new NoteCellRenderer());
        colNote.setHeaderRenderer(new IconHeaderCellRenderer((Icon)IconUtils.of((Ikon)MaterialDesignN.NOTE), "Notiz vorhanden"));
        columnModel.getColumn(10).setCellRenderer(new AddedAtCellRenderer());
    }

    private void setupToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        IconOnlyButton addNoteButton = new IconOnlyButton(this.addNoteAction);
        toolBar.add(addNoteButton);
        IconOnlyButton removeNoteButton = new IconOnlyButton(this.removeNoteAction);
        toolBar.add(removeNoteButton);
        toolBar.addSeparator();
        IconOnlyButton markSeenButton = new IconOnlyButton(this.markSeenAction);
        toolBar.add(markSeenButton);
        IconOnlyButton markUnseenButton = new IconOnlyButton(this.markUnseenAction);
        toolBar.add(markUnseenButton);
        toolBar.addSeparator();
        IconOnlyButton deleteEntryButton = new IconOnlyButton(this.deleteBookmarkAction);
        toolBar.add(deleteEntryButton);
        this.getContentPane().add((Component)toolBar, "North");
    }

    private void updateInfoTabs() {
        EventList selectedBookmarks = this.selectionModel.getSelected();
        if (selectedBookmarks.size() == 1) {
            BookmarkData bookmark = (BookmarkData)selectedBookmarks.getFirst();
            bookmark.getDatenFilmOptional().ifPresentOrElse(film -> {
                this.filmDescriptionPanel.setCurrentFilm((DatenFilm)film);
                this.noteArea.setText(Objects.requireNonNullElse(bookmark.getNote(), ""));
            }, () -> {
                this.filmDescriptionPanel.setCurrentFilm(null);
                this.noteArea.setText("");
            });
        } else {
            this.filmDescriptionPanel.setCurrentFilm(null);
            this.noteArea.setText("");
        }
    }

    class AddNoteAction
    extends AbstractAction {
        final /* synthetic */ BookmarkDialog this$0;

        public AddNoteAction(BookmarkDialog this$0) {
            BookmarkDialog bookmarkDialog = this$0;
            Objects.requireNonNull(bookmarkDialog);
            this.this$0 = bookmarkDialog;
            this.putValue("Name", "Notiz hinzuf\u00fcgen...");
            this.putValue("ShortDescription", "Notiz hinzuf\u00fcgen");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)FontAwesomeRegular.EDIT));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkData bm = (BookmarkData)this.this$0.selectionModel.getSelected().getFirst();
            BookmarkEditNoteDialog dialog = new BookmarkEditNoteDialog((Dialog)this.this$0, bm);
            dialog.setVisible(true);
            if (dialog.isOkPressed()) {
                String notizText = dialog.getNotiz();
                if (notizText.isBlank()) {
                    notizText = null;
                }
                bm.setNote(notizText);
                LocalDate availableDate = dialog.getAvailableUntilDate();
                bm.setAvailableUntil(availableDate);
                Daten.getInstance().getListeBookmarkList().saveToFile();
                this.this$0.updateInfoTabs();
            }
        }
    }

    class MarkSeenAction
    extends AbstractAction {
        final /* synthetic */ BookmarkDialog this$0;

        public MarkSeenAction(BookmarkDialog this$0) {
            BookmarkDialog bookmarkDialog = this$0;
            Objects.requireNonNull(bookmarkDialog);
            this.this$0 = bookmarkDialog;
            this.putValue("Name", "Als gesehen markieren");
            this.putValue("ShortDescription", "Als gesehen markieren");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)MaterialDesignE.EYE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> selFilms = this.this$0.selectionModel.getSelected().stream().filter(bookmark -> bookmark.getDatenFilmOptional().isPresent()).map(bookmark -> bookmark.getDatenFilmOptional().get()).toList();
            try (SeenHistoryController controller = new SeenHistoryController();){
                controller.markSeen(selFilms);
            }
        }
    }

    class MarkUnseenAction
    extends AbstractAction {
        final /* synthetic */ BookmarkDialog this$0;

        public MarkUnseenAction(BookmarkDialog this$0) {
            BookmarkDialog bookmarkDialog = this$0;
            Objects.requireNonNull(bookmarkDialog);
            this.this$0 = bookmarkDialog;
            this.putValue("Name", "Als ungesehen markieren");
            this.putValue("ShortDescription", "Als ungesehen markieren");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)MaterialDesignE.EYE_OFF));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> selFilms = this.this$0.selectionModel.getSelected().stream().filter(bookmark -> bookmark.getDatenFilmOptional().isPresent()).map(bookmark -> bookmark.getDatenFilmOptional().get()).toList();
            try (SeenHistoryController controller = new SeenHistoryController();){
                controller.markUnseen(selFilms);
            }
        }
    }

    class RemoveNoteAction
    extends AbstractAction {
        final /* synthetic */ BookmarkDialog this$0;

        public RemoveNoteAction(BookmarkDialog this$0) {
            BookmarkDialog bookmarkDialog = this$0;
            Objects.requireNonNull(bookmarkDialog);
            this.this$0 = bookmarkDialog;
            this.putValue("Name", "Notiz l\u00f6schen...");
            this.putValue("ShortDescription", "Notiz l\u00f6schen");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)FontAwesomeSolid.ERASER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.this$0.selectionModel.isSelectionEmpty()) {
                this.this$0.selectionModel.getSelected().forEach(bookmark -> bookmark.setNote(null));
                Daten.getInstance().getListeBookmarkList().saveToFile();
                this.this$0.updateInfoTabs();
            }
        }
    }

    class DeleteBookmarkAction
    extends AbstractAction {
        final /* synthetic */ BookmarkDialog this$0;

        public DeleteBookmarkAction(BookmarkDialog this$0) {
            BookmarkDialog bookmarkDialog = this$0;
            Objects.requireNonNull(bookmarkDialog);
            this.this$0 = bookmarkDialog;
            this.putValue("Name", "Aus Merkliste l\u00f6schen...");
            this.putValue("ShortDescription", "Aus Merkliste l\u00f6schen");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)FontAwesomeRegular.TRASH_ALT));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkDataList bookmarkList = Daten.getInstance().getListeBookmarkList();
            ArrayList list = new ArrayList(this.this$0.selectionModel.getSelected());
            for (BookmarkData bookmark : list) {
                bookmarkList.removeBookmark(bookmark);
            }
            bookmarkList.saveToFile();
            SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.repaint());
        }
    }
}

