/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.icons.FlatSearchWithHistoryIcon;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.FilmResolution;
import mediathek.daten.IndexedFilmList;
import mediathek.daten.ListeDownloads;
import mediathek.daten.ListeFilme;
import mediathek.daten.ListePset;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.filmlisten.writer.FilmListWriter;
import mediathek.gui.actions.DeleteBookmarksAction;
import mediathek.gui.actions.ManageBookmarkAction;
import mediathek.gui.actions.PlayFilmAction;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.bookmark.BookmarkDataList;
import mediathek.gui.bookmark.BookmarkDialog;
import mediathek.gui.dialog.DialogAboNoSet;
import mediathek.gui.dialog.add_download.DialogAddDownloadWithCoroutines;
import mediathek.gui.dialog.add_download.DialogAddMoreDownload;
import mediathek.gui.duplicates.details.DuplicateFilmDetailsDialog;
import mediathek.gui.filmInformation.FilmInfoDialog;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.ButtonStartEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.ReloadTableDataEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.gui.messages.history.DownloadHistoryChangedEvent;
import mediathek.gui.tabs.AGuiTabPanel;
import mediathek.gui.tabs.tab_film.DownloadSubtitleAction;
import mediathek.gui.tabs.tab_film.EditHistoryDialog;
import mediathek.gui.tabs.tab_film.FilmDescriptionPanel;
import mediathek.gui.tabs.tab_film.FilmToolBar;
import mediathek.gui.tabs.tab_film.JDownloadHelper;
import mediathek.gui.tabs.tab_film.OnlineSearchProviders;
import mediathek.gui.tabs.tab_film.PsetButtonsPanel;
import mediathek.gui.tabs.tab_film.SearchControlFieldMode;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.gui.tabs.tab_film.filter.SwingFilterDialog;
import mediathek.gui.tabs.tab_film.filter_selection.FilterSelectionComboBoxModel;
import mediathek.gui.tabs.tab_film.helpers.GuiFilmeModelHelper;
import mediathek.gui.tabs.tab_film.helpers.GuiModelHelper;
import mediathek.gui.tabs.tab_film.helpers.LuceneGuiFilmeModelHelper;
import mediathek.mainwindow.MediathekGui;
import mediathek.swing.IconUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FileDialogs;
import mediathek.tool.Filter;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVInfoFile;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.cellrenderer.CellRendererFilme;
import mediathek.tool.datum.DatumFilm;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelFilm;
import mediathek.tool.table.MVFilmTable;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome6.FontAwesomeSolid;
import org.kordamp.ikonli.materialdesign2.MaterialDesignF;

public class GuiFilme
extends AGuiTabPanel {
    public static final String NAME = "Filme";
    private static final String ACTION_MAP_KEY_PLAY_FILM = "film_abspielen";
    private static final String ACTION_MAP_KEY_SAVE_FILM = "download_film";
    private static final String ACTION_MAP_KEY_BOOKMARK_FILM = "bookmark_film";
    private static final String ACTION_MAP_KEY_COPY_NORMAL_URL = "copy_url";
    private static final String ACTION_MAP_KEY_COPY_HD_URL = "copy_url_hd";
    private static final String ACTION_MAP_KEY_COPY_KLEIN_URL = "copy_url_klein";
    private static final String ACTION_MAP_KEY_MARK_SEEN = "seen";
    private static final String ACTION_MAP_KEY_MARK_UNSEEN = "unseen";
    private static final int[] HIDDEN_COLUMNS = new int[]{4, 5, 6};
    private static final Logger logger = LogManager.getLogger();
    private static final int[] BUTTON_COLUMNS = new int[]{4, 5, 6};
    public static final boolean[] VISIBLE_COLUMNS = new boolean[17];
    public final PlayFilmAction playFilmAction = new PlayFilmAction(this);
    public final SaveFilmAction saveFilmAction = new SaveFilmAction(this);
    public final CopyUrlToClipboardAction copyHqUrlToClipboardAction = new CopyUrlToClipboardAction(this, FilmResolution.Enum.HIGH_QUALITY);
    public final CopyUrlToClipboardAction copyNormalUrlToClipboardAction = new CopyUrlToClipboardAction(this, FilmResolution.Enum.NORMAL);
    protected final JTabbedPane psetButtonsTab = new JTabbedPane();
    protected final FilterSelectionComboBoxModel filterSelectionComboBoxModel = new FilterSelectionComboBoxModel();
    private final BookmarkAddFilmAction bookmarkAddFilmAction = new BookmarkAddFilmAction(this);
    private final BookmarkRemoveFilmAction bookmarkRemoveFilmAction = new BookmarkRemoveFilmAction(this);
    private final DeleteBookmarksAction deleteBookmarksAction = new DeleteBookmarksAction(MediathekGui.ui());
    private final ManageBookmarkAction manageBookmarkAction = new ManageBookmarkAction(MediathekGui.ui());
    private final AGuiTabPanel.MarkFilmAsSeenAction markFilmAsSeenAction = new AGuiTabPanel.MarkFilmAsSeenAction(this);
    private final AGuiTabPanel.MarkFilmAsUnseenAction markFilmAsUnseenAction = new AGuiTabPanel.MarkFilmAsUnseenAction(this);
    private final JScrollPane filmListScrollPane = new JScrollPane();
    private final JCheckBoxMenuItem cbkShowDescription = new JCheckBoxMenuItem("Beschreibung anzeigen");
    private final SeenHistoryController historyController = new SeenHistoryController();
    private final JCheckBoxMenuItem cbShowButtons = new JCheckBoxMenuItem("Buttons anzeigen");
    private final NonRepeatingTimer zeitraumTimer;
    private final NonRepeatingTimer reloadTableDataTimer;
    private final FilterConfiguration filterConfiguration = new FilterConfiguration();
    private final FilmToolBar filmToolBar;
    public final SwingFilterDialog swingFilterDialog;
    public final ToggleFilterDialogVisibilityAction toggleFilterDialogVisibilityAction = new ToggleFilterDialogVisibilityAction(this);
    protected final SearchField searchField;
    protected PsetButtonsPanel psetButtonsPanel;
    private boolean stopBeob;
    private MVFilmTable tabelle;
    private ListenableFuture<TableModel> modelFuture;
    public JDialog bookmarkDialog;

    public GuiFilme(Daten aDaten, MediathekGui mediathekGui) {
        this.daten = aDaten;
        this.mediathekGui = mediathekGui;
        this.descriptionPanel = new FilmDescriptionPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.filmListScrollPane, "Center");
        JPanel extensionArea = new JPanel((LayoutManager)new VerticalLayout());
        this.add((Component)extensionArea, "South");
        this.searchField = this.daten.getListeFilmeNachBlackList() instanceof IndexedFilmList ? new LuceneSearchField(this) : new RegularSearchField(this);
        extensionArea.add(this.descriptionTab);
        extensionArea.add(this.psetButtonsTab);
        this.setupFilmListTable();
        this.setupFilmSelectionPropertyListener();
        this.setupDescriptionTab(this.tabelle, this.cbkShowDescription, "film.show_description", this::getCurrentlySelectedFilm);
        this.setupPsetButtonsTab();
        this.filmToolBar = new FilmToolBar(this.filterSelectionComboBoxModel, this.bookmarkAddFilmAction, this.bookmarkRemoveFilmAction, this.deleteBookmarksAction, this.manageBookmarkAction, this.playFilmAction, this.saveFilmAction, this.searchField, this.toggleFilterDialogVisibilityAction);
        this.add((Component)this.filmToolBar, "North");
        this.swingFilterDialog = new SwingFilterDialog((Window)mediathekGui, this.filterSelectionComboBoxModel, this.filmToolBar.getToggleFilterDialogVisibilityButton(), this.filterConfiguration);
        this.setupTable();
        this.zeitraumTimer = new NonRepeatingTimer(actionEvent -> {
            this.swingFilterDialog.senderList.selectNone();
            MessageBus.getMessageBus().publish((Object)new FilterZeitraumEvent());
        });
        this.reloadTableDataTimer = new NonRepeatingTimer(actionEvent -> this.loadTable());
        MessageBus.getMessageBus().subscribe((Object)this);
        this.setupActionListeners();
    }

    public FilterConfiguration getFilterConfiguration() {
        return this.filterConfiguration;
    }

    private void updateBookmarkListAndRefresh(List<DatenFilm> filmList) {
        BookmarkDataList bookmarkList = Daten.getInstance().getListeBookmarkList();
        bookmarkList.checkAndBookmarkMovies(filmList);
        bookmarkList.saveToFile();
        this.repaint();
    }

    @Handler
    public void handleTableModelChange(TableModelChangeEvent e) {
        Consumer<Boolean> function = flag -> {
            this.playFilmAction.setEnabled((boolean)flag);
            this.saveFilmAction.setEnabled((boolean)flag);
            this.bookmarkAddFilmAction.setEnabled((boolean)flag);
            this.bookmarkRemoveFilmAction.setEnabled((boolean)flag);
            this.deleteBookmarksAction.setEnabled((boolean)flag);
            this.manageBookmarkAction.setEnabled((boolean)flag);
            this.filmToolBar.setEnabled((boolean)flag);
        };
        if (e.active) {
            SwingUtilities.invokeLater(() -> function.accept(false));
        } else {
            SwingUtilities.invokeLater(() -> {
                function.accept(true);
                if (e.fromSearchField) {
                    this.searchField.requestFocusInWindow();
                }
            });
        }
    }

    @Override
    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.writeTableConfigurationData();
        }
    }

    private void setupFilmListTable() {
        this.tabelle = new MVFilmTable();
        this.filmListScrollPane.setViewportView(this.tabelle);
    }

    private void setupFilmSelectionPropertyListener() {
        this.tabelle.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateSelectedListItemsCount(this.tabelle);
                int sel = this.tabelle.getSelectedRowCount();
                this.playFilmAction.setEnabled(sel <= 1);
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ GuiFilme this$0;
            {
                GuiFilme guiFilme = this$0;
                Objects.requireNonNull(guiFilme);
                this.this$0 = guiFilme;
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.this$0.updateSelectedListItemsCount(this.this$0.tabelle);
                this.this$0.onComponentShown();
            }
        });
    }

    public void installViewMenuEntry(JMenu jMenuAnsicht) {
        jMenuAnsicht.add((Component)this.cbShowButtons, 0);
    }

    protected void makeButtonsTabVisible(boolean visible) {
        if (visible) {
            if (this.psetButtonsTab.indexOfComponent(this.psetButtonsPanel) == -1) {
                this.psetButtonsTab.add((Component)this.psetButtonsPanel, 0);
                this.psetButtonsTab.setTitleAt(0, "Buttons");
            }
        } else if (this.psetButtonsTab.indexOfComponent(this.psetButtonsPanel) != -1) {
            this.psetButtonsTab.remove(this.psetButtonsPanel);
        }
    }

    @Override
    public void installMenuEntries(JMenu menu) {
        menu.add(this.playFilmAction);
        menu.add(this.saveFilmAction);
        menu.add(this.bookmarkAddFilmAction);
        menu.addSeparator();
        menu.add(this.markFilmAsSeenAction);
        menu.add(this.markFilmAsUnseenAction);
        menu.addSeparator();
        menu.add(this.mediathekGui.toggleBlacklistAction);
        menu.add(this.mediathekGui.editBlacklistAction);
        menu.addSeparator();
        menu.add(this.cbkShowDescription);
    }

    private void setupPsetButtonsTab() {
        boolean initialVisibility = ApplicationConfiguration.getConfiguration().getBoolean("application.buttons_panel.visible", false);
        this.setupButtonsMenuItem(initialVisibility);
        this.psetButtonsPanel = new PsetButtonsPanel(this);
        this.psetButtonsPanel.putClientProperty("JTabbedPane.tabClosable", true);
        this.psetButtonsPanel.putClientProperty("JTabbedPane.tabCloseCallback", n -> this.cbShowButtons.doClick());
        this.psetButtonsPanel.install(this.psetButtonsTab);
        this.makeButtonsTabVisible(initialVisibility);
    }

    private void setupButtonsMenuItem(boolean initialVisibility) {
        Configuration config = ApplicationConfiguration.getConfiguration();
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.cbShowButtons.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        }
        this.cbShowButtons.setSelected(initialVisibility);
        this.cbShowButtons.addActionListener(actionEvent -> {
            boolean visible = this.cbShowButtons.isSelected();
            this.makeButtonsTabVisible(visible);
            config.setProperty("application.buttons_panel.visible", (Object)visible);
        });
    }

    private void onComponentShown() {
        this.updateFilmData();
        this.updateStartInfoProperty();
    }

    public int getTableRowCount() {
        if (this.tabelle != null) {
            return this.tabelle.getModel().getRowCount();
        }
        return 0;
    }

    private void setupKeyMapping() {
        InputMap focusedWindowMap = this.tabelle.getInputMap();
        focusedWindowMap.put(KeyStroke.getKeyStroke(80, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(68, 0), ACTION_MAP_KEY_SAVE_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(66, 0), ACTION_MAP_KEY_BOOKMARK_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(72, 0), ACTION_MAP_KEY_COPY_HD_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(78, 0), ACTION_MAP_KEY_COPY_NORMAL_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(75, 0), ACTION_MAP_KEY_COPY_KLEIN_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(71, 0), ACTION_MAP_KEY_MARK_SEEN);
        focusedWindowMap.put(KeyStroke.getKeyStroke(85, 0), ACTION_MAP_KEY_MARK_UNSEEN);
        ActionMap actionMap = this.tabelle.getActionMap();
        actionMap.put(ACTION_MAP_KEY_PLAY_FILM, this.playFilmAction);
        actionMap.put(ACTION_MAP_KEY_SAVE_FILM, this.saveFilmAction);
        actionMap.put(ACTION_MAP_KEY_BOOKMARK_FILM, this.bookmarkAddFilmAction);
        actionMap.put(ACTION_MAP_KEY_COPY_NORMAL_URL, this.copyNormalUrlToClipboardAction);
        actionMap.put(ACTION_MAP_KEY_COPY_HD_URL, this.copyHqUrlToClipboardAction);
        actionMap.put(ACTION_MAP_KEY_COPY_KLEIN_URL, new CopyUrlToClipboardAction(this, FilmResolution.Enum.LOW));
        actionMap.put(ACTION_MAP_KEY_MARK_SEEN, this.markFilmAsSeenAction);
        actionMap.put(ACTION_MAP_KEY_MARK_UNSEEN, this.markFilmAsUnseenAction);
    }

    private void setupCellRenderer() {
        CellRendererFilme cellRenderer = new CellRendererFilme();
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(DatumFilm.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
    }

    private void setupTable() {
        this.setupKeyMapping();
        this.tabelle.setModel(new TModelFilm());
        this.tabelle.addMouseListener(new TableContextMenuHandler(this));
        this.tabelle.getSelectionModel().addListSelectionListener(event -> {
            ListSelectionModel m = (ListSelectionModel)event.getSource();
            if (!(m.isSelectionEmpty() || m.getValueIsAdjusting() || this.stopBeob)) {
                this.updateFilmData();
            }
        });
        this.setupCellRenderer();
        this.tabelle.setLineBreak(MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK));
        this.setupHeaderPopupMenu();
        this.tabelle.readColumnConfigurationData();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupHeaderPopupMenu() {
        BeobTableHeader headerListener = new BeobTableHeader(this.tabelle, VISIBLE_COLUMNS, HIDDEN_COLUMNS, BUTTON_COLUMNS, true, MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK);
        this.tabelle.getTableHeader().addMouseListener(headerListener);
    }

    @Handler
    private void handleDownloadHistoryChangedEvent(DownloadHistoryChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (this.filterConfiguration.isShowUnseenOnly()) {
                MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
            } else {
                this.tabelle.fireTableDataChanged(true);
            }
        });
    }

    @Handler
    private void handleButtonStart(ButtonStartEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelle.fireTableDataChanged(true);
            this.updateStartInfoProperty();
        });
    }

    @Handler
    private void handleStartEvent(StartEvent msg) {
        GuiFilme guiFilme = this;
        SwingUtilities.invokeLater(() -> guiFilme.updateStartInfoProperty());
    }

    private synchronized void saveFilm(@Nullable DatenPset pSet) {
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            DialogAboNoSet dialog = new DialogAboNoSet(this.mediathekGui);
            dialog.setVisible(true);
            return;
        }
        if (pSet == null) {
            pSet = (DatenPset)Daten.listePset.getListeSpeichern().getFirst();
        }
        List<DatenFilm> selectedFilmsList = this.getSelFilme();
        ListeDownloads downloadsList = this.daten.getListeDownloads();
        if (selectedFilmsList.size() > 1) {
            DialogAddMoreDownload damd = new DialogAddMoreDownload(this.mediathekGui, pSet);
            DialogAddMoreDownload.DialogResult result2 = damd.showDialog();
            if (!damd.wasCancelled()) {
                for (DatenFilm film : selectedFilmsList) {
                    int ret;
                    if (downloadsList.getDownloadUrlFilm(film.getUrlNormalQuality()) != null && (ret = JOptionPane.showConfirmDialog(this.mediathekGui, "Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", "MediathekView", 0)) == 1) continue;
                    if (result2.addAllWithDefaults()) {
                        DatenDownload datenDownload = new DatenDownload(pSet, film, 2, null, "", result2.path(), "", result2.info(), result2.subtitle());
                        downloadsList.addMitNummer(datenDownload);
                        MessageBus.getMessageBus().publishAsync((Object)new DownloadListChangedEvent());
                        if (!result2.startImmediately()) continue;
                        datenDownload.startDownload();
                        continue;
                    }
                    this.saveFilmObject(film, pSet);
                }
            }
        } else {
            int ret;
            DatenFilm film = selectedFilmsList.getFirst();
            if (downloadsList.getDownloadUrlFilm(film.getUrlNormalQuality()) != null && (ret = JOptionPane.showConfirmDialog(this.mediathekGui, "Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", "MediathekView", 0)) == 1) {
                return;
            }
            this.saveFilmObject(film, pSet);
        }
    }

    private void saveFilmObject(@NotNull DatenFilm datenFilm, @NotNull DatenPset pSet) {
        Optional<FilmResolution.Enum> res = this.filterConfiguration.isShowHighQualityOnly() ? Optional.of(FilmResolution.Enum.HIGH_QUALITY) : Optional.empty();
        DialogAddDownloadWithCoroutines dialog = new DialogAddDownloadWithCoroutines((Frame)this.mediathekGui, datenFilm, pSet, res);
        dialog.setVisible(true);
    }

    public void showManageBookmarkWindow() {
        if (this.bookmarkDialog == null) {
            this.bookmarkDialog = new BookmarkDialog(this.mediathekGui);
            this.bookmarkDialog.setVisible(true);
        } else {
            this.bookmarkDialog.setVisible(true);
        }
    }

    public void playerStarten(DatenPset pSet) {
        if (this.tabelle.getSelectedRow() == -1) {
            NoSelectionErrorDialog.show(this);
        } else if (pSet.istSpeichern()) {
            this.saveFilm(pSet);
        } else {
            String aufloesung = this.filterConfiguration.isShowHighQualityOnly() ? FilmResolution.Enum.HIGH_QUALITY.toString() : "";
            this.getCurrentlySelectedFilm().ifPresent(film -> this.daten.getStarterClass().urlMitProgrammStarten(pSet, (DatenFilm)film, aufloesung));
        }
    }

    private Optional<DatenFilm> getFilm(int zeileTabelle) {
        if (zeileTabelle >= 0 && zeileTabelle < this.tabelle.getRowCount()) {
            return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(zeileTabelle), 16));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DatenFilm> getCurrentlySelectedFilm() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow != -1) {
            try {
                int modelIndex = this.tabelle.convertRowIndexToModel(selectedTableRow);
                return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(modelIndex, 16));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenFilm datenFilm = (DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 16);
                arrayFilme.add(datenFilm);
            }
        } else {
            NoSelectionErrorDialog.show(this);
        }
        return arrayFilme;
    }

    private void updateFilmData() {
        FilmInfoDialog infoDialog = this.mediathekGui.getFilmInfoDialog();
        if (infoDialog != null) {
            Optional<DatenFilm> filmSelection = this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(infoDialog::updateCurrentFilm);
        }
    }

    @Handler
    private void handleReloadTableDataEvent(ReloadTableDataEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (!this.reloadTableDataTimer.isRunning()) {
                this.reloadTableDataTimer.start();
            } else {
                this.reloadTableDataTimer.restart();
            }
        });
    }

    @Handler
    private void handleFilterZeitraumEvent(FilterZeitraumEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.daten.getListeBlacklist().filterListe();
            MessageBus.getMessageBus().publish((Object)new ReloadTableDataEvent());
        });
    }

    private void setupActionListeners() {
        this.swingFilterDialog.spZeitraum.addChangeListener(changeEvent -> {
            if (!this.zeitraumTimer.isRunning()) {
                this.zeitraumTimer.start();
            } else {
                this.zeitraumTimer.restart();
            }
        });
    }

    @Override
    protected void setupShowFilmDescriptionMenuItem() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.cbkShowDescription.setAccelerator(KeyStroke.getKeyStroke(121, 0));
        this.cbkShowDescription.setSelected(config.getBoolean("film.show_description", true));
        this.cbkShowDescription.addActionListener(actionEvent -> {
            boolean visible = this.cbkShowDescription.isSelected();
            this.makeDescriptionTabVisible(visible);
            config.setProperty("film.show_description", (Object)visible);
        });
    }

    private void loadTable() {
        this.loadTable(false);
    }

    private void loadTable(final boolean from_search_field) {
        if (this.modelFuture != null && !this.modelFuture.isDone()) {
            return;
        }
        final MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publish((Object)new TableModelChangeEvent(true, from_search_field));
        this.stopBeob = true;
        this.tabelle.getSpalten();
        this.tabelle.setEnabled(false);
        ListeningExecutorService decoratedPool = this.daten.getDecoratedPool();
        this.modelFuture = decoratedPool.submit(() -> {
            SearchFieldData searchFieldData = new SearchFieldData(this.searchField.getText(), this.searchField.getSearchMode());
            GuiModelHelper helper = GuiModelHelperFactory.createGuiModelHelper(this.historyController, searchFieldData, this.filterConfiguration);
            return helper.getFilteredTableModel();
        });
        Futures.addCallback(this.modelFuture, (FutureCallback)new FutureCallback<TableModel>(this){
            final /* synthetic */ GuiFilme this$0;
            {
                GuiFilme guiFilme = this$0;
                Objects.requireNonNull(guiFilme);
                this.this$0 = guiFilme;
            }

            public void onSuccess(TableModel model) {
                SwingUtilities.invokeLater(() -> {
                    this.this$0.tabelle.setModel(model);
                    this.this$0.tabelle.setEnabled(true);
                    this.this$0.updateStartInfoProperty();
                    this.this$0.tabelle.setSpalten();
                    this.this$0.updateFilmData();
                    this.this$0.stopBeob = false;
                    this.this$0.tabelle.scrollToSelection();
                    messageBus.publish((Object)new TableModelChangeEvent(false, from_search_field));
                });
            }

            public void onFailure(@NotNull Throwable thrown) {
                logger.error("Model filtering failed!", thrown);
                SwingUtilities.invokeLater(() -> {
                    this.this$0.tabelle.setEnabled(true);
                    this.this$0.updateStartInfoProperty();
                    this.this$0.tabelle.setSpalten();
                    this.this$0.updateFilmData();
                    this.this$0.stopBeob = false;
                    messageBus.publish((Object)new TableModelChangeEvent(false, from_search_field));
                });
            }
        }, (Executor)decoratedPool);
    }

    public class SaveFilmAction
    extends AbstractAction {
        final /* synthetic */ GuiFilme this$0;

        public SaveFilmAction(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            this.putValue("ShortDescription", "Film downloaden");
            this.putValue("Name", "Film downloaden");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)FontAwesomeSolid.DOWNLOAD));
            KeyStroke keyStroke = SystemUtils.IS_OS_MAC_OSX ? KeyStroke.getKeyStroke(118, GuiFunktionen.getPlatformControlKey()) : KeyStroke.getKeyStroke(68, GuiFunktionen.getPlatformControlKey());
            this.putValue("AcceleratorKey", keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.this$0.saveFilm(null);
        }
    }

    public class CopyUrlToClipboardAction
    extends AbstractAction {
        private final FilmResolution.Enum resolution;
        final /* synthetic */ GuiFilme this$0;

        CopyUrlToClipboardAction(GuiFilme this$0, FilmResolution.Enum resolution) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            this.resolution = resolution;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional<DatenFilm> filmSelection = this.this$0.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(this.resolution)));
        }
    }

    public class BookmarkAddFilmAction
    extends AbstractAction {
        final /* synthetic */ GuiFilme this$0;

        public BookmarkAddFilmAction(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            KeyStroke keyStroke = SystemUtils.IS_OS_MAC_OSX ? KeyStroke.getKeyStroke(119, GuiFunktionen.getPlatformControlKey()) : KeyStroke.getKeyStroke(66, GuiFunktionen.getPlatformControlKey());
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", "Ausgew\u00e4hlte Filme in der Merkliste speichern");
            this.putValue("Name", "Ausgew\u00e4hlte Filme merken");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)MaterialDesignF.FILE_DOCUMENT_PLUS));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> tbdFilms;
            List<DatenFilm> selectedFilms = this.this$0.getSelFilme();
            if (!selectedFilms.isEmpty() && !(tbdFilms = selectedFilms.parallelStream().filter(f -> !f.isBookmarked()).filter(f -> !f.isLivestream()).toList()).isEmpty()) {
                this.this$0.updateBookmarkListAndRefresh(tbdFilms);
            }
        }
    }

    public class BookmarkRemoveFilmAction
    extends AbstractAction {
        final /* synthetic */ GuiFilme this$0;

        public BookmarkRemoveFilmAction(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            this.putValue("ShortDescription", "Ausgew\u00e4hlte Filme aus der Merkliste l\u00f6schen");
            this.putValue("Name", "Ausgew\u00e4hlte Filme aus der Merkliste l\u00f6schen");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)MaterialDesignF.FILE_DOCUMENT_MINUS));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> tbdFilms;
            List<DatenFilm> selectedFilms = this.this$0.getSelFilme();
            if (!selectedFilms.isEmpty() && !(tbdFilms = selectedFilms.parallelStream().filter(DatenFilm::isBookmarked).toList()).isEmpty()) {
                this.this$0.updateBookmarkListAndRefresh(tbdFilms);
            }
        }
    }

    public class ToggleFilterDialogVisibilityAction
    extends AbstractAction {
        final /* synthetic */ GuiFilme this$0;

        public ToggleFilterDialogVisibilityAction(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            this.putValue("Name", "Filterdialog anzeigen");
            this.putValue("ShortDescription", "Filter anzeigen");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)FontAwesomeSolid.FILTER));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(123, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean visible = this.this$0.swingFilterDialog.isVisible();
            visible = !visible;
            this.this$0.swingFilterDialog.setVisible(visible);
        }
    }

    public class LuceneSearchField
    extends SearchField {
        private static final Dimension LUCENE_DEFAULT_DIMENSION = new Dimension(700, 100);
        private final SearchField.SearchHistoryButton luceneSearchHistoryButton;
        final /* synthetic */ GuiFilme this$0;

        public LuceneSearchField(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            super(this$0);
            this.luceneSearchHistoryButton = new SearchField.SearchHistoryButton(this, SearchControlFieldMode.LUCENE);
            this.setMaximumSize(LUCENE_DEFAULT_DIMENSION);
            this.setSearchMode(SearchControlFieldMode.LUCENE);
            this.putClientProperty("JTextField.placeholderText", "Lucene Search Query");
            this.putClientProperty("JTextField.leadingComponent", this.luceneSearchHistoryButton);
        }

        @Override
        protected void createTrailingComponents() {
            JToolBar searchToolbar = new JToolBar();
            searchToolbar.addSeparator();
            JButton luceneBtn = new JButton();
            luceneBtn.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
            luceneBtn.setToolTipText("Lucene Query Syntax Hilfe");
            luceneBtn.addActionListener(actionEvent -> UrlHyperlinkAction.openURI(Konstanten.LUCENE_CLIENT_HELP_URL.uri()));
            searchToolbar.add(luceneBtn);
            this.putClientProperty("JTextField.trailingComponent", searchToolbar);
        }

        @Override
        protected void performSearch() {
            String searchText = this.getText();
            if (!searchText.isEmpty()) {
                this.luceneSearchHistoryButton.addHistoryEntry(searchText);
            }
            this.this$0.loadTable(true);
        }
    }

    public abstract class SearchField
    extends JTextField {
        private static final Dimension DEFAULT_DIMENSION = new Dimension(500, 100);
        private static final String SEARCHMODE_PROPERTY_STRING = "searchMode";
        protected final PropertyChangeSupport pcs;
        protected SearchControlFieldMode searchMode;
        final /* synthetic */ GuiFilme this$0;

        public SearchField(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            super("", 40);
            this.pcs = new PropertyChangeSupport(this);
            this.setMaximumSize(DEFAULT_DIMENSION);
            this.putClientProperty("JTextField.showClearButton", true);
            this.putClientProperty("JTextField.clearCallback", jTextComponent -> this.clearSearchField());
            this.addKeyListener(new EscapeKeyAdapter(this));
            this.addActionListener(actionEvent -> this.performSearch());
            this.createTrailingComponents();
            this.setupContextMenu();
        }

        private void setupContextMenu() {
            TextCopyPasteHandler<SearchField> handler = new TextCopyPasteHandler<SearchField>(this);
            this.setComponentPopupMenu(handler.getPopupMenu());
        }

        protected abstract void createTrailingComponents();

        protected abstract void performSearch();

        protected void clearSearchField() {
            this.setText("");
            this.fireActionPerformed();
        }

        public void addSearchModeChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(SEARCHMODE_PROPERTY_STRING, listener);
        }

        public SearchControlFieldMode getSearchMode() {
            return this.searchMode;
        }

        public void setSearchMode(SearchControlFieldMode mode) {
            SearchControlFieldMode oldValue = this.searchMode;
            this.searchMode = mode;
            this.pcs.firePropertyChange(SEARCHMODE_PROPERTY_STRING, (Object)oldValue, (Object)mode);
        }

        class EscapeKeyAdapter
        extends KeyAdapter {
            final /* synthetic */ SearchField this$1;

            EscapeKeyAdapter(SearchField this$1) {
                SearchField searchField = this$1;
                Objects.requireNonNull(searchField);
                this.this$1 = searchField;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    this.this$1.clearSearchField();
                }
            }
        }

        public class SearchHistoryButton
        extends JButton {
            private static final Logger logger = LogManager.getLogger();
            private final EventList<String> historyList;
            private final JMenuItem miClearHistory;
            private final JMenuItem miEditHistory;
            private String SEARCH_HISTORY_CONFIG;
            final /* synthetic */ SearchField this$1;

            public SearchHistoryButton(@Nullable SearchField this$1, SearchControlFieldMode mode) {
                SearchField searchField = this$1;
                Objects.requireNonNull(searchField);
                this.this$1 = searchField;
                super((Icon)new FlatSearchWithHistoryIcon(true));
                this.historyList = new BasicEventList();
                this.miClearHistory = new JMenuItem("Alles l\u00f6schen");
                this.miEditHistory = new JMenuItem("Eintr\u00e4ge bearbeiten");
                this.SEARCH_HISTORY_CONFIG = "search.history.items";
                this.setToolTipText("Vorherige Suchen");
                if (mode != null && mode == SearchControlFieldMode.LUCENE) {
                    this.SEARCH_HISTORY_CONFIG = this.SEARCH_HISTORY_CONFIG + "_lucene";
                }
                this.miClearHistory.addActionListener(actionEvent -> {
                    this.historyList.clear();
                    this.saveHistory();
                });
                this.miEditHistory.addActionListener(actionEvent -> {
                    EditHistoryDialog dlg = new EditHistoryDialog((Window)this$1.this$0.mediathekGui, this.miEditHistory, this.historyList);
                    dlg.setVisible(true);
                });
                this.addActionListener(actionEvent2 -> {
                    JPopupMenu popupMenu = new JPopupMenu();
                    popupMenu.add(this.miClearHistory);
                    popupMenu.add(this.miEditHistory);
                    this.historyList.getReadWriteLock().readLock().lock();
                    try {
                        if (!this.historyList.isEmpty()) {
                            popupMenu.addSeparator();
                            for (String item : this.historyList) {
                                JMenuItem historyItem = new JMenuItem(item);
                                historyItem.addActionListener(actionEvent -> {
                                    this$1.this$0.searchField.setText(item);
                                    this$1.this$0.searchField.fireActionPerformed();
                                });
                                popupMenu.add(historyItem);
                            }
                        }
                    }
                    finally {
                        this.historyList.getReadWriteLock().readLock().unlock();
                    }
                    popupMenu.show(this, 0, this.getHeight());
                });
                this.loadHistory();
                this.historyList.addListEventListener(listEvent -> this.saveHistory());
            }

            public void addHistoryEntry(String text) {
                if (!this.historyList.contains((Object)text)) {
                    this.historyList.addFirst((Object)text);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadHistory() {
                block5: {
                    try {
                        List entries;
                        ObjectMapper mapper = new ObjectMapper();
                        String json = ApplicationConfiguration.getConfiguration().getString(this.SEARCH_HISTORY_CONFIG, "");
                        if (json.isEmpty() || (entries = (List)mapper.readValue(json, (TypeReference)new TypeReference<List<String>>(this){
                            {
                                Objects.requireNonNull(this$2);
                            }
                        })).isEmpty()) break block5;
                        this.historyList.getReadWriteLock().writeLock().lock();
                        try {
                            this.historyList.addAll((Collection)entries);
                        }
                        finally {
                            this.historyList.getReadWriteLock().writeLock().unlock();
                        }
                    }
                    catch (JsonProcessingException ex) {
                        logger.error("Failed to load search history", (Throwable)ex);
                    }
                }
            }

            private void saveHistory() {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    this.historyList.getReadWriteLock().readLock().lock();
                    try {
                        String json = mapper.writeValueAsString(this.historyList);
                        ApplicationConfiguration.getConfiguration().setProperty(this.SEARCH_HISTORY_CONFIG, (Object)json);
                    }
                    finally {
                        this.historyList.getReadWriteLock().readLock().unlock();
                    }
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to write search history", (Throwable)e);
                }
            }
        }
    }

    public class RegularSearchField
    extends SearchField {
        private final SearchField.SearchHistoryButton regularSearchHistoryButton;
        final /* synthetic */ GuiFilme this$0;

        public RegularSearchField(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            super(this$0);
            this.regularSearchHistoryButton = new SearchField.SearchHistoryButton(this, null);
            this.addSearchModeChangeListener(propertyChangeEvent -> this.setupHelperTexts());
            this.setupPlaceholderText();
            this.putClientProperty("JTextField.leadingComponent", this.regularSearchHistoryButton);
            this.installDocumentListener();
        }

        protected void setupPlaceholderText() {
            boolean bSearchThroughDescription = ApplicationConfiguration.getConfiguration().getBoolean("searchfield.film.search_through_description", false);
            if (bSearchThroughDescription) {
                this.setSearchMode(SearchControlFieldMode.IRGENDWO);
            } else {
                this.setSearchMode(SearchControlFieldMode.THEMA_TITEL);
            }
        }

        @Override
        protected void performSearch() {
            String searchText = this.getText();
            if (!searchText.isEmpty()) {
                this.regularSearchHistoryButton.addHistoryEntry(searchText);
            }
            this.this$0.loadTable(true);
        }

        private void installDocumentListener() {
            this.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ RegularSearchField this$1;
                {
                    RegularSearchField regularSearchField = this$1;
                    Objects.requireNonNull(regularSearchField);
                    this.this$1 = regularSearchField;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.doCheck();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.doCheck();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.doCheck();
                }

                private void doCheck() {
                    String searchText = this.this$1.getText();
                    this.this$1.checkPatternValidity(searchText);
                    this.this$1.setForegroundTextColor(searchText);
                }
            });
        }

        private void setForegroundTextColor(String text) {
            if (Filter.isPattern(text)) {
                this.setForeground(MVColor.getRegExPatternColor());
            } else {
                this.setForeground(UIManager.getColor("TextField.foreground"));
            }
        }

        private boolean isPatternValid(String text) {
            return Filter.makePatternNoCache(text) != null;
        }

        private void checkPatternValidity(String text) {
            if (Filter.isPattern(text)) {
                GuiFunktionen.showErrorIndication(this, !this.isPatternValid(text));
            } else {
                GuiFunktionen.showErrorIndication(this, false);
            }
        }

        private void setupHelperTexts() {
            String text = switch (this.searchMode) {
                case SearchControlFieldMode.IRGENDWO -> "Thema/Titel/Beschreibung";
                case SearchControlFieldMode.THEMA_TITEL -> "Thema/Titel";
                case SearchControlFieldMode.LUCENE -> "Lucene Query";
                default -> {
                    logger.error("Illegal search mode");
                    yield "";
                }
            };
            this.putClientProperty("JTextField.placeholderText", text);
            if (this.searchMode == SearchControlFieldMode.IRGENDWO || this.searchMode == SearchControlFieldMode.THEMA_TITEL) {
                this.setToolTipText(text + " durchsuchen");
            } else {
                this.setToolTipText("Lucene Query Syntax f\u00fcr die Suche");
            }
        }

        @Override
        protected void createTrailingComponents() {
            JToolBar searchToolbar = new JToolBar();
            searchToolbar.addSeparator();
            searchToolbar.add(new ToggleSearchFieldToggleButton(this));
            this.putClientProperty("JTextField.trailingComponent", searchToolbar);
        }

        class ToggleSearchFieldToggleButton
        extends JToggleButton {
            final /* synthetic */ RegularSearchField this$1;

            public ToggleSearchFieldToggleButton(RegularSearchField this$1) {
                RegularSearchField regularSearchField = this$1;
                Objects.requireNonNull(regularSearchField);
                this.this$1 = regularSearchField;
                FlatSVGIcon selectedIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/envelope-open-text.svg");
                selectedIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> MVColor.getSelectedColor()));
                FlatSVGIcon normalIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/envelope-open-text.svg");
                normalIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> Color.GRAY));
                this.setIcon((Icon)normalIcon);
                this.setSelectedIcon((Icon)selectedIcon);
                boolean bSearchThroughDescription = ApplicationConfiguration.getConfiguration().getBoolean("searchfield.film.search_through_description", false);
                this.setSelected(bSearchThroughDescription);
                this.setupToolTip(bSearchThroughDescription);
                this.addActionListener(actionEvent -> {
                    switch (this$1.getSearchMode()) {
                        case IRGENDWO: {
                            this$1.setSearchMode(SearchControlFieldMode.THEMA_TITEL);
                            this.setupToolTip(false);
                            break;
                        }
                        case THEMA_TITEL: {
                            this$1.setSearchMode(SearchControlFieldMode.IRGENDWO);
                            this.setupToolTip(true);
                        }
                    }
                    ApplicationConfiguration.getConfiguration().setProperty("searchfield.film.search_through_description", (Object)(this$1.getSearchMode() == SearchControlFieldMode.IRGENDWO ? 1 : 0));
                    this$1.this$0.loadTable();
                });
            }

            private void setupToolTip(boolean active) {
                if (active) {
                    this.setToolTipText("Suche in Beschreibung aktiviert");
                } else {
                    this.setToolTipText("Suche in Beschreibung deaktiviert");
                }
            }
        }
    }

    static class NonRepeatingTimer
    extends Timer {
        public NonRepeatingTimer(ActionListener listener) {
            super(250, listener);
            this.setRepeats(false);
            this.setCoalesce(true);
        }
    }

    class TableContextMenuHandler
    extends MouseAdapter {
        private final BeobPrint beobPrint;
        private final BeobAbo beobAbo;
        private final BeobAbo beobAboMitTitel;
        private final BeobBlacklist beobBlacklistSender;
        private final BeobBlacklist beobBlacklistSenderThema;
        private final BeobBlacklist beobBlacklistThema;
        private final ActionListener unseenActionListener;
        private final ActionListener seenActionListener;
        private final JDownloadHelper jDownloadHelper;
        private final DownloadSubtitleAction downloadSubtitleAction;
        private Point p;
        final /* synthetic */ GuiFilme this$0;

        TableContextMenuHandler(GuiFilme this$0) {
            GuiFilme guiFilme = this$0;
            Objects.requireNonNull(guiFilme);
            this.this$0 = guiFilme;
            this.beobPrint = new BeobPrint(this);
            this.beobAbo = new BeobAbo(this, false);
            this.beobAboMitTitel = new BeobAbo(this, true);
            this.beobBlacklistSender = new BeobBlacklist(this, true, false);
            this.beobBlacklistSenderThema = new BeobBlacklist(this, true, true);
            this.beobBlacklistThema = new BeobBlacklist(this, false, true);
            this.unseenActionListener = new BeobHistory(this, false);
            this.seenActionListener = new BeobHistory(this, true);
            this.jDownloadHelper = new JDownloadHelper();
            this.downloadSubtitleAction = new DownloadSubtitleAction(this.this$0);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                FilmInfoDialog infoDialog;
                if (e.getClickCount() == 1) {
                    this.p = e.getPoint();
                    int row = this.this$0.tabelle.rowAtPoint(this.p);
                    int column = this.this$0.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (e.getClickCount() > 1 && (infoDialog = this.this$0.mediathekGui.getFilmInfoDialog()) != null && !infoDialog.isVisible()) {
                    infoDialog.showInfo();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                switch (this.this$0.tabelle.convertColumnIndexToModel(column)) {
                    case 4: {
                        this.this$0.getCurrentlySelectedFilm().ifPresent(film -> {
                            boolean dontPlay = false;
                            DatenDownload download = this.this$0.daten.getListeDownloadsButton().getDownloadUrlFilm(film.getUrlNormalQuality());
                            if (download != null && download.start != null && download.start.status == 2) {
                                dontPlay = true;
                                this.this$0.daten.getListeDownloadsButton().delDownloadButton(film.getUrlNormalQuality());
                            }
                            if (!dontPlay) {
                                this.this$0.playFilmAction.actionPerformed(null);
                            }
                        });
                        break;
                    }
                    case 5: {
                        this.this$0.saveFilm(null);
                        break;
                    }
                    case 6: {
                        this.this$0.getCurrentlySelectedFilm().ifPresent(film -> {
                            if (!film.isLivestream()) {
                                if (film.isBookmarked()) {
                                    this.this$0.bookmarkRemoveFilmAction.actionPerformed(null);
                                } else {
                                    this.this$0.bookmarkAddFilmAction.actionPerformed(null);
                                }
                            }
                        });
                    }
                }
            }
        }

        private void createStartWithPsetItems(@NotNull JPopupMenu jPopupMenu) {
            JMenu submenue = new JMenu("Film mit Set starten");
            jPopupMenu.add(submenue);
            ListePset liste = Daten.listePset.getListeButton();
            for (DatenPset pset : liste) {
                if (pset.getListeProg().isEmpty() && pset.getName().isEmpty()) continue;
                JMenuItem item = new JMenuItem(pset.getName());
                pset.getForegroundColor().ifPresent(item::setForeground);
                if (!pset.getListeProg().isEmpty()) {
                    item.addActionListener(actionEvent -> this.this$0.playerStarten(pset));
                }
                submenue.add(item);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = this.this$0.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                this.this$0.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.this$0.playFilmAction);
            jPopupMenu.add(this.this$0.saveFilmAction);
            JMenuItem miBookmark = new JMenuItem(this.this$0.bookmarkAddFilmAction);
            jPopupMenu.add(miBookmark);
            jPopupMenu.addSeparator();
            JMenu submenueAbo = new JMenu("Abo");
            jPopupMenu.add(submenueAbo);
            JMenuItem itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
            JMenuItem itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
            Optional<DatenFilm> res = this.this$0.getFilm(nr);
            res.ifPresent(film -> {
                if (this.this$0.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false) != null) {
                    itemAbo.setEnabled(false);
                    itemAboMitTitel.setEnabled(false);
                } else {
                    itemAbo.addActionListener(this.beobAbo);
                    itemAboMitTitel.addActionListener(this.beobAboMitTitel);
                }
                if (film.isLivestream()) {
                    jPopupMenu.remove(miBookmark);
                } else {
                    miBookmark.setText(film.isBookmarked() ? "Film aus Merkliste entfernen" : "Film merken");
                }
            });
            submenueAbo.add(itemAbo);
            submenueAbo.add(itemAboMitTitel);
            this.createStartWithPsetItems(jPopupMenu);
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            JMenuItem itemBlackSender = new JMenuItem("Sender in die Blacklist einf\u00fcgen");
            itemBlackSender.addActionListener(this.beobBlacklistSender);
            JMenuItem itemBlackThema = new JMenuItem("Thema in die Blacklist einf\u00fcgen");
            itemBlackThema.addActionListener(this.beobBlacklistThema);
            JMenuItem itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einf\u00fcgen");
            itemBlackSenderThema.addActionListener(this.beobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackThema);
            submenueBlack.add(itemBlackSenderThema);
            res.ifPresent(film -> {
                this.jDownloadHelper.installContextMenu((DatenFilm)film, jPopupMenu);
                jPopupMenu.addSeparator();
                this.setupCopytoClipboardContextMenu((DatenFilm)film, jPopupMenu);
                jPopupMenu.addSeparator();
                this.setupSearchEntries(jPopupMenu, (DatenFilm)film);
            });
            res.ifPresent(film -> {
                if (film.hasSubtitle()) {
                    jPopupMenu.add(this.downloadSubtitleAction);
                    jPopupMenu.addSeparator();
                }
            });
            JMenuItem miPrintTable = new JMenuItem("Tabelle drucken");
            miPrintTable.addActionListener(this.beobPrint);
            jPopupMenu.add(miPrintTable);
            jPopupMenu.add(((GuiFilme)this.this$0).mediathekGui.showFilmInformationAction);
            res.ifPresent(film -> this.setupHistoryContextActions(jPopupMenu, (DatenFilm)film));
            res.ifPresent(film -> {
                if (!film.isLivestream()) {
                    jPopupMenu.addSeparator();
                    JMenuItem miCreateInfoFile = new JMenuItem("Infodatei erzeugen...");
                    miCreateInfoFile.addActionListener(actionEvent -> {
                        File file = FileDialogs.chooseSaveFileLocation(MediathekGui.ui(), "Infodatei speichern", "");
                        if (file != null) {
                            MVInfoFile infoFile = new MVInfoFile();
                            try {
                                infoFile.writeManualInfoFile((DatenFilm)film, file.toPath());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    jPopupMenu.add(miCreateInfoFile);
                }
            });
            res.ifPresent(film -> {
                JMenuItem mi;
                if (film.isDuplicate()) {
                    jPopupMenu.addSeparator();
                    mi = new JMenuItem("Zusammengeh\u00f6rige Filme anzeigen...");
                    mi.addActionListener(actionEvent -> {
                        DuplicateFilmDetailsDialog dlg = new DuplicateFilmDetailsDialog((Window)MediathekGui.ui(), (DatenFilm)film);
                        dlg.setVisible(true);
                    });
                    jPopupMenu.add(mi);
                }
                if (!film.isLivestream()) {
                    jPopupMenu.addSeparator();
                    mi = new JMenuItem("Duplikate entfernen...");
                    mi.addActionListener(actionEvent -> this.performDuplicateRemoval((DatenFilm)film));
                    jPopupMenu.add(mi);
                }
            });
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private void performDuplicateRemoval(@NotNull DatenFilm film) {
            Daten daten = Daten.getInstance();
            ListeFilme completeFilmList = daten.getListeFilme();
            ListeBlacklist filteredFilmList = daten.getListeBlacklist();
            ArrayList<DatenFilm> duplicateList = new ArrayList<DatenFilm>(completeFilmList.parallelStream().filter(f -> f.getSender().equalsIgnoreCase(film.getSender())).filter(f -> f.getThema().equalsIgnoreCase(film.getThema())).filter(f -> f.getTitle().equalsIgnoreCase(film.getTitle())).filter(f -> f.getUrlNormalQuality().equalsIgnoreCase(film.getUrlNormalQuality())).toList());
            int filmCount = duplicateList.size();
            if (filmCount > 1) {
                String duplicateString = --filmCount == 1 ? "Duplikat" : "Duplikate";
                String message = String.format("Es wurden %d %s gefunden.\nM\u00f6chten Sie diese entfernen?", filmCount, duplicateString);
                int result2 = JOptionPane.showConfirmDialog(this.this$0.mediathekGui, message, "MediathekView", 0);
                if (result2 == 0) {
                    duplicateList.remove(film);
                    completeFilmList.removeAll(duplicateList);
                    FilmListWriter writer = new FilmListWriter(false);
                    writer.writeFilmList(StandardLocations.getFilmlistFilePathString(), completeFilmList, null);
                    filteredFilmList.filterListAndNotifyListeners();
                    JOptionPane.showMessageDialog(this.this$0.mediathekGui, "Duplikate wurden entfernt.", "MediathekView", 1);
                }
            } else {
                JOptionPane.showMessageDialog(this.this$0.mediathekGui, "Es wurden keine Duplikate gefunden.", "MediathekView", 1);
            }
        }

        private void setupHistoryContextActions(@NotNull JPopupMenu popupMenu, @NotNull DatenFilm film) {
            if (!film.isLivestream()) {
                try (SeenHistoryController history = new SeenHistoryController();){
                    JMenuItem miHistory;
                    if (history.hasBeenSeen(film)) {
                        miHistory = new JMenuItem("Film als ungesehen markieren");
                        miHistory.addActionListener(this.unseenActionListener);
                    } else {
                        miHistory = new JMenuItem("Film als gesehen markieren");
                        miHistory.addActionListener(this.seenActionListener);
                    }
                    popupMenu.add(miHistory);
                }
            }
        }

        private void setupCopytoClipboardContextMenu(@NotNull DatenFilm film, @NotNull JPopupMenu popupMenu) {
            JMenu mCopyToClipboard = new JMenu("In Zwischenablage kopieren");
            JMenuItem miCopyClipboardTitle = new JMenuItem("Titel");
            miCopyClipboardTitle.addActionListener(actionEvent -> GuiFunktionen.copyToClipboard(film.getTitle()));
            mCopyToClipboard.add(miCopyClipboardTitle);
            JMenuItem miCopyClipboardThema = new JMenuItem("Thema");
            miCopyClipboardThema.addActionListener(actionEvent -> GuiFunktionen.copyToClipboard(film.getThema()));
            mCopyToClipboard.add(miCopyClipboardThema);
            JMenuItem miCopyTitleThemaToClipboard = new JMenuItem("Thema - Titel");
            miCopyTitleThemaToClipboard.addActionListener(actionEvent -> {
                String text = film.getThema() + " - " + film.getTitle();
                GuiFunktionen.copyToClipboard(text);
            });
            mCopyToClipboard.add(miCopyTitleThemaToClipboard);
            JMenuItem miCopySenderThemaTitelToClipboard = new JMenuItem("Sender - Thema - Titel");
            miCopySenderThemaTitelToClipboard.addActionListener(actionEvent -> {
                String t = String.format("%s - %s - %s", film.getSender(), film.getThema(), film.getTitle());
                GuiFunktionen.copyToClipboard(t);
            });
            mCopyToClipboard.add(miCopySenderThemaTitelToClipboard);
            JMenuItem miCopyDescriptionToClipboard = new JMenuItem("Beschreibung");
            miCopyDescriptionToClipboard.addActionListener(actionEvent -> GuiFunktionen.copyToClipboard(film.getDescription()));
            mCopyToClipboard.add(miCopyDescriptionToClipboard);
            this.setupFilmUrlCopyToClipboardEntries(mCopyToClipboard, film);
            popupMenu.add(mCopyToClipboard);
        }

        private void setupFilmUrlCopyToClipboardEntries(@NotNull JMenu parentMenu, @NotNull DatenFilm film) {
            JMenuItem item;
            parentMenu.addSeparator();
            String uNormal = film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL);
            String uHd = film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
            String uLow = film.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
            if (uHd.equals(uNormal)) {
                uHd = "";
            }
            if (uLow.equals(uNormal)) {
                uLow = "";
            }
            if (!uNormal.isEmpty()) {
                ActionListener copyNormalUrlListener = actionEvent -> GuiFunktionen.copyToClipboard(uNormal);
                if (!uHd.isEmpty() || !uLow.isEmpty()) {
                    JMenu submenueURL = new JMenu("Film-URL");
                    if (!uHd.isEmpty()) {
                        item = new JMenuItem("h\u00f6chste/hohe Qualit\u00e4t");
                        item.setAccelerator(KeyStroke.getKeyStroke(72, GuiFunktionen.getPlatformControlKey() | 0x40 | 0x200));
                        item.addActionListener(actionEvent -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY)));
                        submenueURL.add(item);
                    }
                    item = new JMenuItem("mittlere Qualit\u00e4t");
                    item.addActionListener(copyNormalUrlListener);
                    item.setAccelerator(KeyStroke.getKeyStroke(78, GuiFunktionen.getPlatformControlKey() | 0x40 | 0x200));
                    submenueURL.add(item);
                    if (!uLow.isEmpty()) {
                        item = new JMenuItem("niedrige Qualit\u00e4t");
                        item.addActionListener(actionEvent -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(FilmResolution.Enum.LOW)));
                        submenueURL.add(item);
                    }
                    parentMenu.add(submenueURL);
                } else {
                    item = new JMenuItem("Verf\u00fcgbare URL");
                    item.addActionListener(copyNormalUrlListener);
                    parentMenu.add(item);
                }
            }
            if (!film.getSubtitleUrl().isEmpty()) {
                item = new JMenuItem("Untertitel-URL");
                item.addActionListener(actionEvent -> GuiFunktionen.copyToClipboard(film.getSubtitleUrl()));
                parentMenu.add(item);
            }
        }

        private void setupSearchEntries(@NotNull JPopupMenu popupMenu, @NotNull DatenFilm film) {
            JMenu mOnlineSearch = new JMenu("Online-Suche nach");
            JMenu mThema = new JMenu("Thema");
            JMenu mTitel = new JMenu("Titel");
            EnumSet<OnlineSearchProviders> set = EnumSet.allOf(OnlineSearchProviders.class);
            for (OnlineSearchProviders item : set) {
                if (!film.isLivestream()) {
                    JMenuItem miThema = new JMenuItem(item.toString());
                    miThema.addActionListener(actionEvent -> {
                        String url = item.getQueryUrl() + URLEncoder.encode(film.getThema(), StandardCharsets.UTF_8);
                        UrlHyperlinkAction.openURL(url);
                    });
                    mThema.add(miThema);
                }
                JMenuItem miTitel = new JMenuItem(item.toString());
                miTitel.addActionListener(actionEvent -> {
                    String url = item.getQueryUrl() + URLEncoder.encode(film.getTitle(), StandardCharsets.UTF_8);
                    UrlHyperlinkAction.openURL(url);
                });
                mTitel.add(miTitel);
            }
            if (!film.isLivestream()) {
                mOnlineSearch.add(mThema);
            }
            mOnlineSearch.add(mTitel);
            popupMenu.add(mOnlineSearch);
            popupMenu.addSeparator();
        }

        private class BeobPrint
        implements ActionListener {
            final /* synthetic */ TableContextMenuHandler this$1;

            private BeobPrint(TableContextMenuHandler tableContextMenuHandler) {
                TableContextMenuHandler tableContextMenuHandler2 = tableContextMenuHandler;
                Objects.requireNonNull(tableContextMenuHandler2);
                this.this$1 = tableContextMenuHandler2;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    this.this$1.this$0.tabelle.print();
                }
                catch (PrinterException ex) {
                    logger.error((Object)ex);
                }
            }
        }

        private class BeobAbo
        implements ActionListener {
            private final boolean mitTitel;
            final /* synthetic */ TableContextMenuHandler this$1;

            BeobAbo(TableContextMenuHandler tableContextMenuHandler, boolean mmitTitel) {
                TableContextMenuHandler tableContextMenuHandler2 = tableContextMenuHandler;
                Objects.requireNonNull(tableContextMenuHandler2);
                this.this$1 = tableContextMenuHandler2;
                this.mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    new DialogAboNoSet(this.this$1.this$0.mediathekGui).setVisible(true);
                } else {
                    int nr = this.this$1.this$0.tabelle.rowAtPoint(this.this$1.p);
                    if (nr >= 0) {
                        this.this$1.this$0.stopBeob = true;
                        Optional<DatenFilm> res = this.this$1.this$0.getFilm(nr);
                        res.ifPresent(film -> {
                            DatenAbo datenAbo = this.this$1.this$0.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false);
                            if (datenAbo != null) {
                                this.this$1.this$0.daten.getListeAbo().aboLoeschen(datenAbo);
                            } else if (this.mitTitel) {
                                this.this$1.this$0.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), film.getTitle());
                            } else {
                                this.this$1.this$0.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), "");
                            }
                        });
                        this.this$1.this$0.stopBeob = false;
                    }
                }
            }
        }

        private final class BeobBlacklist
        implements ActionListener {
            private final boolean sender;
            private final boolean thema;
            final /* synthetic */ TableContextMenuHandler this$1;

            BeobBlacklist(TableContextMenuHandler tableContextMenuHandler, boolean sender, boolean thema) {
                TableContextMenuHandler tableContextMenuHandler2 = tableContextMenuHandler;
                Objects.requireNonNull(tableContextMenuHandler2);
                this.this$1 = tableContextMenuHandler2;
                this.sender = sender;
                this.thema = thema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = this.this$1.this$0.tabelle.rowAtPoint(this.this$1.p);
                if (nr >= 0) {
                    Optional<DatenFilm> res = this.this$1.this$0.getFilm(nr);
                    res.ifPresent(film -> {
                        String thema = film.getThema();
                        String sender = film.getSender();
                        ApplicationConfiguration.getConfiguration().setProperty("blacklist.is_on", (Object)true);
                        ListeBlacklist listeBlacklist = this.this$1.this$0.daten.getListeBlacklist();
                        if (!this.sender) {
                            listeBlacklist.add(new BlacklistRule("", thema, "", ""));
                        } else if (!this.thema) {
                            listeBlacklist.add(new BlacklistRule(sender, "", "", ""));
                        } else {
                            listeBlacklist.add(new BlacklistRule(sender, thema, "", ""));
                        }
                    });
                }
            }
        }

        private class BeobHistory
        implements ActionListener {
            private final boolean seen;
            final /* synthetic */ TableContextMenuHandler this$1;

            BeobHistory(TableContextMenuHandler tableContextMenuHandler, boolean seen) {
                TableContextMenuHandler tableContextMenuHandler2 = tableContextMenuHandler;
                Objects.requireNonNull(tableContextMenuHandler2);
                this.this$1 = tableContextMenuHandler2;
                this.seen = seen;
            }

            private void updateHistory(DatenFilm film) {
                try (SeenHistoryController history = new SeenHistoryController();){
                    if (this.seen) {
                        history.markSeen(film);
                    } else {
                        history.markUnseen(film);
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = this.this$1.this$0.tabelle.rowAtPoint(this.this$1.p);
                if (nr != -1) {
                    Optional<DatenFilm> res = this.this$1.this$0.getFilm(nr);
                    res.ifPresent(this::updateHistory);
                }
            }
        }
    }

    static class GuiModelHelperFactory {
        GuiModelHelperFactory() {
        }

        public static GuiModelHelper createGuiModelHelper(@NotNull SeenHistoryController historyController, @NotNull SearchFieldData searchFieldData, @NotNull FilterConfiguration filterConfig) {
            GuiModelHelper helper = Daten.getInstance().getListeFilmeNachBlackList() instanceof IndexedFilmList ? new LuceneGuiFilmeModelHelper(historyController, searchFieldData, filterConfig) : new GuiFilmeModelHelper(historyController, searchFieldData, filterConfig);
            return helper;
        }
    }

    private static class FilterZeitraumEvent
    extends BaseEvent {
        private FilterZeitraumEvent() {
        }
    }
}

