/*
 * Decompiled with CFR 0.152.
 */
package mediathek.swing.table;

import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import mediathek.tool.ApplicationConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlazedSortKeysPersister<E> {
    private static final String CONFIG_KEY = ".sortKeys";
    private static final Logger LOG = LogManager.getLogger();
    private final ObjectMapper mapper = new ObjectMapper();
    private final String configPrefix;
    private final TableComparatorChooser<E> chooser;

    public GlazedSortKeysPersister(String configPrefix, TableComparatorChooser<E> chooser) {
        this.configPrefix = configPrefix;
        this.chooser = chooser;
    }

    public void saveSortState() {
        List sortedCols = this.chooser.getSortingColumns();
        ArrayList<SortKeyInfo> infos = new ArrayList<SortKeyInfo>(sortedCols.size());
        Iterator iterator = sortedCols.iterator();
        while (iterator.hasNext()) {
            int col = (Integer)iterator.next();
            boolean desc = this.chooser.isColumnReverse(col);
            infos.add(new SortKeyInfo(col, 0, desc));
        }
        try {
            String json = this.mapper.writeValueAsString(infos);
            ApplicationConfiguration.getConfiguration().setProperty(this.configPrefix + CONFIG_KEY, (Object)json);
        }
        catch (IOException e) {
            LOG.error("Failed to save sort keys", (Throwable)e);
        }
    }

    public void restoreSortState() {
        try {
            String json = ApplicationConfiguration.getConfiguration().getString(this.configPrefix + CONFIG_KEY);
            if (json.isEmpty()) {
                return;
            }
            List infos = (List)this.mapper.readValue(json, (TypeReference)new TypeReference<List<SortKeyInfo>>(this){
                {
                    Objects.requireNonNull(this$0);
                }
            });
            for (SortKeyInfo info : infos) {
                this.chooser.appendComparator(info.column, info.comparatorIndex, info.descending);
            }
        }
        catch (NoSuchElementException json) {
        }
        catch (Exception e) {
            LOG.error("Failed to restore sort keys", (Throwable)e);
        }
    }

    public static class SortKeyInfo {
        public int column;
        public int comparatorIndex;
        public boolean descending;

        public SortKeyInfo() {
        }

        public SortKeyInfo(int column, int comparatorIndex, boolean descending) {
            this.column = column;
            this.comparatorIndex = comparatorIndex;
            this.descending = descending;
        }
    }
}

