/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.components.ProgressDisplay;
import com.install4j.runtime.installer.platform.win32.WinTaskBar;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class ProgressComponent
extends SystemFormComponent
implements ProgressInterface {
    private boolean hideInitially = false;
    private boolean statusVisible = true;
    private boolean detailVisible = true;
    private String initialStatusMessage = "";
    private String initialDetailMessage = "";
    private ProgressDisplay progressDisplay;

    public boolean isHideInitially() {
        return this.replaceWithTextOverride("hideInitially", this.hideInitially);
    }

    public void setHideInitially(boolean hideInitially) {
        this.hideInitially = hideInitially;
    }

    public String getInitialStatusMessage() {
        return ProgressComponent.replaceVariables(this.replaceFormVariables(this.initialStatusMessage));
    }

    public void setInitialStatusMessage(String initialStatusMessage) {
        this.initialStatusMessage = initialStatusMessage;
    }

    public String getInitialDetailMessage() {
        return ProgressComponent.replaceVariables(this.initialDetailMessage);
    }

    public void setInitialDetailMessage(String initialDetailMessage) {
        this.initialDetailMessage = initialDetailMessage;
    }

    public boolean isStatusVisible() {
        return this.replaceWithTextOverride("statusVisible", this.statusVisible);
    }

    public void setStatusVisible(boolean statusVisible) {
        this.statusVisible = statusVisible;
    }

    public boolean isDetailVisible() {
        return this.replaceWithTextOverride("detailVisible", this.detailVisible);
    }

    public void setDetailVisible(boolean detailVisible) {
        this.detailVisible = detailVisible;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.progressDisplay != null && formEnvironment != null) {
            this.progressDisplay.getProgressBar().setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.progressDisplay = new ProgressDisplay();
        if (this.getFormEnvironment().isDesignTime()) {
            if (this.isHideInitially()) {
                JLabel label = new JLabel("[Initially hidden progress display]");
                label.setEnabled(false);
                return label;
            }
            this.progressDisplay.setStatusMessage("[Status line]");
            this.progressDisplay.setDetailMessage("[Detail line]");
            this.progressDisplay.setTextLinesEnabled(false);
            this.progressDisplay.setPercentCompleted(50);
        } else {
            this.progressDisplay.setStatusMessage(this.getInitialStatusMessage());
            this.progressDisplay.setDetailMessage(this.getInitialDetailMessage());
        }
        this.progressDisplay.setDetailVisible(this.isDetailVisible());
        this.progressDisplay.setStatusVisible(this.isStatusVisible());
        return this.progressDisplay;
    }

    @Override
    public Object getConfigurationObject() {
        return this.progressDisplay.getProgressBar();
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JProgressBar.class;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public void formWillActivate() {
        if (this.isHideInitially()) {
            if (this.getFormEnvironment().isDesignTime()) {
                this.setEnabled(false);
            } else {
                this.setVisible(false);
            }
        }
        super.formWillActivate();
    }

    @Override
    public void setStatusMessage(String statusMessage) {
        this.checkVisible();
        this.progressDisplay.setStatusMessage(statusMessage);
    }

    @Override
    public void setDetailMessage(String detailMessage) {
        this.checkVisible();
        this.progressDisplay.setDetailMessage(detailMessage);
    }

    @Override
    public int getPercentCompleted() {
        return this.replaceWithTextOverride("percentCompleted", this.progressDisplay.getPercentCompleted());
    }

    @Override
    public void setSecondaryPercentCompleted(int percentCompleted) {
        this.checkVisible();
        this.progressDisplay.setSecondaryPercentCompleted(percentCompleted);
    }

    @Override
    public void setPercentCompleted(int percentCompleted) {
        this.checkVisible();
        this.progressDisplay.setPercentCompleted(percentCompleted);
        WinTaskBar taskBar = this.getTaskBar();
        taskBar.setProgressState(WinTaskBar.ProgressState.NORMAL);
        taskBar.setProgress(percentCompleted, 100L);
    }

    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
        this.checkVisible();
        this.progressDisplay.setIndeterminateProgress(indeterminateProgress);
        this.getTaskBar().setProgressState(WinTaskBar.ProgressState.INDETERMINATE);
    }

    @NotNull
    private WinTaskBar getTaskBar() {
        return WinTaskBar.getTaskBar(GUIHelper.getParentWindow());
    }

    @Override
    public void showFailure(String message) {
        this.getDefaultProgressInterface().showFailure(message);
    }

    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        return this.getDefaultProgressInterface().askOverwrite(file);
    }

    @Override
    public int askRetry(File file) throws UserCanceledException {
        return this.getDefaultProgressInterface().askRetry(file);
    }

    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        return this.getDefaultProgressInterface().askContinue(file);
    }

    public ProgressInterface getDefaultProgressInterface() {
        return ((ContextImpl)ContextImpl.getSingleContextInt()).getDefaultProgressInterface();
    }

    private void checkVisible() {
        if (!this.isVisible()) {
            GUIHelper.invokeLater(() -> this.setVisible(true));
        }
    }

    @Override
    public boolean hasUserInput() {
        return false;
    }
}

