/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.runtime.installer.helper.content.JavaHttpConnection;
import com.install4j.runtime.installer.helper.versionspecific.HttpClientWrapper;
import com.install4j.runtime.installer.helper.versionspecific.Java9Helper;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.http.HttpClient;
import java.util.Locale;

public class Java11Helper
extends Java9Helper {
    @Override
    public JavaHttpConnection createHttpConnection(URL url, Proxy proxy, boolean acceptAllCertificates) throws IOException {
        if (!(Boolean.getBoolean("install4j.useHttpClient") && this.isHttpClientAvailable() && this.isHttpClientProtocol(url))) {
            return super.createHttpConnection(url, proxy, acceptAllCertificates);
        }
        return new HttpClientWrapper(url, proxy, acceptAllCertificates);
    }

    private boolean isHttpClientProtocol(URL url) {
        String protocol = url.getProtocol().toLowerCase(Locale.ROOT);
        return protocol.equals("http") || protocol.equals("https");
    }

    private boolean isHttpClientAvailable() {
        try {
            Class.forName(HttpClient.class.getName());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        try {
            System.setSecurityManager(securityManager);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

