/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class UnixJVMLocator {
    private static final String[] UNIX_DIR_KEYWORDS = new String[]{"java", "jre", "jdk", "j2sdk", "j2re", "j2jre"};
    public static final String[] JDK_FILES = new String[]{"bin/javac"};
    public static final String JAVA_EXECUTABLE = "bin/java";

    public static Collection<JVMLocator.JVMLocation> getJVMLocations() {
        HashSet<JVMLocator.JVMLocation> ret = new HashSet<JVMLocator.JVMLocation>();
        ArrayList<String> unixRootLocations = new ArrayList<String>(Arrays.asList("/usr/bin", "/usr", "/usr/java", "/usr/lib/java", "/usr/lib/jvm", "/usr/local", "/usr/lib", "/usr/jdk", "/opt"));
        for (String unixRootLocation : unixRootLocations) {
            ret.addAll(UnixJVMLocator.searchRootLocation(unixRootLocation));
        }
        return ret;
    }

    private static Collection<JVMLocator.JVMLocation> searchRootLocation(String rootLocation) {
        HashSet<JVMLocator.JVMLocation> ret = new HashSet<JVMLocator.JVMLocation>();
        File[] files = new File(rootLocation).listFiles();
        if (files != null) {
            block2: for (File file : files) {
                if (!file.isDirectory()) continue;
                for (String keyword : UNIX_DIR_KEYWORDS) {
                    if (!file.getName().contains(keyword)) continue;
                    try {
                        JVMLocator.JVMLocation jvmLocation = JVMLocator.checkJVMLocation(file, JAVA_EXECUTABLE, JDK_FILES);
                        if (jvmLocation == null) {
                            jvmLocation = JVMLocator.checkJVMLocation(new File(file, "jre"), JAVA_EXECUTABLE, JDK_FILES);
                        }
                        if (jvmLocation == null) continue block2;
                        ret.add(jvmLocation);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block2;
                }
            }
        }
        return ret;
    }
}

