/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import java.awt.Taskbar;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import mediathek.config.Daten;
import mediathek.controller.history.MVUsedUrl;
import mediathek.controller.history.SeenHistoryController;
import mediathek.controller.starter.DirectHttpDownload;
import mediathek.controller.starter.ExternalProgramDownload;
import mediathek.controller.starter.HttpDownloadState;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.ListeDownloads;
import mediathek.gui.bookmark.BookmarkData;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.ButtonStartEvent;
import mediathek.gui.messages.DownloadProgressChangedEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.mac.FinderCommentService;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.BandwidthFormatter;
import mediathek.tool.FileUtils;
import mediathek.tool.MessageBus;
import mediathek.tool.notification.MessageType;
import mediathek.tool.notification.NotificationMessage;
import net.engio.mbassy.bus.MBassador;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StarterClass {
    private static final Logger logger = LogManager.getLogger(StarterClass.class);
    private final Daten daten;
    private final StarterThread starterThread;
    private final AtomicBoolean pause = new AtomicBoolean(false);

    public StarterClass(Daten daten) {
        this.daten = daten;
        this.starterThread = new StarterThread(this);
        this.starterThread.start();
    }

    static boolean pruefen(Daten daten, DatenDownload datenDownload, Start start) {
        boolean ret = false;
        String filePath = datenDownload.arr[31];
        if (start != null && start.percent > -1 && start.percent < 995) {
            logger.error("Download fehlgeschlagen: 99,5% wurden nicht erreicht: {}", (Object)filePath);
            logger.error("Erreichte Prozente: {}%", (Object)((double)start.percent / 10.0));
            return false;
        }
        File file = new File(datenDownload.arr[31]);
        if (!file.exists()) {
            logger.error("Download fehlgeschlagen, Datei existiert nicht: {}", (Object)filePath);
        } else if (file.length() < 262144L) {
            logger.error("Download fehlgeschlagen, Datei zu klein:{}", (Object)filePath);
        } else {
            if (datenDownload.isFromAbo()) {
                MVUsedUrl usedUrl = new MVUsedUrl(datenDownload.arr[4], datenDownload.arr[5], datenDownload.arr[20]);
                daten.getAboHistoryController().add(usedUrl);
            }
            ret = true;
        }
        return ret;
    }

    static void deleteIfEmpty(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0]) && Files.size(path) < 262144L) {
                Files.delete(path);
            }
        }
        catch (IOException ex) {
            logger.trace("Fehler beim L\u00f6schen: {}", (Object)path.toAbsolutePath().toString());
        }
    }

    static void startmeldung(DatenDownload datenDownload, Start start) {
        boolean abspielen;
        ArrayList<Object> text = new ArrayList<Object>();
        boolean bl = abspielen = datenDownload.quelle == 1;
        if (abspielen) {
            text.add("Film abspielen");
        } else {
            if (start.startcounter > 1) {
                text.add("Download starten - Restart (Summe Starts: " + start.startcounter + ")");
            } else {
                text.add("Download starten");
            }
            text.add("Programmset: " + datenDownload.arr[24]);
            text.add("Ziel: " + datenDownload.arr[31]);
        }
        text.add("URL: " + datenDownload.arr[21]);
        text.add("Startzeit: " + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(start.startTime));
        if (datenDownload.art == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + datenDownload.arr[26]);
            text.add("Programmaufruf[]: " + datenDownload.arr[27]);
        }
        logger.info(text);
    }

    private static void makeBeep() {
        if (ApplicationConfiguration.getConfiguration().getBoolean("download.sound.beep", false)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private static void fertigmeldung(DatenDownload datenDownload, Start start, boolean abgebrochen) {
        StarterClass.makeBeep();
        ArrayList<Object> text = new ArrayList<Object>();
        if (abgebrochen) {
            text.add("Download wurde abgebrochen");
        } else if (datenDownload.quelle == 1) {
            text.add("Film fertig");
        } else {
            if (start.stoppen) {
                text.add("Download abgebrochen");
            } else if (start.status == 3) {
                text.add("Download ist fertig und hat geklappt");
            } else if (start.status == 4) {
                text.add("Download ist fertig und war fehlerhaft");
            }
            if (datenDownload.isDownloadManager()) {
                text.add("Programm ist ein Downloadmanager");
            }
            text.add("Programmset: " + datenDownload.arr[24]);
            text.add("Ziel: " + datenDownload.arr[31]);
        }
        LocalDateTime endZeit = LocalDateTime.now();
        text.add("Startzeit: " + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(start.startTime));
        text.add("Endzeit: " + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(endZeit));
        text.add("Restarts: " + start.countRestarted);
        text.add("Dauer: " + Duration.between(start.startTime, endZeit).toSeconds() + " s");
        if (datenDownload.art == 1 && start.mVBandwidthCountingInputStream != null) {
            text.add("Bytes gelesen: " + FileUtils.humanReadableByteCountBinary(start.mVBandwidthCountingInputStream.getSumByte()));
            text.add("Bandbreite: " + BandwidthFormatter.format(start.mVBandwidthCountingInputStream.getSumBandwidth()));
        }
        text.add("URL: " + datenDownload.arr[21]);
        if (datenDownload.art == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + datenDownload.arr[26]);
            text.add("Programmaufruf[]: " + datenDownload.arr[27]);
        }
        logger.info(text);
        if (!start.stoppen && !abgebrochen && datenDownload.quelle != 1) {
            StarterClass.addNotification(datenDownload, start.status != 4);
        }
    }

    private static void addNotification(@NotNull DatenDownload datenDownload, boolean erfolgreich) {
        String message;
        NotificationMessage msg = new NotificationMessage();
        if (erfolgreich) {
            msg.setType(MessageType.INFO);
            msg.setTitle("Download erfolgreich");
            message = String.format("\"%s\" vom %s wurde geladen.", datenDownload.arr[5], datenDownload.arr[3]);
        } else {
            msg.setType(MessageType.ERROR);
            msg.setTitle("Download fehlerhaft");
            message = String.format("Fehler beim Laden von \"%s\" des Senders %s aufgetreten.", datenDownload.arr[5], datenDownload.arr[3]);
        }
        msg.setMessage(message);
        Daten.getInstance().notificationCenter().displayNotification(msg);
    }

    private static void writeSpotlightComment(DatenDownload datenDownload, HttpDownloadState state) {
        String strComment;
        Path filmPath;
        if (state != HttpDownloadState.CANCEL && datenDownload != null && Boolean.parseBoolean(datenDownload.arr[36]) && Files.exists(filmPath = Paths.get(datenDownload.arr[31], new String[0]), new LinkOption[0]) && (strComment = datenDownload.film.getDescription()) != null && !strComment.isEmpty()) {
            FinderCommentService.writeFinderComment(filmPath, strComment, true);
        }
    }

    public static void finalizeDownload(DatenDownload datenDownload, Start start, HttpDownloadState state) {
        StarterClass.deleteIfEmpty(Paths.get(datenDownload.arr[31], new String[0]));
        StarterClass.setFileSize(datenDownload);
        if (SystemUtils.IS_OS_MAC_OSX) {
            StarterClass.writeSpotlightComment(datenDownload, state);
        }
        StarterClass.fertigmeldung(datenDownload, start, state == HttpDownloadState.CANCEL);
        if (state == HttpDownloadState.CANCEL) {
            datenDownload.resetDownload();
        } else {
            start.restSekunden = -1L;
            start.percent = 1000;
            datenDownload.mVFilmSize.setAktSize(-1L);
        }
        StarterClass.notifyStartEvent(datenDownload);
        if (SystemUtils.IS_OS_MAC_OSX) {
            Taskbar.getTaskbar().requestUserAttention(true, false);
        }
    }

    private static void setFileSize(DatenDownload datenDownload) {
        try {
            long length;
            File testFile = new File(datenDownload.arr[31]);
            if (testFile.exists() && (length = testFile.length()) > 0L) {
                datenDownload.mVFilmSize.setSize(length);
            }
        }
        catch (Exception ex) {
            logger.error("Fehler beim Ermitteln der Dateigr\u00f6\u00dfe: {}", (Object)datenDownload.arr[31]);
        }
    }

    static void notifyStartEvent(DatenDownload datenDownload) {
        MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publishAsync((Object)new StartEvent());
        if (datenDownload != null && datenDownload.quelle == 1) {
            messageBus.publishAsync((Object)new ButtonStartEvent());
        }
    }

    public StarterThread getStarterThread() {
        return this.starterThread;
    }

    public synchronized void urlMitProgrammStarten(DatenPset pSet, @NotNull DatenFilm film, String aufloesung) {
        String url = film.getUrlNormalQuality();
        if (!url.isEmpty()) {
            BookmarkData bookmark;
            DatenDownload d = new DatenDownload(pSet, film, 1, null, "", "", aufloesung);
            d.start = new Start();
            this.starterThread.launchDownloadThread(d);
            try (SeenHistoryController historyController = new SeenHistoryController();){
                historyController.markSeen(film);
            }
            if (film.isBookmarked() && (bookmark = film.getBookmark()) != null) {
                bookmark.setSeen(true);
            }
            this.daten.getListeDownloadsButton().addMitNummer(d);
        }
    }

    public void delayNewStarts() {
        this.pause.set(true);
    }

    private void reStartmeldung(DatenDownload datenDownload) {
        ArrayList<CallSite> text = new ArrayList<CallSite>();
        text.add((CallSite)((Object)("Fehlerhaften Download neu starten - Restart (Summe Starts: " + datenDownload.start.countRestarted + ")")));
        text.add((CallSite)((Object)("Ziel: " + datenDownload.arr[31])));
        text.add((CallSite)((Object)("URL: " + datenDownload.arr[21])));
        logger.info(text);
    }

    public class StarterThread
    extends Thread {
        private static final long DOWNLOAD_DELAY = 2L;
        final /* synthetic */ StarterClass this$0;

        public StarterThread(StarterClass this$0) {
            StarterClass starterClass = this$0;
            Objects.requireNonNull(starterClass);
            this.this$0 = starterClass;
            this.setName(StarterThread.class.toString());
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    DatenDownload datenDownload;
                    while ((datenDownload = this.getNextStart()) != null) {
                        this.launchDownloadThread(datenDownload);
                        TimeUnit.SECONDS.sleep(2L);
                    }
                    this.this$0.daten.getListeDownloadsButton().buttonStartsPutzen();
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException datenDownload) {
                }
                catch (Exception ex) {
                    logger.error("Fehler in Starten Thread:", (Throwable)ex);
                }
            }
        }

        private synchronized DatenDownload getNextStart() throws InterruptedException {
            ListeDownloads listeDownloads;
            DatenDownload download;
            if (this.this$0.pause.get()) {
                TimeUnit.SECONDS.sleep(5L);
                this.this$0.pause.set(false);
            }
            if ((download = (listeDownloads = this.this$0.daten.getListeDownloads()).getNextStart()) == null && (download = listeDownloads.getRestartDownload()) != null) {
                this.this$0.reStartmeldung(download);
            }
            return download;
        }

        private void launchDownloadThread(DatenDownload datenDownload) {
            datenDownload.start.startTime = LocalDateTime.now();
            MessageBus.getMessageBus().publishAsync((Object)new DownloadProgressChangedEvent());
            switch (datenDownload.art) {
                case 2: {
                    ExternalProgramDownload downloadThread = new ExternalProgramDownload(datenDownload);
                    downloadThread.start();
                    break;
                }
                case 1: {
                    DirectHttpDownload downloadThread = new DirectHttpDownload(this.this$0.daten, datenDownload);
                    downloadThread.start();
                    break;
                }
                default: {
                    logger.error("StarterClass.Starten - Switch-default");
                }
            }
        }
    }
}

