/*
 * Decompiled with CFR 0.152.
 */
package mediathek.swing.table;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ATableColumnSettingsManager {
    private static final Logger LOG = LogManager.getLogger();
    private static final String COLUMN_SETTINGS = ".colummn-settings";
    protected final JTable table;
    protected final List<TableColumn> allColumns = new ArrayList<TableColumn>();
    protected final List<ColumnSetting> lastSettings = new ArrayList<ColumnSetting>();
    private final ObjectMapper mapper = new ObjectMapper();
    private final String configPrefix;

    public ATableColumnSettingsManager(JTable table, String configPrefix) {
        this.table = table;
        this.configPrefix = configPrefix;
        TableColumnModel columnModel = table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn col = columnModel.getColumn(i);
            this.allColumns.add(col);
            ColumnSetting cs = new ColumnSetting(col.getIdentifier().toString(), i, col.getWidth(), true);
            this.lastSettings.add(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            List fileSettings;
            Configuration config = ApplicationConfiguration.getConfiguration();
            config.lock(LockMode.READ);
            try {
                String str = config.getString(this.configPrefix + COLUMN_SETTINGS);
                fileSettings = (List)this.mapper.readValue(str, (TypeReference)new TypeReference<List<ColumnSetting>>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }
                });
            }
            finally {
                config.unlock(LockMode.READ);
            }
            for (ColumnSetting fs : fileSettings) {
                Optional<ColumnSetting> existing = this.lastSettings.stream().filter(ls -> ls.id.equals(fs.id)).findFirst();
                if (existing.isPresent()) {
                    ColumnSetting ls2 = existing.get();
                    ls2.position = fs.position;
                    ls2.width = fs.width;
                    ls2.visible = fs.visible;
                    continue;
                }
                this.lastSettings.add(new ColumnSetting(fs.id, fs.position, fs.width, fs.visible));
            }
            List<String> validIds = this.allColumns.stream().map(c -> c.getIdentifier().toString()).toList();
            this.lastSettings.removeIf(ls -> !validIds.contains(ls.id));
        }
        catch (Exception ex) {
            LOG.error("Failed to load column settings.", (Throwable)ex);
        }
        TableColumnModel columnModel = this.table.getColumnModel();
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        this.lastSettings.stream().filter(s -> s.visible).sorted(Comparator.comparingInt(a -> a.position)).forEach(s -> this.allColumns.stream().filter(col -> col.getIdentifier().toString().equals(s.id)).findFirst().ifPresent(col -> {
            columnModel.addColumn((TableColumn)col);
            col.setPreferredWidth(s.width);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (ColumnSetting ls : this.lastSettings) {
            boolean visible;
            Optional<TableColumn> colOpt = this.allColumns.stream().filter(c -> c.getIdentifier().toString().equals(ls.id)).findFirst();
            if (colOpt.isEmpty()) continue;
            TableColumn col = colOpt.get();
            ls.visible = visible = this.isInModel(col);
            if (!visible) continue;
            ls.position = columnModel.getColumnIndex(ls.id);
            ls.width = col.getWidth();
        }
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.lock(LockMode.WRITE);
        try {
            String output = this.mapper.writeValueAsString(this.lastSettings);
            config.setProperty(this.configPrefix + COLUMN_SETTINGS, (Object)output);
        }
        catch (JsonProcessingException ex) {
            LOG.error("Failed to save column settings.", (Throwable)ex);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    public abstract void installContextMenu();

    protected boolean isInModel(TableColumn col) {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (columnModel.getColumn(i) != col) continue;
            return true;
        }
        return false;
    }

    public static class ColumnSetting {
        public String id;
        public int position;
        public int width;
        public boolean visible;

        public ColumnSetting() {
        }

        public ColumnSetting(String id, int position, int width, boolean visible) {
            this.id = id;
            this.position = position;
            this.width = width;
            this.visible = visible;
        }
    }
}

