/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.history;

import com.google.common.collect.Sets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryShutdownHook;
import mediathek.daten.DatenFilm;
import mediathek.gui.messages.history.DownloadHistoryChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.sql.SqlDatabaseConfig;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.SQLiteDataSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00060\u0001j\u0002`\u0002:\u000234B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0014\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010*\u001a\u00020\u000eH\u0002J\b\u0010+\u001a\u00020\u000eH\u0016J\b\u0010,\u001a\u00020\u000eH\u0002J\b\u0010/\u001a\u00020\u000eH\u0002J\u0006\u00100\u001a\u00020\u000eJ\u0006\u00101\u001a\u000202R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\u001e\u0012\t\u0012\u00070\u001a\u00a2\u0006\u0002\b\u001b \u001d*\r\u0012\t\u0012\u00070\u001a\u00a2\u0006\u0002\b\u001b0\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lmediathek/controller/history/SeenHistoryController;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "connection", "Ljava/sql/Connection;", "insertStatement", "Ljava/sql/PreparedStatement;", "dataSource", "Lorg/sqlite/SQLiteDataSource;", "deleteStatement", "seenStatement", "removeAll", "", "markUnseen", "film", "Lmediathek/daten/DatenFilm;", "list", "", "markSeen", "prepareMemoryCache", "performMaintenance", "performDatabaseCompact", "urlCache", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "memCachePrepared", "", "emptyMemoryCache", "hasBeenSeenFromCache", "hasBeenSeen", "createEmptyDatabase", "dbPath", "Ljava/nio/file/Path;", "basicSqliteSettings", "statement", "Ljava/sql/Statement;", "writeToDatabase", "sendChangeMessage", "close", "performSqliteSetup", "shutdownThread", "Lmediathek/controller/history/SeenHistoryShutdownHook;", "installShutdownHook", "removeDuplicates", "checkDuplicates", "Lmediathek/controller/history/SeenHistoryController$DuplicateSearchResult;", "Companion", "DuplicateSearchResult", "MediathekView"})
@SourceDebugExtension(value={"SMAP\nSeenHistoryController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeenHistoryController.kt\nmediathek/controller/history/SeenHistoryController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1#2:384\n*E\n"})
public final class SeenHistoryController
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Connection connection;
    @NotNull
    private PreparedStatement insertStatement;
    @NotNull
    private final SQLiteDataSource dataSource = SqlDatabaseConfig.getDataSource();
    @NotNull
    private PreparedStatement deleteStatement;
    @NotNull
    private PreparedStatement seenStatement;
    @NotNull
    private final Set<String> urlCache;
    private boolean memCachePrepared;
    @Nullable
    private SeenHistoryShutdownHook shutdownThread;
    private static final Logger logger = LogManager.getLogger();
    @NotNull
    private static final String INSERT_SQL = "INSERT INTO seen_history(thema,titel,url) values (?,?,?)";
    @NotNull
    private static final String DELETE_SQL = "DELETE FROM seen_history WHERE url = ?";
    @NotNull
    private static final String SEEN_SQL = "SELECT COUNT(url) AS total FROM seen_history WHERE url = ?";
    @NotNull
    private static final String LASTRUN = "database.seen_history.maintenance.lastRun";
    private static final long MAX_DAYS = 30L;

    public SeenHistoryController() {
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentHashSet(...)");
        this.urlCache = set;
        try {
            if (!Files.exists(SqlDatabaseConfig.getHistoryDbPath(), new LinkOption[0])) {
                this.createEmptyDatabase(SqlDatabaseConfig.getHistoryDbPath());
            }
            Connection connection = this.dataSource.getConnection();
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
            this.connection = connection;
            this.performSqliteSetup();
            PreparedStatement preparedStatement = this.connection.prepareStatement(INSERT_SQL);
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(...)");
            this.insertStatement = preparedStatement;
            PreparedStatement preparedStatement2 = this.connection.prepareStatement(DELETE_SQL);
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement2, (String)"prepareStatement(...)");
            this.deleteStatement = preparedStatement2;
            PreparedStatement preparedStatement3 = this.connection.prepareStatement(SEEN_SQL);
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement3, (String)"prepareStatement(...)");
            this.seenStatement = preparedStatement3;
            this.installShutdownHook();
        }
        catch (SQLException ex) {
            logger.error("ctor", (Throwable)ex);
            System.exit(99);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAll() {
        try {
            AutoCloseable autoCloseable = this.connection.createStatement();
            Throwable throwable = null;
            try {
                Statement stmt = (Statement)autoCloseable;
                boolean bl = false;
                int n = stmt.executeUpdate("DELETE FROM seen_history");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("removeAll", (Throwable)ex);
        }
    }

    public final void markUnseen(@NotNull DatenFilm film) {
        Intrinsics.checkNotNullParameter((Object)film, (String)"film");
        try {
            this.deleteStatement.setString(1, film.getUrlNormalQuality());
            this.deleteStatement.executeUpdate();
            Daten.getInstance().getListeBookmarkList().updateSeen(false, film);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markUnseen", (Throwable)ex);
        }
    }

    public final void markUnseen(@NotNull List<? extends DatenFilm> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        try {
            for (DatenFilm film : list) {
                this.deleteStatement.setString(1, film.getUrlNormalQuality());
                this.deleteStatement.executeUpdate();
            }
            Daten.getInstance().getListeBookmarkList().updateSeen(false, list);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markUnseen", (Throwable)ex);
        }
    }

    public final void markSeen(@Nullable DatenFilm film) {
        if (film == null) {
            logger.warn("markSeen: no film found");
            return;
        }
        if (film.isLivestream()) {
            return;
        }
        if (this.hasBeenSeen(film)) {
            return;
        }
        try {
            this.writeToDatabase(film);
            Daten.getInstance().getListeBookmarkList().updateSeen(true, film);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markSeen single", (Throwable)ex);
        }
    }

    public final void markSeen(@NotNull List<? extends DatenFilm> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        try {
            for (DatenFilm film : list) {
                if (film.isLivestream() || this.hasBeenSeen(film)) continue;
                this.writeToDatabase(film);
            }
            Daten.getInstance().getListeBookmarkList().updateSeen(true, list);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markSeen", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepareMemoryCache() {
        AutoCloseable autoCloseable = this.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = st.executeQuery("SELECT DISTINCT(url) as url FROM seen_history");
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                while (rs.next()) {
                    String url = rs.getString(1);
                    this.urlCache.add(url);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        logger.trace("cache size: {}", (Object)this.urlCache.size());
        this.memCachePrepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performMaintenance() {
        String lastRunStr;
        logger.trace("Start maintenance");
        Configuration config = ApplicationConfiguration.getConfiguration();
        String string = lastRunStr = config.getString(LASTRUN, null);
        LocalDate lastRunDate = string != null ? LocalDate.parse(string) : null;
        LocalDate now = LocalDate.now();
        boolean shouldRunHeavyMaintenance = lastRunDate == null || ChronoUnit.DAYS.between(lastRunDate, now) >= 30L;
        try {
            AutoCloseable autoCloseable = this.connection.createStatement();
            Throwable throwable = null;
            try {
                Statement it = (Statement)autoCloseable;
                boolean bl = false;
                it.executeUpdate("DELETE FROM seen_history WHERE thema = 'Livestream'");
                if (shouldRunHeavyMaintenance) {
                    this.performDatabaseCompact();
                    config.setProperty(LASTRUN, (Object)now.toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException e) {
            logger.error("Failed to execute maintenance script", (Throwable)e);
        }
        logger.trace("Finished maintenance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performDatabaseCompact() {
        logger.info("Compacting database");
        AutoCloseable autoCloseable = this.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            it.executeUpdate("REINDEX seen_history");
            int n = it.executeUpdate("VACUUM");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void emptyMemoryCache() {
        this.urlCache.clear();
        this.memCachePrepared = false;
    }

    public final boolean hasBeenSeenFromCache(@NotNull DatenFilm film) {
        Intrinsics.checkNotNullParameter((Object)film, (String)"film");
        if (!this.memCachePrepared) {
            this.prepareMemoryCache();
        }
        return this.urlCache.contains(film.getUrlNormalQuality());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasBeenSeen(@NotNull DatenFilm film) {
        Intrinsics.checkNotNullParameter((Object)film, (String)"film");
        boolean result2 = false;
        try {
            this.seenStatement.setString(1, film.getUrlNormalQuality());
            AutoCloseable autoCloseable = this.seenStatement.executeQuery();
            Throwable throwable = null;
            try {
                ResultSet it = (ResultSet)autoCloseable;
                boolean bl = false;
                it.next();
                int total = it.getInt(1);
                result2 = total != 0;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException e) {
            logger.error("SQL error:", (Throwable)e);
            result2 = false;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createEmptyDatabase(Path dbPath) throws SQLException {
        String dbUrl = "jdbc:sqlite:" + dbPath.toAbsolutePath();
        AutoCloseable autoCloseable = DriverManager.getConnection(dbUrl, SqlDatabaseConfig.getConfig().toProperties());
        Throwable throwable = null;
        try {
            int n;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            conn.setTransactionIsolation(8);
            AutoCloseable autoCloseable2 = conn.createStatement();
            Throwable throwable2 = null;
            try {
                Statement statement = (Statement)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)statement);
                this.basicSqliteSettings(statement);
                statement.executeUpdate("DROP INDEX IF EXISTS IDX_SEEN_HISTORY_URL");
                statement.executeUpdate("DROP TABLE IF EXISTS seen_history");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS seen_history (id INTEGER PRIMARY KEY ASC, datum DATE NOT NULL DEFAULT (date('now')), thema TEXT, titel TEXT, url TEXT NOT NULL)");
                n = statement.executeUpdate("CREATE INDEX IF NOT EXISTS IDX_SEEN_HISTORY_URL ON seen_history(url)");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            int n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void basicSqliteSettings(Statement statement) {
        statement.executeUpdate("PRAGMA encoding='UTF-8'");
        statement.executeUpdate("PRAGMA page_size = 4096");
    }

    private final void writeToDatabase(DatenFilm film) throws SQLException {
        this.insertStatement.setString(1, film.getThema());
        this.insertStatement.setString(2, film.getTitle());
        this.insertStatement.setString(3, film.getUrlNormalQuality());
        this.insertStatement.executeUpdate();
    }

    private final void sendChangeMessage() {
        MessageBus.getMessageBus().publishAsync((Object)new DownloadHistoryChangedEvent());
    }

    @Override
    public void close() {
        this.urlCache.clear();
        try {
            this.insertStatement.close();
            this.deleteStatement.close();
            this.seenStatement.close();
            this.connection.close();
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            }
        }
        catch (SQLException ex) {
            logger.error("close", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performSqliteSetup() {
        AutoCloseable autoCloseable = this.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement statement = (Statement)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)statement);
            this.basicSqliteSettings(statement);
            int cpus = Runtime.getRuntime().availableProcessors() / 2;
            int n = statement.executeUpdate("PRAGMA threads=" + cpus);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void installShutdownHook() {
        this.shutdownThread = new SeenHistoryShutdownHook(this.connection);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDuplicates() throws SQLException {
        boolean prevAutoCommitState = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        try {
            AutoCloseable autoCloseable = this.connection.createStatement();
            Throwable throwable = null;
            try {
                Statement statement = (Statement)autoCloseable;
                boolean bl = false;
                String code = "CREATE TABLE temp_history AS\nSELECT\n    datum,\n    thema,\n    titel,\n    url\nFROM (\n    SELECT\n        datum,\n        thema,\n        titel,\n        url,\n        ROW_NUMBER() OVER (PARTITION BY url ORDER BY datum DESC) as rn\n    FROM\n        seen_history\n) AS ranked_seen_history\nWHERE\n    rn = 1 \nORDER BY\n    datum;";
                statement.executeUpdate(code);
                statement.executeUpdate("DELETE FROM seen_history");
                statement.executeUpdate("INSERT INTO seen_history(datum,thema,titel,url) SELECT datum,thema,titel,url FROM temp_history");
                int n = statement.executeUpdate("DROP TABLE temp_history");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
        this.connection.setAutoCommit(prevAutoCommitState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DuplicateSearchResult checkDuplicates() throws SQLException {
        ResultSet it;
        Throwable throwable;
        AutoCloseable autoCloseable;
        Statement statement;
        long total = 0L;
        long distinct = 0L;
        AutoCloseable autoCloseable2 = this.connection.createStatement();
        Throwable throwable2 = null;
        try {
            statement = (Statement)autoCloseable2;
            boolean bl = false;
            Statement statement2 = statement;
            Intrinsics.checkNotNull((Object)statement2);
            autoCloseable = statement2.executeQuery("SELECT COUNT(*) FROM seen_history");
            throwable = null;
            try {
                it = (ResultSet)autoCloseable;
                boolean bl2 = false;
                it.next();
                total = it.getLong(1);
                it = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            statement = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable2 = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
        }
        autoCloseable2 = this.connection.createStatement();
        throwable2 = null;
        try {
            statement = (Statement)autoCloseable2;
            boolean bl = false;
            autoCloseable = statement.executeQuery("SELECT COUNT(*) FROM (SELECT DISTINCT url FROM seen_history)");
            throwable = null;
            try {
                it = (ResultSet)autoCloseable;
                boolean bl3 = false;
                it.next();
                distinct = it.getLong(1);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable2 = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
        }
        return new DuplicateSearchResult(total, distinct);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmediathek/controller/history/SeenHistoryController$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "INSERT_SQL", "", "DELETE_SQL", "SEEN_SQL", "LASTRUN", "MAX_DAYS", "", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lmediathek/controller/history/SeenHistoryController$DuplicateSearchResult;", "Ljava/lang/Record;", "total", "", "distinct", "<init>", "(JJ)V", "()J", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "MediathekView"})
    public static final class DuplicateSearchResult
    extends Record {
        private final long total;
        private final long distinct;

        public DuplicateSearchResult(long total, long distinct) {
            this.total = total;
            this.distinct = distinct;
        }

        public final long total() {
            return this.total;
        }

        public final long distinct() {
            return this.distinct;
        }

        public final long component1() {
            return this.total;
        }

        public final long component2() {
            return this.distinct;
        }

        @NotNull
        public final DuplicateSearchResult copy(long total, long distinct) {
            return new DuplicateSearchResult(total, distinct);
        }

        public static /* synthetic */ DuplicateSearchResult copy$default(DuplicateSearchResult duplicateSearchResult, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = duplicateSearchResult.total;
            }
            if ((n & 2) != 0) {
                l2 = duplicateSearchResult.distinct;
            }
            return duplicateSearchResult.copy(l, l2);
        }

        @Override
        @NotNull
        public String toString() {
            return "DuplicateSearchResult(total=" + this.total + ", distinct=" + this.distinct + ")";
        }

        @Override
        public int hashCode() {
            int result2 = Long.hashCode(this.total);
            result2 = result2 * 31 + Long.hashCode(this.distinct);
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DuplicateSearchResult)) {
                return false;
            }
            DuplicateSearchResult duplicateSearchResult = (DuplicateSearchResult)other;
            if (this.total != duplicateSearchResult.total) {
                return false;
            }
            return this.distinct == duplicateSearchResult.distinct;
        }
    }
}

