/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmResolution;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.http.MVHttpClient;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmediathek/gui/tabs/tab_film/JDownloadHelper;", "", "<init>", "()V", "historyController", "Lmediathek/controller/history/SeenHistoryController;", "downloadUrl", "", "url", "Lokhttp3/HttpUrl;", "film", "Lmediathek/daten/DatenFilm;", "showErrorMessage", "installContextMenu", "jPopupMenu", "Ljavax/swing/JPopupMenu;", "Companion", "MediathekView"})
public final class JDownloadHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SeenHistoryController historyController = new SeenHistoryController();
    private static final Logger logger = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadUrl(HttpUrl url, DatenFilm film) {
        RequestBody formBody = (RequestBody)new FormBody.Builder(null, 1, null).add("urls", url.toString()).build();
        Request request = new Request.Builder().url("http://127.0.0.1:9666/flash/add").post(formBody).build();
        try {
            OkHttpClient.Builder builder = MVHttpClient.getInstance().getHttpClient().newBuilder();
            builder.connectTimeout(125L, TimeUnit.MILLISECONDS);
            OkHttpClient client = builder.build();
            Closeable closeable = (Closeable)client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response it = (Response)closeable;
                boolean bl = false;
                if (it.isSuccessful()) {
                    this.historyController.markSeen(film);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (ConnectException e) {
            this.showErrorMessage();
        }
        catch (SocketTimeoutException e) {
            this.showErrorMessage();
        }
        catch (Exception e) {
            logger.error("downloadUrl", (Throwable)e);
            SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "<html>Die URL konnte nicht mit JDownloader geladen werden.<br>Bitte wenden Sie sich bei Bedarf an das Forum.</html>", e);
        }
    }

    private final void showErrorMessage() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Verbindung mit JDownloader nicht m\u00f6glich.\nBitte stellen Sie sicher, dass JDownloader gestartet wurde.", "MediathekView", 0);
    }

    public final void installContextMenu(@NotNull DatenFilm film, @NotNull JPopupMenu jPopupMenu) {
        Intrinsics.checkNotNullParameter((Object)film, (String)"film");
        Intrinsics.checkNotNullParameter((Object)jPopupMenu, (String)"jPopupMenu");
        jPopupMenu.addSeparator();
        JMenu mJD = new JMenu("Mit JDownloader herunterladen");
        String string = film.getUrlNormalQuality();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlNormalQuality(...)");
        HttpUrl uNormal = HttpUrl.Companion.get(string);
        String string2 = film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrlFuerAufloesung(...)");
        HttpUrl uHq = HttpUrl.Companion.get(string2);
        String string3 = film.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUrlFuerAufloesung(...)");
        HttpUrl uLow = HttpUrl.Companion.get(string3);
        if (film.isHighQuality()) {
            JMenuItem miHq = new JMenuItem("in bester Qualit\u00e4t");
            miHq.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$0(this, uHq, film, arg_0));
            mJD.add(miHq);
        }
        JMenuItem miNormal = new JMenuItem("in normaler Qualit\u00e4t");
        miNormal.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$1(this, uNormal, film, arg_0));
        mJD.add(miNormal);
        if (uLow != uNormal) {
            JMenuItem miLow = new JMenuItem("in niedriger Qualit\u00e4t");
            miLow.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$2(this, uLow, film, arg_0));
            mJD.add(miLow);
        }
        jPopupMenu.add(mJD);
        JMenuItem miWebsiteToJd = new JMenuItem("Webseiten-URL an JDownloader \u00fcbergeben");
        miWebsiteToJd.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$3(film, this, arg_0));
        jPopupMenu.add(miWebsiteToJd);
        String string4 = film.getWebsiteUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getWebsiteUrl(...)");
        if (StringsKt.isBlank((CharSequence)string4)) {
            miWebsiteToJd.setEnabled(false);
        }
    }

    private static final void installContextMenu$lambda$0(JDownloadHelper this$0, HttpUrl $uHq, DatenFilm $film, ActionEvent it) {
        this$0.downloadUrl($uHq, $film);
    }

    private static final void installContextMenu$lambda$1(JDownloadHelper this$0, HttpUrl $uNormal, DatenFilm $film, ActionEvent it) {
        this$0.downloadUrl($uNormal, $film);
    }

    private static final void installContextMenu$lambda$2(JDownloadHelper this$0, HttpUrl $uLow, DatenFilm $film, ActionEvent it) {
        this$0.downloadUrl($uLow, $film);
    }

    private static final void installContextMenu$lambda$3(DatenFilm $film, JDownloadHelper this$0, ActionEvent it) {
        try {
            String string = $film.getWebsiteUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWebsiteUrl(...)");
            HttpUrl webSiteUrl = HttpUrl.Companion.get(string);
            this$0.downloadUrl(webSiteUrl, $film);
        }
        catch (IllegalArgumentException e) {
            logger.error("Illegal Website URL found: {}", (Object)$film.getWebsiteUrl());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmediathek/gui/tabs/tab_film/JDownloadHelper$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

