/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten.blacklist;

import java.util.Locale;
import java.util.function.BiConsumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.daten.blacklist.BlacklistTags;
import mediathek.tool.Filter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J1\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010&\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010(\u001a\u00020)H\u00d6\u0081\u0004J\n\u0010*\u001a\u00020\u0003H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lmediathek/daten/blacklist/BlacklistRule;", "", "sender", "", "thema", "titel", "thema_titel", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSender", "()Ljava/lang/String;", "setSender", "(Ljava/lang/String;)V", "getThema", "setThema", "getTitel", "setTitel", "getThema_titel", "setThema_titel", "patternTitle", "", "patternThema", "hasTitlePattern", "hasThemaPattern", "convertToLowerCase", "", "checkPatterns", "writeToConfig", "writer", "Ljavax/xml/stream/XMLStreamWriter;", "readFromConfig", "parser", "Ljavax/xml/stream/XMLStreamReader;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "MediathekView"})
public final class BlacklistRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String sender;
    @NotNull
    private String thema;
    @NotNull
    private String titel;
    @NotNull
    private String thema_titel;
    private boolean patternTitle;
    private boolean patternThema;
    @NotNull
    public static final String TAG = "Blacklist";
    private static final Logger logger = LogManager.getLogger();

    public BlacklistRule(@NotNull String sender, @NotNull String thema, @NotNull String titel, @NotNull String thema_titel) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)thema, (String)"thema");
        Intrinsics.checkNotNullParameter((Object)titel, (String)"titel");
        Intrinsics.checkNotNullParameter((Object)thema_titel, (String)"thema_titel");
        this.sender = sender;
        this.thema = thema;
        this.titel = titel;
        this.thema_titel = thema_titel;
        this.patternTitle = true;
        this.patternThema = true;
    }

    public /* synthetic */ BlacklistRule(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        this(string, string2, string3, string4);
    }

    @NotNull
    public final String getSender() {
        return this.sender;
    }

    public final void setSender(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sender = string;
    }

    @NotNull
    public final String getThema() {
        return this.thema;
    }

    public final void setThema(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.thema = string;
    }

    @NotNull
    public final String getTitel() {
        return this.titel;
    }

    public final void setTitel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.titel = string;
    }

    @NotNull
    public final String getThema_titel() {
        return this.thema_titel;
    }

    public final void setThema_titel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.thema_titel = string;
    }

    public final boolean hasTitlePattern() {
        return this.patternTitle;
    }

    public final boolean hasThemaPattern() {
        return this.patternThema;
    }

    public final void convertToLowerCase() {
        String string = this.titel;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        this.titel = string2;
        string = this.thema_titel;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string3 = string.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        this.thema_titel = string3;
    }

    public final void checkPatterns() {
        this.patternTitle = Filter.isPattern(this.titel);
        this.patternThema = Filter.isPattern(this.thema_titel);
        if (this.patternTitle) {
            Filter.makePattern(this.titel);
        }
        if (this.patternThema) {
            Filter.makePattern(this.thema_titel);
        }
    }

    public final void writeToConfig(@NotNull XMLStreamWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        BiConsumer<String, String> writeElement = (arg_0, arg_1) -> BlacklistRule.writeToConfig$lambda$0(writer, arg_0, arg_1);
        try {
            writer.writeStartElement(TAG);
            writer.writeCharacters("\n");
            writeElement.accept(BlacklistTags.SENDER.getXmlName(), this.sender);
            writeElement.accept(BlacklistTags.THEMA.getXmlName(), this.thema);
            writeElement.accept(BlacklistTags.TITEL.getXmlName(), this.titel);
            writeElement.accept(BlacklistTags.THEMA_TITEL.getXmlName(), this.thema_titel);
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            logger.error("writeToConfig", (Throwable)ex);
        }
    }

    public final void readFromConfig(@NotNull XMLStreamReader parser) throws XMLStreamException {
        int event;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        while (parser.hasNext() && ((event = parser.next()) != 2 || !Intrinsics.areEqual((Object)parser.getLocalName(), (Object)TAG))) {
            if (event != 1) continue;
            String string = parser.getLocalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
            BlacklistTags.Companion.fromXmlTag(string).ifPresent(arg_0 -> BlacklistRule.readFromConfig$lambda$1(arg_0 -> BlacklistRule.readFromConfig$lambda$0(parser, this, arg_0), arg_0));
        }
    }

    @NotNull
    public final String component1() {
        return this.sender;
    }

    @NotNull
    public final String component2() {
        return this.thema;
    }

    @NotNull
    public final String component3() {
        return this.titel;
    }

    @NotNull
    public final String component4() {
        return this.thema_titel;
    }

    @NotNull
    public final BlacklistRule copy(@NotNull String sender, @NotNull String thema, @NotNull String titel, @NotNull String thema_titel) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)thema, (String)"thema");
        Intrinsics.checkNotNullParameter((Object)titel, (String)"titel");
        Intrinsics.checkNotNullParameter((Object)thema_titel, (String)"thema_titel");
        return new BlacklistRule(sender, thema, titel, thema_titel);
    }

    public static /* synthetic */ BlacklistRule copy$default(BlacklistRule blacklistRule, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = blacklistRule.sender;
        }
        if ((n & 2) != 0) {
            string2 = blacklistRule.thema;
        }
        if ((n & 4) != 0) {
            string3 = blacklistRule.titel;
        }
        if ((n & 8) != 0) {
            string4 = blacklistRule.thema_titel;
        }
        return blacklistRule.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "BlacklistRule(sender=" + this.sender + ", thema=" + this.thema + ", titel=" + this.titel + ", thema_titel=" + this.thema_titel + ")";
    }

    public int hashCode() {
        int result2 = this.sender.hashCode();
        result2 = result2 * 31 + this.thema.hashCode();
        result2 = result2 * 31 + this.titel.hashCode();
        result2 = result2 * 31 + this.thema_titel.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlacklistRule)) {
            return false;
        }
        BlacklistRule blacklistRule = (BlacklistRule)other;
        if (!Intrinsics.areEqual((Object)this.sender, (Object)blacklistRule.sender)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.thema, (Object)blacklistRule.thema)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.titel, (Object)blacklistRule.titel)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.thema_titel, (Object)blacklistRule.thema_titel);
    }

    private static final void writeToConfig$lambda$0(XMLStreamWriter $writer, String tagName, String content) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (((CharSequence)content).length() > 0) {
            try {
                $writer.writeCharacters("\t");
                $writer.writeStartElement(tagName);
                $writer.writeCharacters(content);
                $writer.writeEndElement();
                $writer.writeCharacters("\n");
            }
            catch (XMLStreamException e) {
                logger.error("writeElement failed", (Throwable)e);
            }
        }
    }

    private static final Unit readFromConfig$lambda$0(XMLStreamReader $parser, BlacklistRule this$0, BlacklistTags tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        try {
            String text = $parser.getElementText();
            switch (WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)text);
                    this$0.sender = text;
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)text);
                    this$0.thema = text;
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)text);
                    this$0.titel = text;
                    break;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)text);
                    this$0.thema_titel = text;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (XMLStreamException e) {
            logger.error("Error reading blacklist rule entry", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final void readFromConfig$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public BlacklistRule() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmediathek/daten/blacklist/BlacklistRule$Companion;", "", "<init>", "()V", "TAG", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlacklistTags.values().length];
            try {
                nArray[BlacklistTags.SENDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlacklistTags.THEMA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlacklistTags.TITEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlacklistTags.THEMA_TITEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

