/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.import_actions;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Daten;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.gui.messages.ReplaceListChangedEvent;
import mediathek.tool.MessageBus;
import mediathek.tool.ReplaceList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0015H\u0082\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lmediathek/gui/actions/import_actions/OldConfigFileImporter;", "", "<init>", "()V", "daten", "Lmediathek/config/Daten;", "inFactory", "Ljavax/xml/stream/XMLInputFactory;", "importAboBlacklist", "Lmediathek/gui/actions/import_actions/OldConfigFileImporter$ImportResult;", "datei", "", "importAbo", "", "importBlacklist", "importReplaceList", "importAboEntry", "parser", "Ljavax/xml/stream/XMLStreamReader;", "get", "strRet", "", "(Ljavax/xml/stream/XMLStreamReader;[Ljava/lang/String;)Z", "ImportResult", "Companion", "MediathekView"})
public final class OldConfigFileImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Daten daten;
    @NotNull
    private final XMLInputFactory inFactory;
    private static final Logger logger = LogManager.getLogger();

    public OldConfigFileImporter() {
        Daten daten = Daten.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)daten, (String)"getInstance(...)");
        this.daten = daten;
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        Intrinsics.checkNotNullExpressionValue((Object)xMLInputFactory, (String)"newInstance(...)");
        this.inFactory = xMLInputFactory;
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ImportResult importAboBlacklist(@NotNull String datei, boolean importAbo, boolean importBlacklist, boolean importReplaceList) throws IOException, XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)datei, (String)"datei");
        int foundAbos = 0;
        int foundBlacklistEntries = 0;
        int foundReplaceListEntries = 0;
        XMLStreamReader parser = null;
        try {
            Closeable closeable = new FileInputStream(datei);
            Throwable throwable = null;
            try {
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    InputStreamReader isr = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    parser = this.inFactory.createXMLStreamReader(isr);
                    while (true) {
                        XMLStreamReader xMLStreamReader = parser;
                        Intrinsics.checkNotNull((Object)xMLStreamReader);
                        if (!xMLStreamReader.hasNext()) break;
                        int event = parser.next();
                        if (event != 1) continue;
                        if (importAbo && Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"Abonnement")) {
                            if (!this.importAboEntry(parser)) continue;
                            ++foundAbos;
                            continue;
                        }
                        if (importBlacklist && Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"Blacklist")) {
                            try {
                                BlacklistRule rule = new BlacklistRule(null, null, null, null, 15, null);
                                rule.readFromConfig(parser);
                                this.daten.getListeBlacklist().addWithoutNotification(rule);
                                int n = foundBlacklistEntries;
                                foundBlacklistEntries = n + 1;
                            }
                            catch (Exception e) {
                                logger.error("Failed to read blacklist rule", (Throwable)e);
                            }
                            continue;
                        }
                        if (!importReplaceList || !Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"Ersetzungstabelle") || !this.importReplaceList(parser)) continue;
                        ++foundReplaceListEntries;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable throwable) {
            if (parser != null) {
                try {
                    ((XMLStreamReader)parser).close();
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        try {
            parser.close();
        }
        catch (XMLStreamException xMLStreamException) {}
        if (foundAbos > 0) {
            this.daten.getListeAbo().aenderungMelden();
        }
        if (foundBlacklistEntries > 0) {
            this.daten.getListeBlacklist().filterListAndNotifyListeners();
        }
        if (foundReplaceListEntries > 0) {
            MessageBus.getMessageBus().publishAsync((Object)new ReplaceListChangedEvent());
        }
        return new ImportResult(foundAbos, foundBlacklistEntries, foundReplaceListEntries);
    }

    private final boolean importAboEntry(XMLStreamReader parser) {
        boolean bl;
        try {
            DatenAbo datenAbo = new DatenAbo();
            datenAbo.readFromConfig(parser);
            this.daten.getListeAbo().addAbo(datenAbo);
            bl = true;
        }
        catch (Exception exception) {
            logger.error("Error importing abo entry");
            bl = false;
        }
        return bl;
    }

    private final boolean importReplaceList(XMLStreamReader parser) {
        boolean bl;
        String[] sa = new String[2];
        boolean success = this.get(parser, sa);
        if (success) {
            ReplaceList.list.add(sa);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean get(XMLStreamReader parser, String[] strRet) {
        boolean bl;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            if (strRet[i] != null) continue;
            strRet[i] = "";
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"Ersetzungstabelle"))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!Intrinsics.areEqual((Object)parser.getLocalName(), (Object)ReplaceList.COLUMN_NAMES[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
            bl = true;
        }
        catch (Exception ex) {
            logger.error("get", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmediathek/gui/actions/import_actions/OldConfigFileImporter$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lmediathek/gui/actions/import_actions/OldConfigFileImporter$ImportResult;", "", "foundAbos", "", "foundBlacklistEntries", "foundReplaceListEntries", "<init>", "(III)V", "getFoundAbos", "()I", "getFoundBlacklistEntries", "getFoundReplaceListEntries", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "MediathekView"})
    public static final class ImportResult {
        private final int foundAbos;
        private final int foundBlacklistEntries;
        private final int foundReplaceListEntries;

        public ImportResult(int foundAbos, int foundBlacklistEntries, int foundReplaceListEntries) {
            this.foundAbos = foundAbos;
            this.foundBlacklistEntries = foundBlacklistEntries;
            this.foundReplaceListEntries = foundReplaceListEntries;
        }

        public final int getFoundAbos() {
            return this.foundAbos;
        }

        public final int getFoundBlacklistEntries() {
            return this.foundBlacklistEntries;
        }

        public final int getFoundReplaceListEntries() {
            return this.foundReplaceListEntries;
        }

        public final int component1() {
            return this.foundAbos;
        }

        public final int component2() {
            return this.foundBlacklistEntries;
        }

        public final int component3() {
            return this.foundReplaceListEntries;
        }

        @NotNull
        public final ImportResult copy(int foundAbos, int foundBlacklistEntries, int foundReplaceListEntries) {
            return new ImportResult(foundAbos, foundBlacklistEntries, foundReplaceListEntries);
        }

        public static /* synthetic */ ImportResult copy$default(ImportResult importResult, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = importResult.foundAbos;
            }
            if ((n4 & 2) != 0) {
                n2 = importResult.foundBlacklistEntries;
            }
            if ((n4 & 4) != 0) {
                n3 = importResult.foundReplaceListEntries;
            }
            return importResult.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ImportResult(foundAbos=" + this.foundAbos + ", foundBlacklistEntries=" + this.foundBlacklistEntries + ", foundReplaceListEntries=" + this.foundReplaceListEntries + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.foundAbos);
            result2 = result2 * 31 + Integer.hashCode(this.foundBlacklistEntries);
            result2 = result2 * 31 + Integer.hashCode(this.foundReplaceListEntries);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImportResult)) {
                return false;
            }
            ImportResult importResult = (ImportResult)other;
            if (this.foundAbos != importResult.foundAbos) {
                return false;
            }
            if (this.foundBlacklistEntries != importResult.foundBlacklistEntries) {
                return false;
            }
            return this.foundReplaceListEntries == importResult.foundReplaceListEntries;
        }
    }
}

