/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import com.formdev.flatlaf.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Taskbar;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.ShowSettingsDialogEvent;
import mediathek.mac.OsxIndicatorThread;
import mediathek.mac.OsxPowerManager;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.MessageBus;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.MacNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import mediathek.tool.timer.TimerPool;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0002'(B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0014J\b\u0010\u000f\u001a\u00020\tH\u0014J\b\u0010\u0010\u001a\u00020\tH\u0014J\b\u0010\u0011\u001a\u00020\tH\u0014J\b\u0010\u0012\u001a\u00020\tH\u0014J\b\u0010\u0013\u001a\u00020\tH\u0014J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\tH\u0014J\b\u0010\u0018\u001a\u00020\tH\u0014J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0015J\b\u0010\u001c\u001a\u00020\tH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lmediathek/mac/MediathekGuiMac;", "Lmediathek/mainwindow/MediathekGui;", "<init>", "()V", "powerManager", "Lmediathek/mac/OsxPowerManager;", "processorBrand", "", "checkForCorrectArchitecture", "", "resetTabPlacement", "addQuitMenuItem", "addSettingsMenuItem", "setToolBarProperties", "configureTabPlacement", "installToolBar", "createFontMenu", "addFontMenu", "installAdditionalHelpEntries", "setupScrollBarWidth", "initializeSystemTray", "getNotificationCenter", "Lmediathek/tool/notification/INotificationCenter;", "shutdownComputer", "installMenuTabSwitchListener", "handleInstallTabSwitchListenerEvent", "msg", "Lmediathek/gui/messages/InstallTabSwitchListenerEvent;", "initMenus", "createProgressIndicatorThread", "Lmediathek/tool/threads/IndicatorThread;", "handleDownloadStart", "Lmediathek/gui/messages/DownloadStartEvent;", "handleDownloadFinishedEvent", "Lmediathek/gui/messages/DownloadFinishedEvent;", "setDownloadsBadge", "numDownloads", "", "setupUserInterfaceForOsx", "MacToolBarPanel", "Companion", "MediathekView"})
public final class MediathekGuiMac
extends MediathekGui {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OsxPowerManager powerManager = new OsxPowerManager();
    @NotNull
    private static final Logger logger;

    public MediathekGuiMac() {
        TimerPool.getTimerPool().schedule(() -> MediathekGuiMac._init_$lambda$0(this), 15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String processorBrand() throws Throwable {
        Linker linker = Linker.nativeLinker();
        MemorySegment sysctl = linker.defaultLookup().find("sysctlbyname").orElseThrow();
        MemoryLayout[] memoryLayoutArray = new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG};
        MethodHandle sysctlbyname = linker.downcallHandle(sysctl, FunctionDescriptor.of(ValueLayout.JAVA_INT, memoryLayoutArray), new Linker.Option[0]);
        String sysctlName = "machdep.cpu.brand_string";
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment sizePtr = arena.allocate(ValueLayout.JAVA_LONG);
            int res = sysctlbyname.invoke(arena.allocateFrom(sysctlName), MemorySegment.NULL, sizePtr, MemorySegment.NULL, 0L);
            if (res != 0) {
                throw new RuntimeException("sysctlbyname failed to get size");
            }
            long len = sizePtr.get(ValueLayout.JAVA_LONG, 0L);
            MemorySegment buffer = arena.allocate(len);
            res = sysctlbyname.invoke(arena.allocateFrom(sysctlName), buffer, sizePtr, MemorySegment.NULL, 0L);
            if (res != 0) {
                throw new RuntimeException("sysctlbyname failed to get value");
            }
            String string = buffer.getString(0L);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void checkForCorrectArchitecture() {
        logger.trace("Checking for correct JVM architecture on macOS...");
        try {
            boolean isJVMIntel;
            String string = SystemUtils.OS_ARCH;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OS_ARCH");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String jvmBinaryArch = string3;
            String string4 = this.processorBrand().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            boolean isAppleSilicon = StringsKt.contains$default((CharSequence)string4, (CharSequence)"apple", (boolean)false, (int)2, null);
            boolean bl = isJVMIntel = Intrinsics.areEqual((Object)jvmBinaryArch, (Object)"x86_64") || Intrinsics.areEqual((Object)jvmBinaryArch, (Object)"amd64");
            if (isAppleSilicon && isJVMIntel) {
                logger.warn("\u26a0\ufe0f Running an Intel JVM on Apple Silicon. Consider using a native ARM64 JVM for better performance.");
                SwingUtilities.invokeLater(() -> MediathekGuiMac.checkForCorrectArchitecture$lambda$0(this));
            }
        }
        catch (Throwable e) {
            logger.error("Failed to query processor brand", e);
        }
    }

    @Override
    protected void resetTabPlacement() {
    }

    @Override
    protected void addQuitMenuItem() {
    }

    @Override
    protected void addSettingsMenuItem() {
    }

    @Override
    protected void setToolBarProperties() {
    }

    @Override
    protected void configureTabPlacement() {
    }

    @Override
    protected void installToolBar() {
        Container container = this.getContentPane();
        JToolBar jToolBar = this.commonToolBar;
        Intrinsics.checkNotNullExpressionValue((Object)jToolBar, (String)"commonToolBar");
        container.add((Component)new MacToolBarPanel(jToolBar), "First");
    }

    @Override
    protected void createFontMenu() {
    }

    @Override
    protected void addFontMenu() {
    }

    @Override
    protected void installAdditionalHelpEntries() {
    }

    @Override
    protected void setupScrollBarWidth() {
    }

    @Override
    public void initializeSystemTray() {
    }

    @Override
    @NotNull
    protected INotificationCenter getNotificationCenter() {
        return new MacNotificationCenter();
    }

    @Override
    protected void shutdownComputer() {
        Path exePath = null;
        try {
            exePath = GuiFunktionenProgramme.findExecutableOnPath("MVShutdownHelper");
        }
        catch (Exception exception) {
            logger.warn("Could not find MVShutdownHelper executable");
            try {
                exePath = GuiFunktionenProgramme.findExecutableOnPath("mv_shutdown_helper");
            }
            catch (Exception exception2) {
                logger.error("Could not find old mv_shutdown_helper executable");
            }
        }
        if (exePath != null) {
            String[] stringArray = new String[]{"nohup", ((Object)exePath.toAbsolutePath()).toString()};
            Runtime.getRuntime().exec(stringArray);
        } else {
            logger.error("Could not shutdown mac as executable path is null");
        }
    }

    @Override
    protected void installMenuTabSwitchListener() {
    }

    @Override
    @Handler
    protected void handleInstallTabSwitchListenerEvent(@NotNull InstallTabSwitchListenerEvent msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.setupUserInterfaceForOsx();
    }

    @Override
    @NotNull
    protected IndicatorThread createProgressIndicatorThread() {
        return new OsxIndicatorThread();
    }

    @Override
    protected void handleDownloadStart(@NotNull DownloadStartEvent msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.handleDownloadStart(msg);
        this.powerManager.disablePowerManagement();
        this.setDownloadsBadge(this.numDownloadsStarted.get());
    }

    @Override
    protected void handleDownloadFinishedEvent(@NotNull DownloadFinishedEvent msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.handleDownloadFinishedEvent(msg);
        int numDownloads = this.numDownloadsStarted.get();
        if (numDownloads == 0) {
            this.powerManager.enablePowerManagement();
        }
        this.setDownloadsBadge(numDownloads);
    }

    private final void setDownloadsBadge(int numDownloads) {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_BADGE_NUMBER)) {
            if (numDownloads > 0) {
                taskbar.setIconBadge(String.valueOf(numDownloads));
            } else {
                taskbar.setIconBadge("");
            }
        }
    }

    private final void setupUserInterfaceForOsx() {
        Desktop desktop = Desktop.getDesktop();
        desktop.disableSuddenTermination();
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler((arg_0, arg_1) -> MediathekGuiMac.setupUserInterfaceForOsx$lambda$0(this, arg_0, arg_1));
        }
        if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(MediathekGuiMac::setupUserInterfaceForOsx$lambda$1);
        }
        if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(MediathekGuiMac::setupUserInterfaceForOsx$lambda$2);
        }
        JRootPane rootPane = this.getRootPane();
        rootPane.putClientProperty("apple.awt.windowTitleVisible", false);
        if (SystemInfo.isMacFullWindowContentSupported) {
            rootPane.putClientProperty("apple.awt.fullWindowContent", true);
            rootPane.putClientProperty("apple.awt.transparentTitleBar", true);
        }
    }

    private static final void _init_$lambda$0(MediathekGuiMac this$0) {
        this$0.checkForCorrectArchitecture();
    }

    private static final void checkForCorrectArchitecture$lambda$0(MediathekGuiMac this$0) {
        String msg = "<html>Ihr Mac hat eine moderne Apple Silicon CPU.<br/>Sie nutzen jedoch eine MediathekView Version f\u00fcr Intel Prozessoren.<br/><br/>Um die Geschwindigkeit des Programms erheblich zu verbessern laden Sie bitte<br/>die passende <b>MediathekView f\u00fcr Apple Silicon</b> herunter.</html>";
        JOptionPane.showMessageDialog(this$0, msg, "MediathekView", 2);
    }

    private static final void setupUserInterfaceForOsx$lambda$0(MediathekGuiMac this$0, QuitEvent quitEvent, QuitResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!this$0.quitApplication()) {
            response.cancelQuit();
        } else {
            response.performQuit();
        }
    }

    private static final void setupUserInterfaceForOsx$lambda$1(AboutEvent it) {
        new ShowAboutAction().actionPerformed(null);
    }

    private static final void setupUserInterfaceForOsx$lambda$2(PreferencesEvent it) {
        MessageBus.getMessageBus().publishAsync((Object)new ShowSettingsDialogEvent());
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        MediathekGuiMac.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lmediathek/mac/MediathekGuiMac$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lmediathek/mac/MediathekGuiMac$MacToolBarPanel;", "Ljavax/swing/JPanel;", "commonToolBar", "Ljavax/swing/JToolBar;", "<init>", "(Ljavax/swing/JToolBar;)V", "MacFullWindowPlaceHolder", "MediathekView"})
    private static final class MacToolBarPanel
    extends JPanel {
        public MacToolBarPanel(@NotNull JToolBar commonToolBar) {
            Intrinsics.checkNotNullParameter((Object)commonToolBar, (String)"commonToolBar");
            this.setLayout(new BorderLayout());
            this.add((Component)new MacFullWindowPlaceHolder(), "West");
            this.add((Component)commonToolBar, "Center");
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lmediathek/mac/MediathekGuiMac$MacToolBarPanel$MacFullWindowPlaceHolder;", "Ljavax/swing/JPanel;", "<init>", "()V", "MediathekView"})
        private static final class MacFullWindowPlaceHolder
        extends JPanel {
            public MacFullWindowPlaceHolder() {
                this.setLayout(new FlowLayout());
                this.putClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder", "mac zeroInFullScreen");
            }
        }
    }
}

