/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.FileUtils;
import mediathek.tool.http.ByteCounter;
import mediathek.tool.http.MVHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lmediathek/tool/RuntimeStatistics;", "", "<init>", "()V", "startZeit", "Ljava/time/LocalDateTime;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "printRuntimeStatistics", "", "printDataUsageStatistics", "MediathekView"})
public final class RuntimeStatistics {
    @NotNull
    public static final RuntimeStatistics INSTANCE = new RuntimeStatistics();
    @JvmField
    @NotNull
    public static final LocalDateTime startZeit;
    @NotNull
    private static final Logger logger;

    private RuntimeStatistics() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @JvmStatic
    public static final void printRuntimeStatistics() {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime endZeit = LocalDateTime.now();
        LocalTime runTime = LocalTime.MIN.plusSeconds(Duration.between(startZeit, endZeit).toSeconds());
        logger.info("   --> Start:    " + formatter.format(startZeit));
        logger.info("   --> Ende:     " + formatter.format(endZeit));
        logger.info("   --> Laufzeit: " + runTime.getHour() + "h " + runTime.getMinute() + "m " + runTime.getSecond() + "s");
    }

    @JvmStatic
    public static final void printDataUsageStatistics() {
        ByteCounter byteCounter = MVHttpClient.getInstance().getByteCounter();
        logger.info("Total data sent:     " + FileUtils.humanReadableByteCountBinary(byteCounter.totalBytesWritten()));
        logger.info("Total data received: " + FileUtils.humanReadableByteCountBinary(byteCounter.totalBytesRead()));
    }

    static {
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        startZeit = localDateTime;
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        RuntimeStatistics.logger = logger;
    }
}

