/*
 * Decompiled with CFR 0.152.
 */
package mediathek.x11;

import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Field;
import mediathek.config.MVConfig;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.LinuxNotificationCenter;
import mediathek.x11.DesktopEnvDetector;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekGuiX11
extends MediathekGui {
    private static final Logger logger = LogManager.getLogger(MediathekGuiX11.class);

    public MediathekGuiX11() {
        this.setupX11WindowManagerClassName();
    }

    @Override
    protected void createDarkModeToggleButton() {
    }

    @Override
    protected void createMenuBar() {
        super.createMenuBar();
        this.createDarkModeMenuAction();
    }

    @Override
    protected void setupSystemTray() {
        boolean useTray = this.config.getBoolean("application.ui.tray.use", false);
        if (!DesktopEnvDetector.trayIconSupported() && useTray) {
            logger.warn("Application tray icon is not supported on this platform, deactivating.");
            this.config.setProperty("application.ui.tray.use", (Object)false);
        }
        super.setupSystemTray();
    }

    private void setupX11WindowManagerClassName() {
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "MediathekView");
        }
        catch (Exception e) {
            logger.error("Could not set awtAppClassName", (Throwable)e);
        }
    }

    @Override
    protected INotificationCenter getNotificationCenter() {
        LinuxNotificationCenter notificationCenter = new LinuxNotificationCenter();
        if (notificationCenter.hasNativeSupport()) {
            return notificationCenter;
        }
        return new GenericNotificationCenter();
    }

    @Override
    protected void shutdownComputer() {
        String strShutdownCommand;
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_FREE_BSD) {
            strShutdownCommand = MVConfig.get(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN);
            if (strShutdownCommand.isEmpty()) {
                strShutdownCommand = "shutdown -h now";
                MVConfig.add(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "shutdown -h now");
            }
        } else {
            logger.error("shutdown command is unknown for this operating system");
            return;
        }
        try {
            logger.info("Shutdown: {}", (Object)strShutdownCommand);
            Runtime.getRuntime().exec(strShutdownCommand);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }
}

