/*
 * Decompiled with CFR 0.152.
 */
package raven.toast.ui;

import com.formdev.flatlaf.FlatPropertiesLaf;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import raven.toast.util.ShadowRenderer;

public class DropShadowBorder
extends EmptyBorder {
    @FlatStylingSupport.Styleable
    protected final Color shadowColor;
    @FlatStylingSupport.Styleable
    protected final Insets shadowInsets;
    @FlatStylingSupport.Styleable
    protected final float shadowOpacity;
    private Image shadowImage;
    private final int shadowSize;
    private Color lastShadowColor;
    private float lastShadowOpacity;
    private int lastShadowSize;
    private int lastArc;
    private int lastWidth;
    private int lastHeight;

    public DropShadowBorder() {
        this(new Color(0, 0, 0), new Insets(0, 0, 6, 6), 0.1f);
    }

    public DropShadowBorder(Color shadowColor, Insets shadowInsets, float shadowOpacity) {
        super(DropShadowBorder.nonNegativeInsets(shadowInsets));
        this.shadowColor = shadowColor;
        this.shadowInsets = shadowInsets;
        this.shadowOpacity = shadowOpacity;
        this.shadowSize = this.maxInset(shadowInsets);
    }

    private static Insets nonNegativeInsets(Insets shadowInsets) {
        return new Insets(Math.max(shadowInsets.top, 0), Math.max(shadowInsets.left, 0), Math.max(shadowInsets.bottom, 0), Math.max(shadowInsets.right, 0));
    }

    private int maxInset(Insets shadowInsets) {
        return Math.max(Math.max(shadowInsets.left, shadowInsets.right), Math.max(shadowInsets.top, shadowInsets.bottom));
    }

    @Override
    public Insets getBorderInsets() {
        return UIScale.scale((Insets)super.getBorderInsets());
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int outlineWidth;
        JComponent com = (JComponent)c;
        int arc = (Integer)FlatPropertiesLaf.getStyleableValue((JComponent)com, (String)"arc");
        boolean useEffect = (Boolean)FlatPropertiesLaf.getStyleableValue((JComponent)com, (String)"useEffect");
        if (this.shadowImage == null || !this.shadowColor.equals(this.lastShadowColor) || width != this.lastWidth || height != this.lastHeight || this.shadowSize != this.lastShadowSize || this.shadowOpacity != this.lastShadowOpacity || arc != this.lastArc) {
            this.shadowImage = this.createShadowImage(width, height, arc);
            this.lastShadowColor = this.shadowColor;
            this.lastWidth = width;
            this.lastHeight = height;
            this.lastShadowSize = this.shadowSize;
            this.lastShadowOpacity = this.shadowOpacity;
            this.lastArc = arc;
        }
        g.drawImage(this.shadowImage, 0, 0, null);
        Insets insets = this.getBorderInsets();
        int lx = insets.left;
        int ly = insets.top;
        int lw = width - (insets.left + insets.right);
        int lh = height - (insets.top + insets.bottom);
        Graphics2D g2 = (Graphics2D)g.create();
        if (arc > 0) {
            FlatUIUtils.setRenderingHints((Graphics)g2);
            g2.setColor(c.getBackground());
            FlatUIUtils.paintComponentBackground((Graphics2D)g2, (int)lx, (int)ly, (int)lw, (int)lh, (float)0.0f, (float)UIScale.scale((int)arc));
        } else {
            g2.setColor(c.getBackground());
            g2.fillRect(lx, ly, lw, lh);
        }
        if (useEffect) {
            this.createEffect(com, g2, lx, ly, lw, lh, arc);
        }
        if ((outlineWidth = ((Integer)FlatPropertiesLaf.getStyleableValue((JComponent)com, (String)"outlineWidth")).intValue()) > 0) {
            Color outlineColor = (Color)FlatPropertiesLaf.getStyleableValue((JComponent)com, (String)"outlineColor");
            g2.setColor(outlineColor);
            FlatUIUtils.paintOutline((Graphics2D)g2, (float)lx, (float)ly, (float)lw, (float)lh, (float)UIScale.scale((int)outlineWidth), (float)UIScale.scale((int)arc));
        }
        g2.dispose();
    }

    private void createEffect(JComponent c, Graphics2D g2, int x, int y, int width, int height, int arc) {
        Color effectColor = (Color)FlatPropertiesLaf.getStyleableValue((JComponent)c, (String)"effectColor");
        float effectWidth = ((Float)FlatPropertiesLaf.getStyleableValue((JComponent)c, (String)"effectWidth")).floatValue();
        float effectOpacity = ((Float)FlatPropertiesLaf.getStyleableValue((JComponent)c, (String)"effectOpacity")).floatValue();
        boolean effectRight = FlatPropertiesLaf.getStyleableValue((JComponent)c, (String)"effectAlignment").equals("right");
        if (!effectRight) {
            g2.setPaint(new GradientPaint(x, 0.0f, effectColor, (float)x + (float)width * effectWidth, 0.0f, c.getBackground()));
        } else {
            g2.setPaint(new GradientPaint(x + width, 0.0f, effectColor, (float)(x + width) - (float)width * effectWidth, 0.0f, c.getBackground()));
        }
        g2.setComposite(AlphaComposite.SrcOver.derive(effectOpacity));
        if (arc > 0) {
            FlatUIUtils.paintComponentBackground((Graphics2D)g2, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)UIScale.scale((int)arc));
        } else {
            g2.fillRect(x, y, width, height);
        }
        g2.setComposite(AlphaComposite.SrcOver);
    }

    private BufferedImage createShadowImage(int width, int height, int arc) {
        int size = UIScale.scale((int)this.shadowSize);
        float round = UIScale.scale((float)((float)arc * 0.7f));
        int shadowWidth = width - size * 2;
        int shadowHeight = height - size * 2;
        Shape shape = FlatUIUtils.createRoundRectanglePath((float)0.0f, (float)0.0f, (float)shadowWidth, (float)shadowHeight, (float)round, (float)round, (float)round, (float)round);
        return new ShadowRenderer(size, this.shadowOpacity, this.shadowColor).createShadow(shape);
    }
}

