/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.jetbrains.annotations.Nls;

public class MultiFileFilter
extends FileFilter {
    private String[] suffixes;
    private String name;
    private String description;
    private boolean exact;

    public MultiFileFilter(String suffix, @Nls String name) {
        this(suffix, name, false);
    }

    public MultiFileFilter(String suffix, @Nls String name, boolean exact) {
        this(new String[]{suffix}, name, exact);
    }

    public MultiFileFilter(String[] suffixes, @Nls String name) {
        this(suffixes, name, false);
    }

    public MultiFileFilter(String[] suffixes, @Nls String name, boolean exact) {
        this.suffixes = suffixes;
        this.name = name;
        this.exact = exact;
        StringBuilder buffer = new StringBuilder();
        for (String suffix : suffixes) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if (!exact) {
                int dotIndex = suffix.indexOf(46);
                if (dotIndex == -1) {
                    buffer.append("*.");
                } else if (dotIndex == 0) {
                    buffer.append("*");
                }
            }
            buffer.append(suffix);
        }
        this.description = name != null ? name + " (" + buffer + ")" : buffer.toString();
    }

    @Nls
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public boolean isExact() {
        return this.exact;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName();
        int lastDotIndex = fileName.lastIndexOf(".");
        String testFileName = lastDotIndex > -1 ? fileName.toLowerCase(Locale.ENGLISH) : "";
        for (String testSuffix : this.suffixes) {
            if (testSuffix.equals("*")) {
                return true;
            }
            if (!(this.exact || testSuffix.indexOf(46) > 0 ? fileName.equalsIgnoreCase(testSuffix) : testFileName.endsWith(testSuffix.toLowerCase(Locale.ENGLISH)))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        return other instanceof MultiFileFilter && Arrays.equals(((MultiFileFilter)other).suffixes, this.suffixes);
    }
}

