/*
 * Decompiled with CFR 0.152.
 */
package mediathek.x11;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;

public final class DesktopEnvDetector {
    private DesktopEnvDetector() {
    }

    public static boolean trayIconSupported() {
        if (!SystemUtils.IS_OS_LINUX) {
            return true;
        }
        return DesktopEnvDetector.detect() != DesktopEnvironment.KDE;
    }

    public static DesktopEnvironment detect() {
        String envValue = DesktopEnvDetector.getDesktopEnvFromVariables().toUpperCase(Locale.ROOT);
        if (envValue.contains("KDE")) {
            return DesktopEnvironment.KDE;
        }
        if (envValue.contains("GNOME")) {
            return DesktopEnvironment.GNOME;
        }
        if (envValue.contains("UNITY")) {
            return DesktopEnvironment.UNITY;
        }
        if (DesktopEnvDetector.isProcessRunning("plasmashell")) {
            return DesktopEnvironment.KDE;
        }
        if (DesktopEnvDetector.isProcessRunning("gnome-shell")) {
            return DesktopEnvironment.GNOME;
        }
        if (DesktopEnvDetector.isProcessRunning("unity-panel-service")) {
            return DesktopEnvironment.UNITY;
        }
        return DesktopEnvironment.UNKNOWN;
    }

    private static String getDesktopEnvFromVariables() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("XDG_CURRENT_DESKTOP")) {
            return env.get("XDG_CURRENT_DESKTOP");
        }
        if (env.containsKey("DESKTOP_SESSION")) {
            return env.get("DESKTOP_SESSION");
        }
        if (env.containsKey("GDMSESSION")) {
            return env.get("GDMSESSION");
        }
        if (env.containsKey("GNOME_DESKTOP_SESSION_ID")) {
            return "GNOME";
        }
        return "unknown";
    }

    private static boolean isProcessRunning(String process) {
        try {
            Process p = new ProcessBuilder("pgrep", "-x", process).redirectErrorStream(true).start();
            int exitCode = p.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public static enum DesktopEnvironment {
        KDE,
        GNOME,
        UNITY,
        UNKNOWN;

    }
}

