/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.applaunch;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.launcher.Variables;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.styles.StyleManagerImpl;
import com.install4j.runtime.installer.Application;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.applaunch.ParentIPCThread;
import com.install4j.runtime.installer.helper.applaunch.ProgressCommunication;
import com.install4j.runtime.installer.helper.applaunch.ShutdownWaiter;
import com.install4j.runtime.installer.helper.comm.InterProcessCommunication;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.integration.UpdateLog;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationLauncherImpl {
    public static boolean waitForInProcessApplication(long timeout, TimeUnit unit) throws InterruptedException {
        if (InstallerConfig.getCurrentApplication() == null) {
            return true;
        }
        long startTime = System.nanoTime();
        while (InstallerConfig.getCurrentInstance() != null && (timeout == 0L || unit.toNanos(timeout) > System.nanoTime() - startTime)) {
            Thread.sleep(30L);
        }
        return InstallerConfig.getCurrentInstance() == null;
    }

    public static void launchApplicationInProcess(String applicationId, String[] arguments, ApplicationLauncher.Callback callback, ApplicationLauncher.WindowMode windowMode, Object parentWindow) {
        if (InstallerConfig.getCurrentApplication() != null) {
            throw new IllegalStateException("Only one installer application can be run at the same time.");
        }
        if (Util.isMacOS() && LauncherEngine.getBooleanProperty(10007)) {
            throw new IllegalStateException("On macOS, SWT/QT applications can not launch installer applications in-process. Use \"launchApplication\" instead.");
        }
        Runnable runnable = () -> {
            ApplicationLauncher.ProgressListener progressListener;
            InstallerUtil.setInProcessCallback(callback);
            if (callback != null && (progressListener = callback.createProgressListener()) != null) {
                ProgressCommunication.registerInProcess(progressListener);
            }
            try {
                Application.runApplicationInProcess(applicationId, arguments, windowMode == ApplicationLauncher.WindowMode.DIALOG, (Window)parentWindow);
            }
            finally {
                Variables.clearInstallerVariablesCache();
                StyleManagerImpl.getInstance().clear();
                ProgressCommunication.registerInProcess(null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    public static void launchApplication(String applicationId, String[] arguments, boolean blocking, ApplicationLauncher.Callback callback) throws IOException {
        String launcherId;
        InstallerConfig config = InstallerConfig.getConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
        com.install4j.runtime.beans.applications.Application app = config.getApplicationById(applicationId);
        if (app == null) {
            throw new IOException("Application with ID " + applicationId + " could not be found");
        }
        if (!(app instanceof CustomApplication)) {
            throw new IOException("Application is no custom application");
        }
        CustomApplication customApplication = (CustomApplication)app;
        File commFile = File.createTempFile("i4jshd", ".tmp");
        ArrayList<String> realArgs = new ArrayList<String>();
        File executable = ApplicationLauncherImpl.getExecutable(applicationId, config, customApplication, realArgs);
        if (arguments != null) {
            realArgs.addAll(Arrays.asList(arguments));
        }
        realArgs.add("-Dinstall4j.shutdownFile=" + commFile.getAbsolutePath());
        realArgs.add("-Dinstall4j.fromService=" + Launcher.isService());
        String launcherPath = System.getProperty("exe4j.moduleName");
        if (launcherPath != null) {
            realArgs.add("-Dinstall4j.fromLauncher=" + launcherPath);
        }
        if ((launcherId = System.getProperty("install4j.launcherId")) != null) {
            realArgs.add("-Dinstall4j.fromLauncherId=" + launcherId);
        }
        UpdateLog.addUpdateLogProperty(realArgs);
        ApplicationLauncher.ProgressListener progressListener = ApplicationLauncherImpl.createProgressListener(callback);
        InterProcessCommunication communication = progressListener != null ? ApplicationLauncherImpl.createCommunication(realArgs) : null;
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(executable).arguments(realArgs.toArray(new String[0])).receiveProcess(true);
        if (LaunchHelper.launchApplication(launchDescriptor) == null) {
            throw new IOException("Could not start process");
        }
        ShutdownWaiter shutdownWaiter = new ShutdownWaiter(commFile, callback, launchDescriptor.getProcess());
        shutdownWaiter.start();
        if (communication != null) {
            new ParentIPCThread(communication, shutdownWaiter, progressListener).start();
        }
        if (blocking) {
            try {
                launchDescriptor.getProcess().waitFor();
                shutdownWaiter.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    private static File getExecutable(String applicationId, InstallerConfig config, CustomApplication customApplication, List<String> realArgs) {
        File executable = Application.getExeFile(customApplication);
        if (executable == null || !executable.exists()) {
            StringUtil.splitupCommandLine(realArgs, customApplication.getVmParameters());
            if (Util.isMacOS()) {
                StringUtil.splitupCommandLine(realArgs, ApplicationLauncherImpl.getDockOptions(config, customApplication, applicationId, executable));
            }
            realArgs.add("-classpath");
            String classpath = new File(ResourceHelper.getRuntimeDir(), "i4jruntime.jar").getAbsolutePath();
            realArgs.add(classpath);
            realArgs.add(Application.class.getName());
            realArgs.add(String.valueOf(applicationId));
            StringUtil.splitupCommandLine(realArgs, customApplication.getArguments());
            return new File(System.getProperty("java.home"), "bin/java" + (Util.isWindows() ? ".exe" : ""));
        }
        return executable;
    }

    @Nullable
    private static ApplicationLauncher.ProgressListener createProgressListener(ApplicationLauncher.Callback callback) {
        if (callback != null && (Util.isWindows() || Util.isMacOS() || Util.isLinux() || Boolean.getBoolean("install4j.forceProgressListener"))) {
            return callback.createProgressListener();
        }
        return null;
    }

    @Nullable
    private static InterProcessCommunication createCommunication(List<String> realArgs) {
        InterProcessCommunication communication = new InterProcessCommunication(null, null, true, new InterProcessCommunication.ErrorLogger(){

            @Override
            public void log(String str) {
                System.err.println(str);
            }

            @Override
            public void log(Throwable t) {
                t.printStackTrace();
            }
        });
        String id = communication.createListener();
        if (id == null) {
            return null;
        }
        realArgs.add("-Dinstall4j.progressId=" + id);
        realArgs.add("-Dinstall4j.progressHash=" + communication.getHash());
        return communication;
    }

    public static String getDockOptions(InstallerConfig config, ApplicationWithPath application, String applicationId, @Nullable File executable) {
        StringBuilder buffer = new StringBuilder();
        File iconFile = ApplicationLauncherImpl.getMacosIconFile(config, application, applicationId, executable);
        if (iconFile != null && iconFile.exists()) {
            buffer.append("\"-Xdock:icon=").append(iconFile.getAbsolutePath()).append("\" ");
        }
        buffer.append("\"-Xdock:name=").append(application.getExecutableName()).append("\"");
        return buffer.toString();
    }

    @Nullable
    private static File getMacosIconFile(InstallerConfig config, ApplicationWithPath application, String applicationId, @Nullable File executable) {
        if (executable == null) {
            return null;
        }
        File iconFile = new File(executable.getAbsolutePath() + ".app", "Contents/Resources/app.icns");
        if (!iconFile.exists()) {
            if (Objects.equals(applicationId, "uninstaller")) {
                return ApplicationLauncherImpl.getMacosUninstallerIcon(config, executable);
            }
            if (config.getMacSpecificConfig().isSingleBundle()) {
                return ApplicationLauncherImpl.getMacosSingleBundleAppIcon(config, application);
            }
            return null;
        }
        return iconFile;
    }

    @NotNull
    private static File getMacosUninstallerIcon(InstallerConfig config, @NotNull File executable) {
        String applicationName = ContentInstaller.replaceSlashes(config.getApplicationName());
        String uninstallerName = Messages.format(Messages.getString(".UninstallerMenuEntry"), applicationName);
        return new File(executable.getParentFile() + "/" + uninstallerName + ".app", "Contents/Resources/app.icns");
    }

    @NotNull
    private static File getMacosSingleBundleAppIcon(InstallerConfig config, ApplicationWithPath application) {
        String executableDir = ApplicationLauncherImpl.getMacosExecutableDir(config, application);
        File iconFile = new File(ResourceHelper.getRuntimeDir(), "icons/" + executableDir + "/" + application.getExecutableName() + ".icns");
        if (!iconFile.exists()) {
            return new File(ResourceHelper.getRuntimeDir(), "icons/app.icns");
        }
        return iconFile;
    }

    @NotNull
    private static String getMacosExecutableDir(InstallerConfig config, ApplicationWithPath application) {
        String executableDir = application.getUsedExecutableDirectory();
        if (executableDir.startsWith(config.getMacSpecificConfig().getRuntimeDirParent())) {
            return executableDir.substring(config.getMacSpecificConfig().getRuntimeDirParent().length());
        }
        return executableDir;
    }
}

