/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.fileinst.InstallHelper;
import com.install4j.runtime.installer.helper.fileinst.UninstallLogNotFoundException;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

class FileRemover {
    public static final String DS_STORE_NAME = ".DS_Store";
    private List<File> undeletedFiles = new ArrayList<File>();
    private List<File> undeletedDirs = new ArrayList<File>();
    private Set<File> retainedFiles = new HashSet<File>();
    private boolean isUninstalling = false;
    private boolean uninstallForUpgrade = false;
    private Set<File> parentFoldersOfDeletedFiles = new HashSet<File>();
    private Set<File> classPathFiles;
    private File installationDirectory;
    private boolean debug;

    FileRemover() {
    }

    public void rollback(ProgressInterface progressInterface, int id) {
        this.rollback(progressInterface, FileInstallerState.getInstance().getRollbackFileLogger(), id);
    }

    public void rollback(ProgressInterface progressInterface, FileLogger fileLogger, int id) {
        this.debug = FileRemover.getDebug();
        boolean fileRollbackPerformed = false;
        Collection<InstallFile> createdFiles = fileLogger.getCreatedFiles(id);
        Collection<InstallFile> createdDirs = fileLogger.getCreatedDirs(id);
        List<BackupPair> replacedFiles = fileLogger.getReplacedFiles(id);
        if (this.debug) {
            Logger.getInstance().info(null, "created files: " + createdFiles);
            Logger.getInstance().info(null, "created directories: " + createdDirs);
            Logger.getInstance().info(null, "replaced files: " + replacedFiles);
            Logger.getInstance().info(null, "retained files: " + this.retainedFiles);
        }
        int fileCount = createdFiles.size() + createdDirs.size() + replacedFiles.size();
        int currentProgress = 0;
        for (int i = replacedFiles.size() - 1; i >= 0; --i) {
            BackupPair backupPair = replacedFiles.get(i);
            currentProgress = FileRemover.restoreBackupFile(progressInterface, fileCount, currentProgress, backupPair);
        }
        for (InstallFile file : createdFiles) {
            if (this.debug) {
                Logger.getInstance().info(null, "checking file " + file);
            }
            if (!(this.isRetainedFile(file) || this.isUninstalling && !file.checkUninstall(this.uninstallForUpgrade))) {
                if (file.isShared()) {
                    if (InstallHelper.unregisterShared(file)) {
                        fileRollbackPerformed = true;
                        this.deleteCreatedFile(file);
                    }
                } else {
                    fileRollbackPerformed = true;
                    this.deleteCreatedFile(file);
                }
            }
            progressInterface.setPercentCompleted(++currentProgress * 100 / fileCount);
        }
        for (InstallFile dir : createdDirs) {
            if (this.debug) {
                Logger.getInstance().info(null, "checking directory " + dir);
            }
            if (!(this.isRetainedFile(dir) || this.isUninstalling && !dir.checkUninstall(this.uninstallForUpgrade))) {
                fileRollbackPerformed = true;
                this.deleteDir(dir);
            }
            progressInterface.setPercentCompleted(++currentProgress * 100 / fileCount);
        }
        this.deleteParentFolders();
        if (fileRollbackPerformed) {
            FileInstallerState.getInstance().setFileRollbackPerformed(true);
        }
        FileInstallerState.getInstance().addRolledBackId(id);
    }

    private void deleteCreatedFile(InstallFile file) {
        List<InstallFile.Command> preUninstallCommands = file.getPreUninstallCommands();
        if (!preUninstallCommands.isEmpty()) {
            for (final InstallFile.Command command : preUninstallCommands) {
                ExecutionContext executionContext = command.isAdminRights() ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED;
                try {
                    HelperCommunication.getInstance().executeActionChecked(executionContext, new RunAction(){

                        @Override
                        protected void run(Context context) {
                            MenuHelper.execute(command.getExecutable(), command.getArguments());
                        }
                    });
                }
                catch (Exception e) {
                    Logger.getInstance().log(e);
                }
            }
        }
        this.deleteFile(file);
    }

    private static boolean getDebug() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return Boolean.getBoolean("install4j.debugFileRemover");
            }
        });
    }

    private boolean isRetainedFile(File file) {
        return this.retainedFiles.contains(file);
    }

    private static int restoreBackupFile(ProgressInterface progressInterface, int fileCount, int currentProgress, final BackupPair backupPair) {
        ExecutionContext executionContext = backupPair.isElevated() ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED;
        try {
            HelperCommunication.getInstance().executeActionChecked(executionContext, new RunAction(){

                @Override
                protected void run(Context context) {
                    backupPair.restore();
                }
            });
        }
        catch (Exception e) {
            String message = Messages.format(Messages.getString(".ErrorInternal2"), "Could not restore " + backupPair.getOriginalFile());
            progressInterface.showFailure(message);
        }
        progressInterface.setPercentCompleted(++currentProgress * 100 / fileCount);
        return currentProgress;
    }

    public void finishUninstall() throws IOException {
        if (!(!InstallerUtil.isWindows() || this.undeletedFiles.isEmpty() && this.undeletedDirs.isEmpty())) {
            if (WinDel.isUsed()) {
                WinDel.scheduleDeletion(this.undeletedFiles, this.undeletedDirs, true);
            } else {
                WinDel.setUsed(true);
                Runtime.getRuntime().addShutdownHook(new Thread("temp_deletion_starter"){

                    @Override
                    public void run() {
                        try {
                            WinDel.scheduleDeletion(FileRemover.this.undeletedFiles, FileRemover.this.undeletedDirs, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    private void deleteParentFolders() {
        ContextInt context = ContextImpl.getSingleContextInt();
        ArrayList<File> parentList = new ArrayList<File>(this.parentFoldersOfDeletedFiles);
        Collections.sort(parentList);
        for (int i = parentList.size() - 1; i >= 0; --i) {
            File dir = (File)parentList.get(i);
            if (!FileUtil.isContainedInOrEquals(dir, context.getInstallationDirectory())) continue;
            this.preDeleteDir(dir);
            if (dir.delete() || !dir.exists() || !Util.isWindows() || this.undeletedDirs.contains(dir)) continue;
            this.undeletedDirs.add(dir);
        }
    }

    public void deleteRecursive(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.deleteRecursive(child);
                }
            }
            this.deleteDir(file);
        } else if (file.exists()) {
            this.deleteFile(file);
        }
    }

    public void deleteFile(File file) {
        if (!this.handleClassPathFile(file) && !this.doDeleteFile(file)) {
            this.undeletedFiles.add(file);
        }
        this.parentFoldersOfDeletedFiles.add(file.getParentFile());
    }

    private boolean doDeleteFile(File file) {
        if (this.debug) {
            Logger.getInstance().info(null, "deleting " + file);
        }
        if (this.tryDelete(file)) {
            if (this.debug) {
                Logger.getInstance().info(null, "deletion failed");
            }
            if (!Util.isWindows() && file.exists() && (!file.isDirectory() || this.isEmpty(file))) {
                System.setProperty("install4j.noDefaultChmod", "false");
                LegacyUnixFileSystem.setMode(file.isDirectory() ? "755" : "644", file);
                if (this.tryDelete(file)) {
                    return true;
                }
            }
        }
        if (this.debug && file.exists()) {
            Logger.getInstance().info(null, "file exists");
        }
        return !file.exists();
    }

    private boolean tryDelete(File file) {
        try {
            return !file.delete() && !Files.deleteIfExists(file.toPath());
        }
        catch (Exception e) {
            if (FileRemover.getDebug()) {
                Logger.getInstance().log(e);
            }
            return false;
        }
    }

    private boolean isEmpty(File file) {
        String[] children = file.list();
        return children == null || children.length == 0;
    }

    public void deleteDir(File dir) {
        this.preDeleteDir(dir);
        if (!dir.delete() && dir.exists()) {
            this.undeletedDirs.add(dir);
        }
        this.parentFoldersOfDeletedFiles.add(dir.getParentFile());
    }

    private void preDeleteDir(File dir) {
        File[] files;
        if (InstallerUtil.isMacOS() && dir.exists() && (files = dir.listFiles()) != null && files.length == 1 && Objects.equals(files[0].getName(), DS_STORE_NAME)) {
            files[0].delete();
        }
    }

    public void cleanup(ProgressInterface progressInterface) {
        List<BackupPair> replacedFiles = FileInstallerState.getInstance().getReplacedFiles();
        for (int j = 0; j < replacedFiles.size(); ++j) {
            BackupPair backupPair = replacedFiles.get(j);
            backupPair.cleanup();
            progressInterface.setPercentCompleted((j + 1) * 100 / replacedFiles.size());
        }
        List<File> cleanupFiles = FileInstallerState.getInstance().getCleanupFiles();
        for (File cleanupFile : cleanupFiles) {
            cleanupFile.delete();
        }
        this.deleteUndeleted();
    }

    public List<File> deleteUndeleted() {
        this.doDeleteUndeleted();
        if (!this.undeletedDirs.isEmpty() || !this.undeletedFiles.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.doDeleteUndeleted();
        }
        ArrayList<File> ret = new ArrayList<File>(this.undeletedDirs);
        ret.addAll(this.undeletedFiles);
        return ret;
    }

    private void doDeleteUndeleted() {
        this.undeletedFiles.removeIf(this::doDeleteFile);
        this.doDeleteDirs();
        this.deleteParentFolders();
    }

    private void doDeleteDirs() {
        this.undeletedDirs.removeIf(this::doDeleteFile);
    }

    public void uninstall(ProgressInterface progressInterface, boolean uninstallForUpgrade, File installationDirectory) throws IOException {
        this.installationDirectory = installationDirectory;
        File logFile = InstallerUtil.getInstallerFile("files.log");
        FileLogger fileLogger = new FileLogger();
        try {
            fileLogger.read(logFile);
        }
        catch (FileNotFoundException e) {
            throw new UninstallLogNotFoundException(e.getMessage());
        }
        if (!uninstallForUpgrade) {
            this.deleteFile(logFile);
        }
        this.isUninstalling = true;
        this.uninstallForUpgrade = uninstallForUpgrade;
        if (InstallerUtil.isWindows()) {
            WinDel.prepareDeletion(InstallerUtil.getInstallerFile("i4jdel.exe"));
        }
        this.rollback(progressInterface, fileLogger, -1);
        if (uninstallForUpgrade) {
            FileRemover.writeUninstallLog(fileLogger, logFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeUninstallLog(FileLogger fileLogger, File logFile) throws IOException {
        HashSet<File> allDirs = new HashSet<File>();
        Iterator<InstallFile> it = fileLogger.getCreatedFiles(-1).iterator();
        while (it.hasNext()) {
            InstallFile installFile = it.next();
            if (installFile.getUninstallMode() == UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE || installFile.getUninstallMode() == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                InstallHelper.addDirs(installFile.getParentFile(), allDirs);
                continue;
            }
            it.remove();
        }
        for (InstallFile installFile : fileLogger.getCreatedDirs(-1)) {
            if (installFile.getUninstallMode() != UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE && installFile.getUninstallMode() != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) continue;
            InstallHelper.addDirs(installFile, allDirs);
        }
        it = fileLogger.getCreatedDirs(-1).iterator();
        while (it.hasNext()) {
            void var4_10;
            File file = it.next();
            try {
                File file2 = file.getCanonicalFile();
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
            if (allDirs.contains(var4_10)) continue;
            it.remove();
        }
        fileLogger.write(logFile, null);
    }

    private boolean handleClassPathFile(File file) {
        this.initClassPathFiles();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
        }
        if (this.classPathFiles.contains(file)) {
            Logger.getInstance().info(this, "postponing deletion of " + file);
            this.undeletedFiles.add(file);
            return true;
        }
        return false;
    }

    private void initClassPathFiles() {
        if (this.classPathFiles == null) {
            String bootClassPath;
            this.classPathFiles = new HashSet<File>();
            String classpath = System.getProperty("java.class.path");
            if (classpath != null) {
                FileRemover.addFiles(this.classPathFiles, classpath);
            }
            if ((bootClassPath = System.getProperty("sun.boot.class.path")) != null) {
                FileRemover.addFiles(this.classPathFiles, bootClassPath);
            }
            for (URL url : Install4jClassLoader.getInstance().getAddedURLs()) {
                File customCodeFile = FileRemover.getFile(url);
                if (customCodeFile == null) continue;
                try {
                    customCodeFile = customCodeFile.getCanonicalFile();
                }
                catch (IOException e) {
                    Logger.getInstance().log(e);
                }
                this.classPathFiles.add(customCodeFile);
            }
        }
    }

    private static File getFile(URL url) {
        if (url != null && Objects.equals("file", url.getProtocol())) {
            try {
                return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void addFiles(Set<File> files, String stringList) {
        if (stringList == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(stringList, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File file = new File(tok.nextToken());
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
            files.add(file);
        }
    }

    public void addRetainedFile(File file) {
        this.retainedFiles.add(FileUtil.getCanonicalFile(file));
    }
}

