/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.util.StringTokenizer;

public class VersionCheck {
    private static final NumberSplit UNAVAILABLE_SPLIT = new NumberSplit("", "0");

    public static boolean checkJavaVersionCompatible(String expectedLower, String expectedHigher) {
        return VersionCheck.checkCompatible(expectedLower, expectedHigher, false);
    }

    public static boolean checkCompatible(String expectedLower, String expectedHigher) {
        return VersionCheck.checkCompatible(expectedLower, expectedHigher, true);
    }

    public static boolean checkCompatible(String expectedLower, String expectedHigher, boolean useNonNumeric) {
        expectedLower = VersionCheck.prepareForVersionComparison(expectedLower);
        expectedHigher = VersionCheck.prepareForVersionComparison(expectedHigher);
        StringTokenizer expectedLowerTokenizer = new StringTokenizer(expectedLower, ".");
        StringTokenizer expectedHigherTokenizer = new StringTokenizer(expectedHigher, ".");
        while (expectedLowerTokenizer.hasMoreTokens() || expectedHigherTokenizer.hasMoreTokens()) {
            NumberSplit expectedHigherToken;
            NumberSplit expectedLowerToken = expectedLowerTokenizer.hasMoreTokens() ? VersionCheck.extractNumbers(expectedLowerTokenizer.nextToken()) : UNAVAILABLE_SPLIT;
            NumberSplit numberSplit = expectedHigherToken = expectedHigherTokenizer.hasMoreTokens() ? VersionCheck.extractNumbers(expectedHigherTokenizer.nextToken()) : UNAVAILABLE_SPLIT;
            if (useNonNumeric && !expectedLowerToken.nonNumericPart.isEmpty() && expectedHigherToken.nonNumericPart.isEmpty()) {
                return true;
            }
            if (useNonNumeric && expectedLowerToken.nonNumericPart.isEmpty() && !expectedHigherToken.nonNumericPart.isEmpty()) {
                return false;
            }
            int textComparison = expectedLowerToken.nonNumericPart.compareTo(expectedHigherToken.nonNumericPart);
            if (useNonNumeric && textComparison != 0) {
                return textComparison < 0;
            }
            long expectedLowerVersionPart = Long.parseLong(expectedLowerToken.numericPart);
            long expectedHigherVersionPart = Long.parseLong(expectedHigherToken.numericPart);
            if (expectedHigherVersionPart == expectedLowerVersionPart) continue;
            return expectedHigherVersionPart > expectedLowerVersionPart;
        }
        return !expectedLowerTokenizer.hasMoreTokens();
    }

    private static String prepareForVersionComparison(String version) {
        StringBuilder comparableVersion = new StringBuilder();
        char previousCharacter = '\u0000';
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Character.isDigit(c)) {
                comparableVersion.append(c);
            } else if (c == '.' || c == '-' || c == '_') {
                if (previousCharacter != '.') {
                    comparableVersion.append(".");
                }
            } else {
                if (Character.isDigit(previousCharacter) || previousCharacter == '\u0000') {
                    comparableVersion.append(".");
                }
                comparableVersion.append(Character.toLowerCase(c));
            }
            previousCharacter = comparableVersion.charAt(comparableVersion.length() - 1);
        }
        return comparableVersion.toString();
    }

    private static NumberSplit extractNumbers(String text) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            return new NumberSplit(new String(chars, 0, i), new String(chars, i, chars.length - i));
        }
        return new NumberSplit(text, "0");
    }

    private static class NumberSplit {
        final String nonNumericPart;
        final String numericPart;

        public NumberSplit(String nonNumericPart, String numericPart) {
            this.nonNumericPart = nonNumericPart;
            this.numericPart = numericPart;
        }
    }
}

