/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_downloads;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Taskbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.controller.history.MVUsedUrl;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.ListeDownloads;
import mediathek.daten.abo.DatenAbo;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.actions.AdvanceDownloadsAction;
import mediathek.gui.actions.CleanupDownloadListAction;
import mediathek.gui.actions.DeferDownloadsAction;
import mediathek.gui.actions.DeleteDownloadAction;
import mediathek.gui.actions.DeleteDownloadsAction;
import mediathek.gui.actions.EditDownloadAction;
import mediathek.gui.actions.MergeSubtitleWithVideoAction;
import mediathek.gui.actions.OpenTargetFolderAction;
import mediathek.gui.actions.PlayDownloadAction;
import mediathek.gui.actions.RefreshDownloadListAction;
import mediathek.gui.actions.StartAllDownloadsAction;
import mediathek.gui.actions.StartAllDownloadsTimedAction;
import mediathek.gui.actions.StartDownloadsAction;
import mediathek.gui.actions.StopAllDownloadsAction;
import mediathek.gui.actions.StopAllWaitingDownloadsAction;
import mediathek.gui.actions.StopDownloadsAction;
import mediathek.gui.dialog.DialogBeendenZeit;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.dialog.DialogEditDownload;
import mediathek.gui.filmInformation.FilmInfoDialog;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.DownloadProgressChangedEvent;
import mediathek.gui.messages.DownloadQueueRankChangedEvent;
import mediathek.gui.messages.GeoStateChangedEvent;
import mediathek.gui.messages.RestartDownloadEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.gui.tabs.AGuiTabPanel;
import mediathek.gui.tabs.tab_downloads.AboLabel;
import mediathek.gui.tabs.tab_downloads.ActiveDownloadsInfoLabel;
import mediathek.gui.tabs.tab_downloads.DownloadStartInfoProperty;
import mediathek.gui.tabs.tab_downloads.DownloadsConfigPanel;
import mediathek.gui.tabs.tab_downloads.FailedDownloadsInfoLabel;
import mediathek.gui.tabs.tab_downloads.FinishedDownloadsInfoLabel;
import mediathek.gui.tabs.tab_downloads.ManualDownloadsInfoLabel;
import mediathek.gui.tabs.tab_downloads.TotalDownloadsLabel;
import mediathek.gui.tabs.tab_downloads.WaitingDownloadsInfoLabel;
import mediathek.gui.tabs.tab_film.FilmDescriptionPanel;
import mediathek.mainwindow.MediathekGui;
import mediathek.swing.IconUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.DirOpenAction;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Listener;
import mediathek.tool.MVFilmSize;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.OpenPlayerAction;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.cellrenderer.CellRendererDownloads;
import mediathek.tool.datum.Datum;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelDownload;
import mediathek.tool.table.MVDownloadsTable;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXStatusBar;
import org.jetbrains.annotations.NotNull;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome6.FontAwesomeSolid;

public class GuiDownloads
extends AGuiTabPanel {
    public static final String NAME = "Downloads";
    public static final int DIVIDER_LOCATION = -1;
    private static final String COMBO_DISPLAY_ALL = "alle";
    private static final String COMBO_DISPLAY_DOWNLOADS_ONLY = "nur Downloads";
    private static final String COMBO_DISPLAY_ABOS_ONLY = "nur Abos";
    private static final String COMBO_VIEW_ALL = "alle";
    private static final String COMBO_VIEW_NOT_STARTED = "nicht gestartet";
    private static final String COMBO_VIEW_STARTED = "gestartet";
    private static final String COMBO_VIEW_WAITING = "nur wartende";
    private static final String COMBO_VIEW_RUN_ONLY = "nur laufende";
    private static final String COMBO_VIEW_FINISHED_ONLY = "nur abgeschlossene";
    private static final String ACTION_MAP_KEY_EDIT_DOWNLOAD = "dl_aendern";
    private static final String ACTION_MAP_KEY_DELETE_DOWNLOAD = "dl_delete";
    private static final String ACTION_MAP_KEY_MARK_AS_SEEN = "seen";
    private static final String ACTION_MAP_KEY_MAERK_AS_UNSEEN = "unseen";
    private static final String ACTION_MAP_KEY_START_DOWNLOAD = "dl_start";
    private static final int[] COLUMNS_DISABLED = new int[]{6, 7, 39, 22};
    private static final Logger logger = LogManager.getLogger(GuiDownloads.class);
    protected final StartAllDownloadsAction startAllDownloadsAction = new StartAllDownloadsAction(this);
    protected final StartAllDownloadsTimedAction startAllDownloadsTimedAction = new StartAllDownloadsTimedAction(this);
    protected final StopAllDownloadsAction stopAllDownloadsAction = new StopAllDownloadsAction(this);
    protected final StopAllWaitingDownloadsAction stopAllWaitingDownloadsAction = new StopAllWaitingDownloadsAction(this);
    protected final RefreshDownloadListAction refreshDownloadListAction = new RefreshDownloadListAction(this);
    protected final CleanupDownloadListAction cleanupDownloadListAction = new CleanupDownloadListAction(this);
    protected final PlayDownloadAction playDownloadAction = new PlayDownloadAction(this);
    protected final StopDownloadsAction stopDownloadsAction = new StopDownloadsAction(this);
    protected final StartDownloadsAction startDownloadsAction = new StartDownloadsAction(this);
    protected final DeferDownloadsAction deferDownloadsAction = new DeferDownloadsAction(this);
    protected final AdvanceDownloadsAction advanceDownloadsAction = new AdvanceDownloadsAction(this);
    protected final DeleteDownloadsAction deleteDownloadsAction = new DeleteDownloadsAction(this);
    protected final EditDownloadAction editDownloadAction = new EditDownloadAction(this);
    protected final DeleteDownloadAction deleteDownloadAction = new DeleteDownloadAction(this);
    protected final OpenTargetFolderAction openTargetFolderAction = new OpenTargetFolderAction(this);
    protected final ToggleFilterPanelAction toggleFilterPanelAction = new ToggleFilterPanelAction(this);
    protected final MergeSubtitleWithVideoAction mergeSubtitleWithVideoAction = new MergeSubtitleWithVideoAction(MediathekGui.ui());
    protected final JToolBar swingToolBar = new JToolBar();
    private final AtomicLong _lastUpdate = new AtomicLong(0L);
    private final JCheckBoxMenuItem cbShowDownloadDescription = new JCheckBoxMenuItem("Filmbeschreibung anzeigen");
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private final AGuiTabPanel.MarkFilmAsSeenAction markFilmAsSeenAction = new AGuiTabPanel.MarkFilmAsSeenAction(this);
    private final AGuiTabPanel.MarkFilmAsUnseenAction markFilmAsUnseenAction = new AGuiTabPanel.MarkFilmAsUnseenAction(this);
    private final JXStatusBar statusBar = new JXStatusBar();
    private final DownloadStartInfoProperty startInfoProperty = new DownloadStartInfoProperty();
    private final AboLabel lblAbos = new AboLabel(this.startInfoProperty);
    private final TotalDownloadsLabel totalDownloadsLabel = new TotalDownloadsLabel(this.startInfoProperty);
    private final ManualDownloadsInfoLabel manualDownloadsInfoLabel = new ManualDownloadsInfoLabel(this.startInfoProperty);
    private final WaitingDownloadsInfoLabel waitingDownloadsInfoLabel = new WaitingDownloadsInfoLabel(this.startInfoProperty);
    private final ActiveDownloadsInfoLabel activeDownloadsInfoLabel = new ActiveDownloadsInfoLabel(this.startInfoProperty);
    private final FinishedDownloadsInfoLabel finishedDownloadsInfoLabel = new FinishedDownloadsInfoLabel(this.startInfoProperty);
    private final FailedDownloadsInfoLabel failedDownloadsInfoLabel = new FailedDownloadsInfoLabel(this.startInfoProperty);
    private final DownloadsConfigPanel dlConfigPanel = new DownloadsConfigPanel();
    private final JButton btnClear = new JButton();
    private final JPanel jPanelFilterExtern = new JPanel();
    private final JSplitPane jSplitPane1 = new JSplitPane();
    private boolean onlyAbos;
    private boolean onlyDownloads;
    private boolean onlyWaiting;
    private boolean onlyNotStarted;
    private boolean onlyStarted;
    private boolean onlyFinished;
    private boolean onlyRun;
    private boolean loadFilmlist;
    private TModelDownload model;
    private MVDownloadsTable tabelle;
    private JComboBox<String> cbDisplayCategories;
    private JComboBox<String> cbView;
    private JScrollPane downloadListScrollPane;

    public GuiDownloads(Daten aDaten, MediathekGui mediathekGui) {
        this.daten = aDaten;
        this.mediathekGui = mediathekGui;
        this.descriptionPanel = new FilmDescriptionPanel();
        this.initComponents();
        this.cbDisplayCategories.putClientProperty("JComponent.roundRect", true);
        this.cbView.putClientProperty("JComponent.roundRect", true);
        this.setupDownloadListStatusBar();
        this.setupDownloadListTable();
        this.setupDescriptionTab(this.tabelle, this.cbShowDownloadDescription, "download.show_description", this::getCurrentlySelectedFilm);
        this.init();
        this.setupFilmSelectionPropertyListener();
        this.setupDownloadSizeSelectionUpdater();
        this.initTable();
        this.addListenerMediathekView();
        this.setupDisplayCategories();
        this.setupCheckboxView();
        this.setupFilterPanel();
        if (Taskbar.isTaskbarSupported()) {
            this.setupTaskbarMenu();
        }
        this.tabelle.getTableHeader().setReorderingAllowed(false);
    }

    private void setupDownloadListStatusBar() {
        this.statusBar.add((Component)this.totalDownloadsLabel);
        this.statusBar.add((Component)this.lblAbos);
        this.statusBar.add((Component)this.manualDownloadsInfoLabel);
        this.statusBar.add((Component)this.activeDownloadsInfoLabel);
        this.statusBar.add((Component)this.waitingDownloadsInfoLabel);
        this.statusBar.add((Component)this.finishedDownloadsInfoLabel);
        this.statusBar.add((Component)this.failedDownloadsInfoLabel);
    }

    @Override
    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.writeTableConfigurationData();
        }
    }

    private void updateFilmSizes(int[] rows) {
        boolean updateNeeded = false;
        for (int row : rows) {
            try {
                int indexRow = this.tabelle.convertRowIndexToModel(row);
                ListeDownloads listeDownloads = this.daten.getListeDownloads();
                DatenDownload dlInfo = (DatenDownload)listeDownloads.get(indexRow);
                if (dlInfo != null) {
                    if (dlInfo.mVFilmSize.getSize() != 0L || dlInfo.film == null) continue;
                    long oldSize = dlInfo.mVFilmSize.getSize();
                    dlInfo.queryLiveSize();
                    if (dlInfo.mVFilmSize.getSize() == oldSize) continue;
                    updateNeeded = true;
                    continue;
                }
                logger.error("Could not get download object");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (updateNeeded) {
            this.reloadTable();
        }
    }

    private void setupDownloadSizeSelectionUpdater() {
        this.tabelle.getSelectionModel().addListSelectionListener(l -> {
            if (!l.getValueIsAdjusting()) {
                int[] rows = this.tabelle.getSelectedRows();
                this.updateFilmSizes(rows);
            }
        });
    }

    private void setupFilmSelectionPropertyListener() {
        this.tabelle.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateSelectedListItemsCount(this.tabelle);
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ GuiDownloads this$0;
            {
                GuiDownloads guiDownloads = this$0;
                Objects.requireNonNull(guiDownloads);
                this.this$0 = guiDownloads;
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.this$0.updateSelectedListItemsCount(this.this$0.tabelle);
                this.this$0.onComponentShown();
            }
        });
    }

    private void setupDownloadListTable() {
        this.tabelle = new MVDownloadsTable();
        this.downloadListScrollPane.setViewportView(this.tabelle);
    }

    private void setupDisplayCategories() {
        EventList displaySelectionList = GlazedLists.eventListOf((Object[])new String[]{"alle", COMBO_DISPLAY_DOWNLOADS_ONLY, COMBO_DISPLAY_ABOS_ONLY});
        this.cbDisplayCategories.setModel((ComboBoxModel<String>)GlazedListsSwing.eventComboBoxModelWithThreadProxyList((EventList)displaySelectionList));
        this.cbDisplayCategories.getModel().setSelectedItem("alle");
        this.cbDisplayCategories.addActionListener(new DisplayCategoryListener(this));
    }

    private void setupCheckboxView() {
        EventList viewSelectionList = GlazedLists.eventListOf((Object[])new String[]{"alle", COMBO_VIEW_NOT_STARTED, COMBO_VIEW_STARTED, COMBO_VIEW_WAITING, COMBO_VIEW_RUN_ONLY, COMBO_VIEW_FINISHED_ONLY});
        this.cbView.setModel((ComboBoxModel<String>)GlazedListsSwing.eventComboBoxModelWithThreadProxyList((EventList)viewSelectionList));
        this.cbView.getModel().setSelectedItem("alle");
        this.cbView.addActionListener(new ViewCategoryListener(this));
    }

    private void initTable() {
        this.tabelle.readColumnConfigurationData();
        this.tabelle.setSpalten();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupFilterPanel() {
        boolean visible = MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_FILTER_VIS);
        this.updateFilterVisibility(visible);
        this.setSplitDividerLocation();
        this.jSplitPane1.addPropertyChangeListener("dividerLocation", propertyChangeEvent -> {
            if (this.jPanelFilterExtern.isVisible()) {
                this.config.setProperty("application.ui.download_tab.divider.location", (Object)this.jSplitPane1.getDividerLocation());
            }
        });
    }

    protected void toggleDownloadFilterPanel() {
        boolean visibility = !this.jPanelFilterExtern.isVisible();
        this.updateFilterVisibility(visibility);
        MVConfig.add(MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_FILTER_VIS, Boolean.toString(visibility));
    }

    private void updateFilterVisibility(boolean visible) {
        this.jPanelFilterExtern.setVisible(visible);
        if (visible) {
            this.setSplitDividerLocation();
        }
    }

    private void setSplitDividerLocation() {
        int location = this.config.getInt("application.ui.download_tab.divider.location", -1);
        if (location == -1) {
            this.jSplitPane1.resetToPreferredSizes();
        } else {
            this.jSplitPane1.setDividerLocation(location);
        }
    }

    private void setupTaskbarMenu() {
        Taskbar taskbar = Taskbar.getTaskbar();
        if (taskbar.isSupported(Taskbar.Feature.MENU)) {
            PopupMenu popupMenu = taskbar.getMenu();
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            MenuItem miStartAllDownloads = new MenuItem("Alle Downloads starten");
            miStartAllDownloads.addActionListener(actionEvent -> this.starten(true));
            MenuItem miStopAllDownloads = new MenuItem("Alle Downloads stoppen");
            miStopAllDownloads.addActionListener(actionEvent -> this.stoppen(true));
            popupMenu.add(miStartAllDownloads);
            popupMenu.add(miStopAllDownloads);
            taskbar.setMenu(popupMenu);
        }
    }

    @Override
    public void installMenuEntries(JMenu menu) {
        menu.add(this.startAllDownloadsAction);
        menu.add(this.startAllDownloadsTimedAction);
        menu.add(this.stopAllDownloadsAction);
        menu.add(this.stopAllWaitingDownloadsAction);
        menu.add(this.refreshDownloadListAction);
        menu.add(this.cleanupDownloadListAction);
        menu.addSeparator();
        menu.add(this.startDownloadsAction);
        menu.add(this.stopDownloadsAction);
        menu.add(this.advanceDownloadsAction);
        menu.add(this.deferDownloadsAction);
        menu.add(this.deleteDownloadsAction);
        menu.add(this.editDownloadAction);
        menu.addSeparator();
        menu.add(this.mergeSubtitleWithVideoAction);
        menu.addSeparator();
        menu.add(this.cbShowDownloadDescription);
        menu.addSeparator();
        menu.add(this.markFilmAsSeenAction);
        menu.add(this.markFilmAsUnseenAction);
        menu.add(this.playDownloadAction);
    }

    public void onComponentShown() {
        this.updateFilmData();
    }

    public void starten(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, true, true, false);
    }

    public void stoppen(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, false, true, false);
    }

    private void setupKeyMappings() {
        InputMap im = this.tabelle.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_EDIT_DOWNLOAD);
        im.put(KeyStroke.getKeyStroke(127, 0), ACTION_MAP_KEY_DELETE_DOWNLOAD);
        im.put(KeyStroke.getKeyStroke(71, 0), ACTION_MAP_KEY_MARK_AS_SEEN);
        im.put(KeyStroke.getKeyStroke(85, 0), ACTION_MAP_KEY_MAERK_AS_UNSEEN);
        im.put(KeyStroke.getKeyStroke(68, 0), ACTION_MAP_KEY_START_DOWNLOAD);
        ActionMap am = this.tabelle.getActionMap();
        am.put(ACTION_MAP_KEY_EDIT_DOWNLOAD, new AbstractAction(this){
            final /* synthetic */ GuiDownloads this$0;
            {
                GuiDownloads guiDownloads = this$0;
                Objects.requireNonNull(guiDownloads);
                this.this$0 = guiDownloads;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.editDownload();
            }
        });
        am.put(ACTION_MAP_KEY_DELETE_DOWNLOAD, new AbstractAction(this){
            final /* synthetic */ GuiDownloads this$0;
            {
                GuiDownloads guiDownloads = this$0;
                Objects.requireNonNull(guiDownloads);
                this.this$0 = guiDownloads;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.downloadLoeschen(true);
            }
        });
        am.put(ACTION_MAP_KEY_MARK_AS_SEEN, this.markFilmAsSeenAction);
        am.put(ACTION_MAP_KEY_MAERK_AS_UNSEEN, this.markFilmAsUnseenAction);
        am.put(ACTION_MAP_KEY_START_DOWNLOAD, new AbstractAction(this){
            final /* synthetic */ GuiDownloads this$0;
            {
                GuiDownloads guiDownloads = this$0;
                Objects.requireNonNull(guiDownloads);
                this.this$0 = guiDownloads;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.filmStartenWiederholenStoppen(false, true, true, false);
            }
        });
    }

    private void init() {
        this.setupKeyMappings();
        CellRendererDownloads cellRenderer = new CellRendererDownloads();
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Datum.class, cellRenderer);
        this.tabelle.setDefaultRenderer(MVFilmSize.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
        this.model = new TModelDownload();
        this.tabelle.setModel(this.model);
        this.tabelle.addMouseListener(new BeobMausTabelle(this));
        this.tabelle.getSelectionModel().addListSelectionListener(event -> {
            if (!event.getValueIsAdjusting()) {
                this.updateFilmData();
            }
        });
        this.tabelle.setLineBreak(MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_LINEBREAK));
        this.tabelle.getTableHeader().addMouseListener(new BeobTableHeader(this.tabelle, DatenDownload.spaltenAnzeigen, COLUMNS_DISABLED, new int[]{6, 7}, true, MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_LINEBREAK));
        this.btnClear.addActionListener(actionEvent -> {
            this.cbDisplayCategories.setSelectedIndex(0);
            this.cbView.setSelectedIndex(0);
        });
        this.setSplitDividerLocation();
    }

    @Handler
    private void handleRestartDownloadEvent(RestartDownloadEvent e) {
        this.reloadAndSave();
    }

    @Handler
    private void handleDownloadQueueRankChanged(DownloadQueueRankChangedEvent e) {
        this.reloadAndSave();
    }

    private void reloadAndSave() {
        SwingUtilities.invokeLater(() -> {
            this.reloadTable();
            this.daten.allesSpeichern();
        });
    }

    @Handler
    private void handleAboListChanged(AboListChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN))) {
                this.updateDownloads();
            }
        });
    }

    @Handler
    private void handleDownloadListChange(DownloadListChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.reloadTable();
            this.daten.allesSpeichern();
        });
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN)) && Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO))) {
                this.updateDownloads();
            }
        });
    }

    private void addListenerMediathekView() {
        MessageBus.getMessageBus().subscribe((Object)this);
        Listener.addListener(new Listener(this, 27, GuiDownloads.class.getSimpleName()){
            final /* synthetic */ GuiDownloads this$0;
            {
                GuiDownloads guiDownloads = this$0;
                Objects.requireNonNull(guiDownloads);
                this.this$0 = guiDownloads;
                super(eereignis, kklasse);
            }

            @Override
            public void ping() {
                if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN))) {
                    this.this$0.updateDownloads();
                }
            }
        });
    }

    @Handler
    private void handleDownloadProgressChanged(DownloadProgressChangedEvent e) {
        long now = System.currentTimeMillis();
        if (now - this._lastUpdate.get() >= 500L) {
            this._lastUpdate.set(now);
            SwingUtilities.invokeLater(() -> this.daten.getListeDownloads().setModelProgress(this.model));
        }
    }

    @Handler
    private void handleGeoStateChangedEvent(GeoStateChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelle.fireTableDataChanged(true);
            this.updateStartInfoProperty();
        });
    }

    @Override
    protected void setupShowFilmDescriptionMenuItem() {
        this.cbShowDownloadDescription.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("download.show_description", true));
        this.cbShowDownloadDescription.addActionListener(actionEvent -> {
            boolean visible = this.cbShowDownloadDescription.isSelected();
            this.makeDescriptionTabVisible(visible);
            this.config.setProperty("download.show_description", (Object)visible);
        });
    }

    private synchronized void reloadTable() {
        this.tabelle.getSpalten();
        this.daten.getListeDownloads().getModel(this.model, this.onlyAbos, this.onlyDownloads, this.onlyNotStarted, this.onlyStarted, this.onlyWaiting, this.onlyRun, this.onlyFinished);
        this.tabelle.setSpalten();
        this.updateFilmData();
        this.updateStartInfoProperty();
    }

    @Handler
    private void handleStartEvent(StartEvent msg) {
        SwingUtilities.invokeLater(this::reloadTable);
    }

    public synchronized void updateDownloads() {
        if (this.loadFilmlist) {
            return;
        }
        ListeDownloads listeDownloads = this.daten.getListeDownloads();
        listeDownloads.abosAuffrischen();
        listeDownloads.abosSuchen(this.mediathekGui);
        this.reloadTable();
        if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DOWNLOAD_SOFORT_STARTEN))) {
            this.filmStartenWiederholenStoppen(true, true, false, true);
        }
    }

    public synchronized void cleanupDownloads() {
        this.daten.getListeDownloads().listePutzen();
    }

    private synchronized void downloadsAufraeumen(DatenDownload datenDownload) {
        this.daten.getListeDownloads().listePutzen(datenDownload);
    }

    private ArrayList<DatenDownload> getSelDownloads() {
        ArrayList<DatenDownload> arrayDownloads = new ArrayList<DatenDownload>();
        int[] rows = this.tabelle.getSelectedRows();
        TableModel model = this.tabelle.getModel();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenDownload datenDownload = (DatenDownload)model.getValueAt(this.tabelle.convertRowIndexToModel(row), 39);
                arrayDownloads.add(datenDownload);
            }
        } else {
            NoSelectionErrorDialog.show(this);
        }
        return arrayDownloads;
    }

    @Override
    public Optional<DatenFilm> getCurrentlySelectedFilm() {
        try {
            int selectedTableRow = this.tabelle.getSelectedRow();
            if (selectedTableRow != -1) {
                int modelIndex = this.tabelle.convertRowIndexToModel(selectedTableRow);
                DatenDownload download = (DatenDownload)this.tabelle.getModel().getValueAt(modelIndex, 39);
                Optional<DatenFilm> optRet = download.film == null ? Optional.empty() : Optional.of(download.film);
                return optRet;
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private DatenDownload getSelDownload() {
        DatenDownload datenDownload = null;
        int row = this.tabelle.getSelectedRow();
        if (row != -1) {
            datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 39);
        } else {
            NoSelectionErrorDialog.show(this);
        }
        return datenDownload;
    }

    public synchronized void editDownload() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        boolean gestartet = false;
        if (datenDownload.start != null && datenDownload.start.status >= 2) {
            gestartet = true;
        }
        DatenDownload datenDownloadKopy = datenDownload.getCopy();
        DialogEditDownload dialog = new DialogEditDownload(this.mediathekGui, datenDownloadKopy, gestartet, this.tabelle.getColumnModel());
        dialog.setVisible(true);
        if (dialog.ok) {
            datenDownload.aufMichKopieren(datenDownloadKopy);
            this.reloadTable();
        }
    }

    public void downloadsVorziehen() {
        ArrayList<DatenDownload> arrayDownloads = this.getSelDownloads();
        if (arrayDownloads.isEmpty()) {
            return;
        }
        this.daten.getListeDownloads().downloadsVorziehen(arrayDownloads);
    }

    public void zielordnerOeffnen() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        String s = datenDownload.arr[30];
        DirOpenAction.zielordnerOeffnen(this.mediathekGui, s);
    }

    public void filmAbspielen() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        String s = datenDownload.arr[31];
        OpenPlayerAction.filmAbspielen(this.mediathekGui, s);
    }

    public void filmLoeschen_() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        if (datenDownload.start != null && datenDownload.start.status < 3) {
            MVMessageDialog.showMessageDialog(this.mediathekGui, "Download erst stoppen!", "Film l\u00f6schen", 0);
            return;
        }
        try {
            File file = new File(datenDownload.arr[31]);
            if (!file.exists()) {
                MVMessageDialog.showMessageDialog(this.mediathekGui, "Die Datei existiert nicht!", "Film l\u00f6schen", 0);
                return;
            }
            int ret = JOptionPane.showConfirmDialog(this.mediathekGui, datenDownload.arr[31], "Film L\u00f6schen?", 0);
            if (ret == 0) {
                logger.info((Object)new String[]{"Datei l\u00f6schen: ", file.getAbsolutePath()});
                if (!file.delete()) {
                    throw new Exception();
                }
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.mediathekGui, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            logger.error("Fehler beim l\u00f6schen: {}", (Object)datenDownload.arr[31]);
        }
    }

    public void downloadLoeschen(boolean permanentDeletion) {
        try {
            ArrayList<DatenDownload> arrayDownloads = this.getSelDownloads();
            if (arrayDownloads.isEmpty()) {
                return;
            }
            String zeit = DateTimeFormatter.ofPattern("dd.MM.yyyy").format(LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
            ArrayList<DatenDownload> arrayDownloadsLoeschen = new ArrayList<DatenDownload>();
            ArrayList<MVUsedUrl> urlAboList = new ArrayList<MVUsedUrl>();
            for (DatenDownload datenDownload : arrayDownloads) {
                if (permanentDeletion) {
                    arrayDownloadsLoeschen.add(datenDownload);
                    if (!datenDownload.isFromAbo()) continue;
                    urlAboList.add(new MVUsedUrl(zeit, datenDownload.arr[4], datenDownload.arr[5], datenDownload.arr[20]));
                    continue;
                }
                datenDownload.zurueckstellen();
            }
            if (!urlAboList.isEmpty()) {
                this.daten.getAboHistoryController().add(urlAboList);
            }
            this.daten.getListeDownloads().downloadLoeschen(arrayDownloadsLoeschen);
            this.reloadTable();
        }
        catch (Exception ex) {
            logger.error("downloadLoeschen()", (Throwable)ex);
        }
    }

    @NotNull
    private List<DatenDownload> addAllDownloadsToList() {
        int rowCount = this.tabelle.getRowCount();
        TableModel tableModel = this.tabelle.getModel();
        ArrayList<DatenDownload> destList = new ArrayList<DatenDownload>();
        for (int i = 0; i < rowCount; ++i) {
            DatenDownload datenDownload = (DatenDownload)tableModel.getValueAt(this.tabelle.convertRowIndexToModel(i), 39);
            destList.add(datenDownload);
        }
        return destList;
    }

    public void startAllDownloadsAtSpecificTime() {
        if (this.tabelle.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Es sind keine Downloads in der Liste zum Starten vorhanden.", "MediathekView", 1);
            return;
        }
        this.tabelle.sortDownloadListByTableRows();
        List<DatenDownload> allDownloadsList = this.addAllDownloadsToList();
        ArrayList<DatenDownload> listeUrlsDownloadsAbbrechen = new ArrayList<DatenDownload>();
        ArrayList<DatenDownload> listeDownloadsStarten = new ArrayList<DatenDownload>();
        for (DatenDownload download : allDownloadsList) {
            if (download.start != null) {
                if (download.start.status == 2) continue;
                if (download.start.status > 2) {
                    int reply = GuiFunktionen.createDismissableMessageDialog(this.mediathekGui, "Fertiger Download", "Film nochmal starten?  ==> " + download.arr[5], 0, 1, 10, TimeUnit.SECONDS, 3);
                    if (reply != 0) continue;
                    listeUrlsDownloadsAbbrechen.add(download);
                    if (download.isFromAbo()) {
                        this.daten.getAboHistoryController().removeUrl(download.arr[20]);
                    }
                }
            }
            listeDownloadsStarten.add(download);
        }
        this.daten.getListeDownloads().downloadAbbrechen(listeUrlsDownloadsAbbrechen);
        DialogBeendenZeit dialogBeenden = new DialogBeendenZeit(this.mediathekGui, listeDownloadsStarten);
        dialogBeenden.setVisible(true);
        if (dialogBeenden.applicationCanTerminate()) {
            this.mediathekGui.setShutdownRequested(dialogBeenden.isShutdownRequested());
            this.mediathekGui.quitApplication();
        }
        this.reloadTable();
    }

    private void filmStartenWiederholenStoppen(boolean processAllDownloads, boolean starten, boolean restartFinishedDownloads, boolean skipManualDownloads) {
        List<DatenDownload> selectedDownloadsList;
        ArrayList<DatenDownload> listeDownloadsLoeschen = new ArrayList<DatenDownload>();
        ArrayList<DatenDownload> listeDownloadsStarten = new ArrayList<DatenDownload>();
        if (this.tabelle.getRowCount() == 0) {
            return;
        }
        if (starten && processAllDownloads) {
            this.tabelle.sortDownloadListByTableRows();
        }
        List<DatenDownload> list = selectedDownloadsList = processAllDownloads ? this.addAllDownloadsToList() : this.getSelDownloads();
        if (!starten) {
            this.daten.getStarterClass().delayNewStarts();
        }
        int antwort = -1;
        for (DatenDownload download : selectedDownloadsList) {
            if (starten) {
                if (download.start != null) {
                    if (download.start.status == 2 || !restartFinishedDownloads && download.start.status > 2) continue;
                    if (download.start.status > 2) {
                        if (antwort == -1) {
                            Object text = selectedDownloadsList.size() > 1 ? "Es sind bereits fertige Filme dabei,\ndiese nochmal starten?" : "Film nochmal starten?  ==> " + download.arr[5];
                            antwort = GuiFunktionen.createDismissableMessageDialog(this.mediathekGui, "Fertiger Download", (String)text, 1, 1, 10, TimeUnit.SECONDS, 3);
                        }
                        if (antwort == 2) {
                            return;
                        }
                        if (antwort == 1) continue;
                        listeDownloadsLoeschen.add(download);
                        if (download.isFromAbo()) {
                            this.daten.getAboHistoryController().removeUrl(download.arr[20]);
                        }
                    }
                }
                listeDownloadsStarten.add(download);
                continue;
            }
            if (download.start == null || download.start.status > 2) continue;
            listeDownloadsLoeschen.add(download);
        }
        this.daten.getListeDownloads().downloadAbbrechen(listeDownloadsLoeschen);
        if (skipManualDownloads) {
            listeDownloadsStarten.removeIf(item -> !item.isFromAbo());
        }
        if (starten) {
            DatenDownload.startenDownloads(listeDownloadsStarten);
        }
        this.reloadTable();
    }

    public void stopAllWaitingDownloads() {
        ArrayList<DatenDownload> listeStopDownload = new ArrayList<DatenDownload>();
        for (int i = 0; i < this.tabelle.getRowCount(); ++i) {
            DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(i), 39);
            if (datenDownload.start == null || datenDownload.start.status >= 2) continue;
            listeStopDownload.add(datenDownload);
        }
        this.daten.getListeDownloads().downloadAbbrechen(listeStopDownload);
    }

    private void updateFilmData() {
        if (!this.isShowing()) {
            return;
        }
        FilmInfoDialog infoDialog = this.mediathekGui.getFilmInfoDialog();
        if (infoDialog != null) {
            infoDialog.updateCurrentFilm(this.getCurrentlySelectedFilm().orElse(null));
        }
    }

    @Override
    protected List<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 39);
                if (datenDownload.film == null) continue;
                arrayFilme.add(datenDownload.film);
            }
        } else {
            NoSelectionErrorDialog.show(this);
        }
        return arrayFilme;
    }

    private void initComponents() {
        JPanel panel3 = new JPanel();
        JLabel label1 = new JLabel();
        this.cbDisplayCategories = new JComboBox();
        JLabel label2 = new JLabel();
        this.cbView = new JComboBox();
        JPanel downloadListArea = new JPanel();
        this.downloadListScrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(330);
        this.jPanelFilterExtern.setPreferredSize(new Dimension(200, 644));
        this.jPanelFilterExtern.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3).gridGap("0", "0"), new AC().grow().fill(), new AC().gap().fill().gap().grow().fill()));
        panel3.setBorder(new TitledBorder("Anzeige"));
        panel3.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill(), new AC().fill().gap().fill().gap().fill()));
        label1.setText("Typ:");
        panel3.add((Component)label1, new CC().cell(new int[]{0, 0}));
        panel3.add(this.cbDisplayCategories, new CC().cell(new int[]{1, 0}));
        label2.setText("Status:");
        panel3.add((Component)label2, new CC().cell(new int[]{0, 1}));
        panel3.add(this.cbView, new CC().cell(new int[]{1, 1}));
        this.btnClear.setIcon((Icon)IconUtils.of((Ikon)FontAwesomeSolid.BROOM));
        this.btnClear.setToolTipText("Filter zur\u00fccksetzen");
        panel3.add((Component)this.btnClear, new CC().cell(new int[]{0, 2, 2, 1}).alignX("right").growX(0.0f).width("32:32:32").height("32:32:32"));
        this.jPanelFilterExtern.add((Component)panel3, new CC().cell(new int[]{0, 0}));
        this.jPanelFilterExtern.add((Component)this.dlConfigPanel, new CC().cell(new int[]{0, 1}));
        this.jSplitPane1.setLeftComponent(this.jPanelFilterExtern);
        downloadListArea.setLayout(new BorderLayout());
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BorderLayout());
        tempPanel.add((Component)this.downloadListScrollPane, "Center");
        tempPanel.add((Component)this.statusBar, "South");
        downloadListArea.add((Component)tempPanel, "Center");
        downloadListArea.add((Component)this.descriptionTab, "South");
        this.jSplitPane1.setRightComponent(downloadListArea);
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.swingToolBar, "North");
        this.createSwingToolBar();
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(this){
            final /* synthetic */ GuiDownloads this$0;
            {
                GuiDownloads guiDownloads = this$0;
                Objects.requireNonNull(guiDownloads);
                this.this$0 = guiDownloads;
            }

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                this.this$0.loadFilmlist = true;
                SwingUtilities.invokeLater(() -> this.this$0.refreshDownloadListAction.setEnabled(false));
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                this.this$0.loadFilmlist = false;
                SwingUtilities.invokeLater(() -> this.this$0.refreshDownloadListAction.setEnabled(true));
                this.this$0.daten.getListeDownloads().filmEintragen();
                if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN))) {
                    this.this$0.updateDownloads();
                } else {
                    this.this$0.reloadTable();
                }
            }
        });
    }

    protected void createSwingToolBar() {
        this.swingToolBar.setFloatable(true);
        this.swingToolBar.setName(NAME);
        this.swingToolBar.add(this.refreshDownloadListAction);
        this.swingToolBar.add(this.startAllDownloadsAction);
        this.swingToolBar.add(this.playDownloadAction);
        this.swingToolBar.add(this.deferDownloadsAction);
        this.swingToolBar.add(this.deleteDownloadsAction);
        this.swingToolBar.add(this.cleanupDownloadListAction);
        this.swingToolBar.addSeparator();
        this.swingToolBar.add(this.toggleFilterPanelAction);
    }

    public class ToggleFilterPanelAction
    extends AbstractAction {
        final /* synthetic */ GuiDownloads this$0;

        public ToggleFilterPanelAction(GuiDownloads this$0) {
            GuiDownloads guiDownloads = this$0;
            Objects.requireNonNull(guiDownloads);
            this.this$0 = guiDownloads;
            this.putValue("Name", "Filter anzeigen/ausblenden");
            this.putValue("ShortDescription", "Filter anzeigen/ausblenden");
            this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)FontAwesomeSolid.FILTER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.this$0.toggleDownloadFilterPanel();
        }
    }

    private final class DisplayCategoryListener
    implements ActionListener {
        final /* synthetic */ GuiDownloads this$0;

        private DisplayCategoryListener(GuiDownloads guiDownloads) {
            GuiDownloads guiDownloads2 = guiDownloads;
            Objects.requireNonNull(guiDownloads2);
            this.this$0 = guiDownloads2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox source = (JComboBox)e.getSource();
            switch ((String)source.getModel().getSelectedItem()) {
                case "alle": {
                    this.this$0.onlyAbos = false;
                    this.this$0.onlyDownloads = false;
                    break;
                }
                case "nur Downloads": {
                    this.this$0.onlyAbos = false;
                    this.this$0.onlyDownloads = true;
                    break;
                }
                case "nur Abos": {
                    this.this$0.onlyAbos = true;
                    this.this$0.onlyDownloads = false;
                }
            }
            this.this$0.reloadTable();
        }
    }

    private final class ViewCategoryListener
    implements ActionListener {
        final /* synthetic */ GuiDownloads this$0;

        private ViewCategoryListener(GuiDownloads guiDownloads) {
            GuiDownloads guiDownloads2 = guiDownloads;
            Objects.requireNonNull(guiDownloads2);
            this.this$0 = guiDownloads2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox source = (JComboBox)e.getSource();
            switch ((String)source.getModel().getSelectedItem()) {
                case "alle": {
                    this.this$0.onlyNotStarted = false;
                    this.this$0.onlyStarted = false;
                    this.this$0.onlyWaiting = false;
                    this.this$0.onlyFinished = false;
                    this.this$0.onlyRun = false;
                    break;
                }
                case "nicht gestartet": {
                    this.this$0.onlyNotStarted = true;
                    this.this$0.onlyStarted = false;
                    this.this$0.onlyWaiting = false;
                    this.this$0.onlyFinished = false;
                    this.this$0.onlyRun = false;
                    break;
                }
                case "gestartet": {
                    this.this$0.onlyNotStarted = false;
                    this.this$0.onlyStarted = true;
                    this.this$0.onlyWaiting = false;
                    this.this$0.onlyFinished = false;
                    this.this$0.onlyRun = false;
                    break;
                }
                case "nur wartende": {
                    this.this$0.onlyNotStarted = false;
                    this.this$0.onlyStarted = false;
                    this.this$0.onlyWaiting = true;
                    this.this$0.onlyFinished = false;
                    this.this$0.onlyRun = false;
                    break;
                }
                case "nur abgeschlossene": {
                    this.this$0.onlyNotStarted = false;
                    this.this$0.onlyStarted = false;
                    this.this$0.onlyWaiting = false;
                    this.this$0.onlyFinished = true;
                    this.this$0.onlyRun = false;
                    break;
                }
                case "nur laufende": {
                    this.this$0.onlyNotStarted = false;
                    this.this$0.onlyStarted = false;
                    this.this$0.onlyWaiting = false;
                    this.this$0.onlyFinished = false;
                    this.this$0.onlyRun = true;
                }
            }
            this.this$0.reloadTable();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private DatenDownload datenDownload;
        private Point p;
        final /* synthetic */ GuiDownloads this$0;

        public BeobMausTabelle(GuiDownloads this$0) {
            GuiDownloads guiDownloads = this$0;
            Objects.requireNonNull(guiDownloads);
            this.this$0 = guiDownloads;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = this.this$0.tabelle.rowAtPoint(this.p);
                    int column = this.this$0.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1) {
                    this.this$0.editDownload();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            this.p = arg0.getPoint();
            int row = this.this$0.tabelle.rowAtPoint(this.p);
            if (row >= 0) {
                this.datenDownload = (DatenDownload)this.this$0.tabelle.getModel().getValueAt(this.this$0.tabelle.convertRowIndexToModel(row), 39);
            }
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            this.p = arg0.getPoint();
            int row = this.this$0.tabelle.rowAtPoint(this.p);
            if (row >= 0) {
                this.datenDownload = (DatenDownload)this.this$0.tabelle.getModel().getValueAt(this.this$0.tabelle.convertRowIndexToModel(row), 39);
            }
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                this.datenDownload = (DatenDownload)this.this$0.tabelle.getModel().getValueAt(this.this$0.tabelle.convertRowIndexToModel(row), 39);
                if (this.this$0.tabelle.convertColumnIndexToModel(column) == 6) {
                    if (this.datenDownload.start != null && !this.datenDownload.isDownloadManager()) {
                        if (this.datenDownload.start.status == 3) {
                            this.this$0.filmAbspielen();
                        } else {
                            this.this$0.filmStartenWiederholenStoppen(false, this.datenDownload.start.status == 4, true, false);
                        }
                    } else {
                        this.this$0.filmStartenWiederholenStoppen(false, true, true, false);
                    }
                } else if (this.this$0.tabelle.convertColumnIndexToModel(column) == 7) {
                    if (this.datenDownload.start != null) {
                        if (this.datenDownload.start.status >= 3) {
                            this.this$0.downloadsAufraeumen(this.datenDownload);
                        } else {
                            this.this$0.downloadLoeschen(true);
                        }
                    } else {
                        this.this$0.downloadLoeschen(true);
                    }
                }
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = this.this$0.tabelle.rowAtPoint(this.p);
            if (nr != -1) {
                this.this$0.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            boolean wartenOderLaufen = false;
            int row = this.this$0.tabelle.getSelectedRow();
            if (row != -1) {
                DatenDownload download = (DatenDownload)this.this$0.tabelle.getModel().getValueAt(this.this$0.tabelle.convertRowIndexToModel(row), 39);
                if (download.start != null && download.start.status <= 2) {
                    wartenOderLaufen = true;
                }
            }
            JMenuItem itemStarten = new JMenuItem("Download starten");
            itemStarten.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/caret-down.svg"));
            itemStarten.setEnabled(!wartenOderLaufen);
            jPopupMenu.add(itemStarten);
            itemStarten.addActionListener(actionEvent -> this.this$0.filmStartenWiederholenStoppen(false, true, true, false));
            JMenuItem itemStoppen = new JMenuItem("Download stoppen");
            itemStoppen.setEnabled(wartenOderLaufen);
            jPopupMenu.add(itemStoppen);
            itemStoppen.addActionListener(actionEvent -> this.this$0.filmStartenWiederholenStoppen(false, false, true, false));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.this$0.advanceDownloadsAction);
            jPopupMenu.add(this.this$0.deferDownloadsAction);
            jPopupMenu.add(this.this$0.deleteDownloadsAction);
            jPopupMenu.add(this.this$0.editDownloadAction);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.this$0.startAllDownloadsAction);
            jPopupMenu.add(this.this$0.stopAllDownloadsAction);
            JMenuItem itemWartendeStoppen = new JMenuItem("wartende Downloads stoppen");
            jPopupMenu.add(itemWartendeStoppen);
            itemWartendeStoppen.addActionListener(actionEvent -> this.this$0.stopAllWaitingDownloads());
            jPopupMenu.add(this.this$0.refreshDownloadListAction);
            jPopupMenu.add(this.this$0.cleanupDownloadListAction);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.this$0.playDownloadAction);
            jPopupMenu.add(this.this$0.deleteDownloadAction);
            jPopupMenu.add(this.this$0.openTargetFolderAction);
            jPopupMenu.addSeparator();
            JMenu submenueAbo = new JMenu("Abo");
            JMenuItem itemChangeAbo = new JMenuItem("Abo \u00e4ndern");
            JMenuItem itemDelAbo = new JMenuItem("Abo l\u00f6schen");
            if (this.datenDownload == null) {
                submenueAbo.setEnabled(false);
                itemChangeAbo.setEnabled(false);
                itemDelAbo.setEnabled(false);
            } else if (this.datenDownload.film == null) {
                submenueAbo.setEnabled(false);
                itemChangeAbo.setEnabled(false);
                itemDelAbo.setEnabled(false);
            } else {
                DatenAbo datenAbo = this.this$0.daten.getListeAbo().getAboFuerFilm_schnell(this.datenDownload.film, false);
                if (datenAbo == null) {
                    submenueAbo.setEnabled(false);
                    itemChangeAbo.setEnabled(false);
                    itemDelAbo.setEnabled(false);
                } else {
                    itemDelAbo.addActionListener(actionEvent -> this.this$0.daten.getListeAbo().aboLoeschen(datenAbo));
                    itemChangeAbo.addActionListener(actionEvent -> {
                        DialogEditAbo dialog = new DialogEditAbo(this.this$0.mediathekGui, datenAbo, false);
                        dialog.setVisible(true);
                        if (dialog.successful()) {
                            this.this$0.daten.getListeAbo().aenderungMelden();
                        }
                    });
                }
            }
            submenueAbo.add(itemDelAbo);
            submenueAbo.add(itemChangeAbo);
            jPopupMenu.add(submenueAbo);
            jPopupMenu.addSeparator();
            JMenuItem itemPlayer = new JMenuItem("Film (URL) abspielen");
            itemPlayer.setIcon((Icon)IconUtils.of((Ikon)FontAwesomeSolid.PLAY_CIRCLE));
            itemPlayer.addActionListener(actionEvent -> {
                int nr1 = this.this$0.tabelle.rowAtPoint(this.p);
                if (nr1 != -1) {
                    Optional<DatenPset> optPSetPlay = Optional.ofNullable(Daten.listePset.getPsetAbspielen());
                    optPSetPlay.ifPresentOrElse(gruppe -> {
                        Optional<DatenDownload> optDL = Optional.ofNullable((DatenDownload)this.this$0.tabelle.getModel().getValueAt(this.this$0.tabelle.convertRowIndexToModel(nr1), 39));
                        optDL.ifPresent(dl -> {
                            if (dl.film != null) {
                                DatenFilm filmClone = new DatenFilm(dl.film);
                                filmClone.setNormalQualityUrl(dl.arr[21]);
                                filmClone.setLowQualityUrl("");
                                this.this$0.daten.getStarterClass().urlMitProgrammStarten((DatenPset)gruppe, filmClone, "");
                            }
                        });
                    }, () -> {
                        String menuPath = SystemUtils.IS_OS_MAC_OSX ? "MediathekView->Einstellungen\u2026->Aufzeichnen und Abspielen->Set bearbeiten" : "Datei->Einstellungen->Set bearbeiten";
                        JOptionPane.showMessageDialog(this.this$0.mediathekGui, "Bitte legen Sie im Men\u00fc \"" + menuPath + "\" ein Programm zum Abspielen fest.", "Kein Videoplayer!", 1);
                    });
                }
            });
            jPopupMenu.add(itemPlayer);
            JMenuItem itemUrl = new JMenuItem("URL kopieren");
            itemUrl.addActionListener(actionEvent -> {
                int nr1 = this.this$0.tabelle.rowAtPoint(this.p);
                if (nr1 != -1) {
                    GuiFunktionen.copyToClipboard(this.this$0.tabelle.getModel().getValueAt(this.this$0.tabelle.convertRowIndexToModel(nr1), 21).toString());
                }
            });
            jPopupMenu.add(itemUrl);
            jPopupMenu.add(((GuiDownloads)this.this$0).mediathekGui.showFilmInformationAction);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

