/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Cursor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.dialogEinstellungen.DialogImportPset;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.NetUtils;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GuiFunktionenProgramme {
    private static final ArrayList<String> winPfade = new ArrayList();
    private static final Logger logger = LogManager.getLogger();
    private static final String PFAD_LINUX_VLC = "/usr/bin/vlc";
    private static final String PFAD_MAC_VLC = "/Applications/VLC.app/Contents/MacOS/VLC";
    private static final String PFAD_WIN = "\\VideoLAN\\VLC\\vlc.exe";
    private static final String ENV_WINDOWS_PATH_VLC = "PATH_VLC";
    private static final String PFAD_LINUX_FFMPEG = "/usr/bin/ffmpeg";
    private static final String PFAD_MAC_FFMPEG = "bin/ffmpeg";
    private static final String PFAD_WINDOWS_FFMPEG = "bin\\ffmpeg.exe";

    private static void setWinProgPfade() {
        String[] PFAD;
        String pfad;
        if (System.getenv("ProgramFiles") != null && new File(pfad = System.getenv("ProgramFiles")).exists() && !winPfade.contains(pfad)) {
            winPfade.add(pfad);
        }
        if (System.getenv("ProgramFiles(x86)") != null && new File(pfad = System.getenv("ProgramFiles(x86)")).exists() && !winPfade.contains(pfad)) {
            winPfade.add(pfad);
        }
        for (String s : PFAD = new String[]{"C:\\Program Files", "C:\\Programme", "C:\\Program Files (x86)"}) {
            if (!new File(s).exists() || winPfade.contains(s)) continue;
            winPfade.add(s);
        }
    }

    public static String getPathToApplicationJar() {
        Object s;
        String pFilePath = "pFile";
        File propFile = new File("pFile");
        if (!propFile.exists()) {
            try {
                CodeSource cS = GuiFunktionenProgramme.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(cS.getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                propFile = new File(jarDir + File.separator + "pFile");
            }
            catch (Exception cS) {
                // empty catch block
            }
        }
        if (!((String)(s = StringUtils.replace((String)propFile.getAbsolutePath(), (String)"pFile", (String)""))).endsWith(File.separator)) {
            s = (String)s + File.separator;
        }
        return s;
    }

    public static String getMusterPfadVlc() {
        Object pfad = "";
        try {
            if (SystemUtils.IS_OS_LINUX) {
                pfad = PFAD_LINUX_VLC;
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                pfad = PFAD_MAC_VLC;
            } else {
                String s;
                GuiFunktionenProgramme.setWinProgPfade();
                Iterator<String> iterator = winPfade.iterator();
                while (iterator.hasNext() && !new File((String)(pfad = (s = iterator.next()) + PFAD_WIN)).exists()) {
                }
            }
            if (!new File((String)pfad).exists() && System.getenv(ENV_WINDOWS_PATH_VLC) != null) {
                pfad = System.getenv(ENV_WINDOWS_PATH_VLC);
            }
            if (!new File((String)pfad).exists()) {
                pfad = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pfad;
    }

    public static String getMusterPfadFFmpeg() {
        String pfad = "";
        try {
            pfad = SystemUtils.IS_OS_LINUX ? PFAD_LINUX_FFMPEG : (SystemUtils.IS_OS_MAC_OSX ? PFAD_MAC_FFMPEG : PFAD_WINDOWS_FFMPEG);
            if (!new File(pfad).exists() && System.getenv("PATH_FFMPEG") != null) {
                pfad = System.getenv("PATH_FFMPEG");
            }
            if (!new File(pfad).exists()) {
                pfad = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pfad;
    }

    public static void addSetVorlagen(JFrame parent, Daten daten, ListePset pSet, boolean setVersion) {
        if (pSet == null) {
            MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            return;
        }
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        for (DatenPset ps : pSet) {
            if (ps.arr[16].isEmpty() || GuiFunktionenProgramme.addOnZip(ps.arr[16])) continue;
            MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            return;
        }
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        DialogImportPset dialog = new DialogImportPset(parent, true, daten, pSet);
        dialog.setVisible(true);
        if (dialog.ok) {
            if (Daten.listePset.addPset(pSet)) {
                if (setVersion) {
                    MVConfig.add(MVConfig.Configs.SYSTEM_VERSION_PROGRAMMSET, pSet.version);
                }
                MVMessageDialog.showMessageDialog(null, pSet.size() + " Programmset importiert!", "Ok", 1);
            } else {
                MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            }
        }
    }

    public static Path getBinaryPath() {
        return Paths.get(GuiFunktionenProgramme.getPathToApplicationJar(), new String[0]).resolve("bin");
    }

    public static Path getResBinaryPath() {
        return Paths.get(GuiFunktionenProgramme.getPathToApplicationJar(), new String[0]).resolve("res").resolve("bin");
    }

    public static Path findExecutableOnPath(String name) {
        String vlcExtPathEnv;
        Object exeString = name;
        Object path = System.getenv("PATH");
        path = (String)path + File.pathSeparatorChar + String.valueOf(GuiFunktionenProgramme.getBinaryPath().toAbsolutePath());
        if (SystemUtils.IS_OS_WINDOWS) {
            exeString = (String)exeString + ".exe";
            path = (String)path + File.pathSeparatorChar + "C:\\Program Files\\VideoLAN\\VLC";
            path = (String)path + File.pathSeparatorChar + String.valueOf(GuiFunktionenProgramme.getResBinaryPath().toAbsolutePath());
        }
        if ((SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_WINDOWS) && (vlcExtPathEnv = System.getenv(ENV_WINDOWS_PATH_VLC)) != null) {
            path = (String)path + File.pathSeparatorChar + vlcExtPathEnv;
        }
        for (String dirname : ((String)path).split(File.pathSeparator)) {
            File file = new File(dirname, (String)exeString);
            if (!file.isFile()) continue;
            return file.toPath();
        }
        throw new IllegalStateException(String.format("Should have found the executable %s", exeString));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addOnZip(String datei) {
        String zielPfad = GuiFunktionen.addsPfad(GuiFunktionenProgramme.getPathToApplicationJar(), "bin");
        try {
            if (!NetUtils.isUrl(datei)) {
                File zipFile = new File(datei);
                if (!zipFile.exists()) {
                    return false;
                }
                if (datei.endsWith(".zip")) {
                    if (GuiFunktionenProgramme.entpacken(zipFile, new File(zielPfad))) return true;
                    return false;
                }
                try (FileInputStream in = new FileInputStream(datei);
                     FileOutputStream fOut = new FileOutputStream(GuiFunktionen.addsPfad(zielPfad, datei));){
                    int n;
                    byte[] buffer = new byte[65536];
                    while ((n = in.read(buffer)) != -1) {
                        fOut.write(buffer, 0, n);
                    }
                    return true;
                }
            }
            Request request = new Request.Builder().url(datei).get().header("User-Agent", ApplicationConfiguration.getConfiguration().getString("application.user_agent")).get().build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (!response.isSuccessful()) return true;
                try (InputStream is = body.byteStream();
                     BufferedInputStream bis = new BufferedInputStream(is);){
                    byte[] buffer = new byte[65536];
                    if (datei.endsWith(".zip")) {
                        File tmpFile = File.createTempFile("mediathek", null);
                        tmpFile.deleteOnExit();
                        try (FileOutputStream fOut2 = new FileOutputStream(tmpFile);){
                            int n;
                            while ((n = bis.read(buffer)) != -1) {
                                fOut2.write(buffer, 0, n);
                            }
                        }
                        if (GuiFunktionenProgramme.entpacken(tmpFile, new File(zielPfad))) return true;
                        boolean fOut2 = false;
                        return fOut2;
                    }
                    String file = GuiFunktionen.getDateiName(datei);
                    File f = new File(GuiFunktionen.addsPfad(zielPfad, file));
                    try (FileOutputStream fOut = new FileOutputStream(f);){
                        int n;
                        while ((n = bis.read(buffer)) != -1) {
                            fOut.write(buffer, 0, n);
                        }
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean entpacken(File archive, File destDir) throws Exception {
        if (!destDir.exists()) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[16384];
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryFileName = entry.getName();
                File dir = GuiFunktionenProgramme.buildDirectoryHierarchyFor(entryFileName, destDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (entry.isDirectory()) continue;
                try (FileOutputStream fos = new FileOutputStream(new File(destDir, entryFileName));
                     BufferedOutputStream bos = new BufferedOutputStream(fos);
                     BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));){
                    int len;
                    while ((len = bis.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    bos.flush();
                }
            }
        }
        return true;
    }

    private static File buildDirectoryHierarchyFor(String entryName, File destDir) {
        int lastIndex = entryName.lastIndexOf(47);
        String internalPathToEntry = entryName.substring(0, lastIndex + 1);
        return new File(destDir, internalPathToEntry);
    }

    public static boolean checkPrefix(@NotNull String prefixes, @NotNull String url) {
        if (prefixes.isEmpty()) {
            return true;
        }
        String lowerUrl = url.toLowerCase();
        String lowerPrefixes = prefixes.toLowerCase();
        int prefixesLen = lowerPrefixes.length();
        int tokenStart = 0;
        for (int i = 0; i <= prefixesLen; ++i) {
            int tokenLen;
            if (i != prefixesLen && lowerPrefixes.charAt(i) != ',') continue;
            if (i > tokenStart && (tokenLen = i - tokenStart) <= lowerUrl.length() && lowerUrl.regionMatches(0, lowerPrefixes, tokenStart, tokenLen)) {
                return true;
            }
            tokenStart = i + 1;
        }
        return false;
    }

    public static boolean checkSuffix(@NotNull String suffixes, @NotNull String url) {
        if (suffixes.isEmpty()) {
            return true;
        }
        String lowerUrl = url.toLowerCase();
        String lowerSuffixes = suffixes.toLowerCase();
        int urlLen = lowerUrl.length();
        int suffixesLen = lowerSuffixes.length();
        int tokenStart = 0;
        for (int i = 0; i <= suffixesLen; ++i) {
            int urlStart;
            if (i != suffixesLen && lowerSuffixes.charAt(i) != ',') continue;
            int tokenLen = i - tokenStart;
            if (tokenLen > 0 && tokenLen <= urlLen && lowerUrl.regionMatches(urlStart = urlLen - tokenLen, lowerSuffixes, tokenStart, tokenLen)) {
                return true;
            }
            tokenStart = i + 1;
        }
        return false;
    }

    public static boolean checkPathWriteable(@NotNull String path) {
        boolean ret = false;
        if (path.isEmpty()) {
            return false;
        }
        File testFile = new File(path);
        try {
            if (!testFile.exists()) {
                testFile.mkdirs();
            }
            if (testFile.isDirectory() && testFile.canWrite()) {
                File tmpFile = File.createTempFile("mediathek", "tmp", testFile);
                ret = tmpFile.delete();
            }
        }
        catch (Exception e) {
            logger.error("checkPathWriteable()", (Throwable)e);
        }
        return ret;
    }
}

