/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.shadow.com.formdev.flatlaf.icons;

import com.install4j.shadow.com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.install4j.shadow.com.formdev.flatlaf.ui.FlatButtonUI;
import com.install4j.shadow.com.formdev.flatlaf.ui.FlatUIUtils;
import com.install4j.shadow.com.formdev.flatlaf.util.HiDPIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public abstract class FlatWindowAbstractIcon
extends FlatAbstractIcon {
    private final int symbolHeight;
    private final Color hoverBackground;
    private final Color pressedBackground;

    protected FlatWindowAbstractIcon(String windowStyle) {
        this(FlatUIUtils.getSubUIDimension("TitlePane.buttonSize", windowStyle), FlatUIUtils.getSubUIInt("TitlePane.buttonSymbolHeight", windowStyle, 10), FlatUIUtils.getSubUIColor("TitlePane.buttonHoverBackground", windowStyle), FlatUIUtils.getSubUIColor("TitlePane.buttonPressedBackground", windowStyle));
    }

    protected FlatWindowAbstractIcon(Dimension size, int symbolHeight, Color hoverBackground, Color pressedBackground) {
        super(size.width, size.height, null);
        this.symbolHeight = symbolHeight;
        this.hoverBackground = hoverBackground;
        this.pressedBackground = pressedBackground;
    }

    @Override
    protected void paintIcon(Component c, Graphics2D g) {
        g.setColor(this.getForeground(c));
        HiDPIUtils.paintAtScale1x(g, 0, 0, this.width, this.height, this::paintIconAt1x);
    }

    protected abstract void paintIconAt1x(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);

    @Override
    protected void paintBackground(Component c, Graphics2D g, int x, int y) {
        Color background = FlatButtonUI.buttonStateColor(c, null, null, null, this.hoverBackground, this.pressedBackground);
        if (background != null) {
            Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setColor(FlatUIUtils.deriveColor(background, c.getBackground()));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        }
    }

    protected Color getForeground(Component c) {
        return c.getForeground();
    }

    protected int getSymbolHeight() {
        return this.symbolHeight;
    }
}

