/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_livestreams;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.tabs.tab_livestreams.LivestreamEntry;
import mediathek.gui.tabs.tab_livestreams.LivestreamListModel;
import mediathek.gui.tabs.tab_livestreams.LivestreamPanel;
import mediathek.gui.tabs.tab_livestreams.LivestreamRenderer;
import mediathek.gui.tabs.tab_livestreams.SenderUtils;
import mediathek.gui.tabs.tab_livestreams.services.ShowInfo;
import mediathek.gui.tabs.tab_livestreams.services.ShowService;
import mediathek.gui.tabs.tab_livestreams.services.ShowsResponse;
import mediathek.gui.tabs.tab_livestreams.services.StreamInfo;
import mediathek.gui.tabs.tab_livestreams.services.StreamService;
import mediathek.mac.MacMultimediaPlayerLocator;
import mediathek.mac.SingleIinaPlayer;
import mediathek.mainwindow.MediathekGui;
import mediathek.swing.OverlayPanel;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.http.MVHttpClient;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lmediathek/gui/tabs/tab_livestreams/LivestreamPanel;", "Ljavax/swing/JPanel;", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "()V", "listModel", "Lmediathek/gui/tabs/tab_livestreams/LivestreamListModel;", "list", "Ljavax/swing/JList;", "Lmediathek/gui/tabs/tab_livestreams/LivestreamEntry;", "kotlin.jvm.PlatformType", "streamService", "Lmediathek/gui/tabs/tab_livestreams/services/StreamService;", "showService", "Lmediathek/gui/tabs/tab_livestreams/services/ShowService;", "refreshTimer", "Ljavax/swing/Timer;", "overlay", "Lmediathek/swing/OverlayPanel;", "iinaPlayer", "Lmediathek/mac/SingleIinaPlayer;", "setupList", "", "loadLivestreams", "loadAllShows", "loadShowDetailsForEntry", "entry", "index", "", "checkForExpiredShows", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Companion", "MediathekView"})
public final class LivestreamPanel
extends JPanel
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ CoroutineScope $$delegate_0;
    @NotNull
    private final LivestreamListModel listModel = new LivestreamListModel();
    @NotNull
    private final JList<LivestreamEntry> list = new JList(this.listModel);
    @NotNull
    private final StreamService streamService;
    @NotNull
    private final ShowService showService;
    @NotNull
    private final Timer refreshTimer = new Timer((int)TimeUnit.MILLISECONDS.convert(4L, TimeUnit.SECONDS), arg_0 -> LivestreamPanel.refreshTimer$lambda$0(this, arg_0));
    @NotNull
    private final OverlayPanel overlay = new OverlayPanel("Livestreams konnten nicht geladen werden");
    @NotNull
    private SingleIinaPlayer iinaPlayer;
    @NotNull
    private static final Logger LOG;

    public LivestreamPanel() {
        super(new BorderLayout());
        JLayeredPane jLayeredPane;
        this.$$delegate_0 = CoroutineScopeKt.MainScope();
        JLayeredPane $this$_init__u24lambda_u240 = jLayeredPane = new JLayeredPane();
        boolean bl = false;
        $this$_init__u24lambda_u240.setLayout(new OverlayLayout($this$_init__u24lambda_u240));
        $this$_init__u24lambda_u240.add(this.overlay);
        $this$_init__u24lambda_u240.add(new JScrollPane(this.list));
        JLayeredPane container = jLayeredPane;
        this.add((Component)container, "Center");
        this.overlay.setVisible(false);
        this.setupList();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (listModel.getSize() == 0) {
                    SwingUtilities.invokeLater(() -> 1.componentShown$lambda$0(this));
                }
            }

            private static final void componentShown$lambda$0(LivestreamPanel this$0) {
                this$0.loadLivestreams();
            }
        });
        JLayeredPane $this$_init__u24lambda_u241 = $this$_init__u24lambda_u240 = new ObjectMapper();
        boolean bl2 = false;
        $this$_init__u24lambda_u241.registerModule((Module)new JavaTimeModule());
        $this$_init__u24lambda_u241.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        JLayeredPane mapper = $this$_init__u24lambda_u240;
        OkHttpClient client = MVHttpClient.getInstance().getHttpClient();
        Object object = new Retrofit.Builder().baseUrl("https://api.zapp.mediathekview.de/").addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).client(client).build().create(StreamService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.streamService = (StreamService)object;
        Object object2 = new Retrofit.Builder().baseUrl("https://api.zapp.mediathekview.de/").addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).client(client).build().create(ShowService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(...)");
        this.showService = (ShowService)object2;
        this.refreshTimer.start();
        this.iinaPlayer = new SingleIinaPlayer();
    }

    private final void setupList() {
        this.list.setCellRenderer(new LivestreamRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ LivestreamPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    LivestreamEntry livestreamEntry = (LivestreamEntry)LivestreamPanel.access$getList$p(this.this$0).getSelectedValue();
                    if (livestreamEntry == null) {
                        return;
                    }
                    LivestreamEntry selected = livestreamEntry;
                    if (!SystemUtils.IS_OS_MAC_OSX) {
                        try {
                            Path vlcPath = GuiFunktionenProgramme.findExecutableOnPath("vlc");
                            String[] stringArray = new String[]{((Object)vlcPath.toAbsolutePath()).toString(), selected.getStreamUrl()};
                            ProcessBuilder pb = new ProcessBuilder(stringArray);
                            Process process = pb.start();
                        }
                        catch (IllegalStateException illegalStateException) {
                            JOptionPane.showMessageDialog(MediathekGui.ui(), "<html>Es konnte kein VLC auf dem System gefunden werden.<br/>Es wird versucht, den Stream \u00fcber den Browser zu \u00f6ffnen.</html>");
                            UrlHyperlinkAction.openURL(selected.getStreamUrl());
                            Unit unit = Unit.INSTANCE;
                        }
                    } else {
                        MacMultimediaPlayerLocator.findIinaPlayer().ifPresentOrElse(arg_0 -> setupList.1.mouseClicked$lambda$1(arg_0 -> setupList.1.mouseClicked$lambda$0(this.this$0, selected, arg_0), arg_0), () -> setupList.1.mouseClicked$lambda$2(selected));
                    }
                }
            }

            private static final Unit mouseClicked$lambda$2$0(LivestreamEntry $selected, Path it) {
                String[] stringArray = new String[]{"open", "-a", "VLC", $selected.getStreamUrl()};
                new ProcessBuilder(stringArray).start();
                return Unit.INSTANCE;
            }

            private static final void mouseClicked$lambda$2$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void mouseClicked$lambda$2$2(LivestreamEntry $selected) {
                Desktop.getDesktop().browse(new URI($selected.getStreamUrl()));
            }

            private static final Unit mouseClicked$lambda$0(LivestreamPanel this$0, LivestreamEntry $selected, Path it) {
                LivestreamPanel.access$getIinaPlayer$p(this$0).play($selected.getStreamUrl());
                return Unit.INSTANCE;
            }

            private static final void mouseClicked$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void mouseClicked$lambda$2(LivestreamEntry $selected) {
                MacMultimediaPlayerLocator.findVlcPlayer().ifPresentOrElse(arg_0 -> setupList.1.mouseClicked$lambda$2$1(arg_0 -> setupList.1.mouseClicked$lambda$2$0($selected, arg_0), arg_0), () -> setupList.1.mouseClicked$lambda$2$2($selected));
            }
        });
        this.list.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ LivestreamPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                LivestreamPanel.access$getOverlay$p(this.this$0).setSize(LivestreamPanel.access$getList$p(this.this$0).getWidth(), LivestreamPanel.access$getList$p(this.this$0).getHeight());
            }
        });
        this.list.setToolTipText("");
        this.list.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ LivestreamPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int index = LivestreamPanel.access$getList$p(this.this$0).locationToIndex(e.getPoint());
                if (index < 0) {
                    LivestreamPanel.access$getList$p(this.this$0).setToolTipText(null);
                    return;
                }
                Rectangle bounds = LivestreamPanel.access$getList$p(this.this$0).getCellBounds(index, index);
                if (bounds == null || !bounds.contains(e.getPoint())) {
                    LivestreamPanel.access$getList$p(this.this$0).setToolTipText(null);
                    return;
                }
                LivestreamEntry entry = (LivestreamEntry)LivestreamPanel.access$getList$p(this.this$0).getModel().getElementAt(index);
                int iconX = bounds.x + 2;
                int iconSize = 64;
                int iconY = bounds.y + (bounds.height - iconSize) / 2;
                Rectangle iconArea = new Rectangle(iconX, iconY, iconSize, iconSize);
                if (iconArea.contains(e.getPoint())) {
                    LivestreamPanel.access$getList$p(this.this$0).setToolTipText(SenderUtils.Companion.sanitizeName(entry.getStreamName()));
                } else {
                    LivestreamPanel.access$getList$p(this.this$0).setToolTipText(null);
                }
            }
        });
    }

    private final void loadLivestreams() {
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ LivestreamPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = LivestreamPanel.access$getStreamService$p(this.this$0).getStreams((Continuation<? super Map<String, StreamInfo>>)((Continuation)this));
                        ** if (v0 != var16_2) goto lbl11
lbl10:
                        // 1 sources

                        return var16_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        $this$map$iv = streams = (Map)v0;
                        $i$f$map = false;
                        var6_9 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        $i$f$mapTo = false;
                        var9_12 = $this$mapTo$iv$iv.entrySet().iterator();
                        while (var9_12.hasNext()) {
                            var11_14 = item$iv$iv = var9_12.next();
                            var15_18 = destination$iv$iv;
                            $i$a$-map-LivestreamPanel$loadLivestreams$1$entries$1 = false;
                            key = (String)var11_14.getKey();
                            info = (StreamInfo)var11_14.getValue();
                            var15_18.add(new LivestreamEntry(key, info.getName(), info.getStreamUrl(), null, 8, null));
                        }
                        v1 = (List)destination$iv$iv;
                        v2 = GermanStringSorter.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        var4_7 = v2;
                        entries = CollectionsKt.sortedWith((Iterable)v1, (Comparator)new Comparator(var4_7){
                            final /* synthetic */ Comparator $comparator;
                            {
                                this.$comparator = $comparator;
                            }

                            public final int compare(T a, T b) {
                                LivestreamEntry livestreamEntry = (LivestreamEntry)a;
                                Comparator comparator = this.$comparator;
                                boolean bl = false;
                                LivestreamEntry it = (LivestreamEntry)b;
                                String string = it.getStreamName();
                                bl = false;
                                String string2 = it.getStreamName();
                                return comparator.compare(string, string2);
                            }
                        });
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)streams);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)entries);
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<LivestreamEntry>)entries, this.this$0, null){
                            int label;
                            final /* synthetic */ List<LivestreamEntry> $entries;
                            final /* synthetic */ LivestreamPanel this$0;
                            {
                                this.$entries = $entries;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (this.$entries.isEmpty()) {
                                            LivestreamPanel.access$getOverlay$p(this.this$0).setVisible(true);
                                        } else {
                                            LivestreamPanel.access$getOverlay$p(this.this$0).setVisible(false);
                                            LivestreamPanel.access$getListModel$p(this.this$0).setData(this.$entries);
                                            LivestreamPanel.access$loadAllShows(this.this$0);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v3 != var16_2) goto lbl43
lbl42:
                        // 1 sources

                        return var16_2;
lbl43:
                        // 1 sources

                        ** GOTO lbl65
                    }
                    case 2: {
                        entries = (List)this.L$1;
                        streams = (Map)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** GOTO lbl65
                        }
                        catch (Exception ex) {
                            LivestreamPanel.access$getLOG$cp().error("Failed to load livestreams", (Throwable)ex);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ex);
                            this.L$1 = null;
                            this.label = 3;
                            v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ LivestreamPanel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            LivestreamPanel.access$getOverlay$p(this.this$0).setVisible(true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v4 == var16_2) {
                                return var16_2;
                            }
                            ** GOTO lbl65
                        }
                    }
                    case 3: {
                        ex = (Exception)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl65:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void loadAllShows() {
        int n = this.listModel.getSize();
        for (int i = 0; i < n; ++i) {
            LivestreamEntry entry = this.listModel.getElementAt(i);
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, entry, i, null){
                int label;
                final /* synthetic */ LivestreamPanel this$0;
                final /* synthetic */ LivestreamEntry $entry;
                final /* synthetic */ int $i;
                {
                    this.this$0 = $receiver;
                    this.$entry = $entry;
                    this.$i = $i;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            LivestreamPanel.access$loadShowDetailsForEntry(this.this$0, this.$entry, this.$i);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void loadShowDetailsForEntry(LivestreamEntry entry, int index) {
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, entry, index, null){
            Object L$0;
            int label;
            final /* synthetic */ LivestreamPanel this$0;
            final /* synthetic */ LivestreamEntry $entry;
            final /* synthetic */ int $index;
            {
                this.this$0 = $receiver;
                this.$entry = $entry;
                this.$index = $index;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = LivestreamPanel.access$getShowService$p(this.this$0).getShow(this.$entry.getKey(), (Continuation<? super ShowsResponse>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        response = (ShowsResponse)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)response);
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$entry, response, this.this$0, this.$index, null){
                            int label;
                            final /* synthetic */ LivestreamEntry $entry;
                            final /* synthetic */ ShowsResponse $response;
                            final /* synthetic */ LivestreamPanel this$0;
                            final /* synthetic */ int $index;
                            {
                                this.$entry = $entry;
                                this.$response = $response;
                                this.this$0 = $receiver;
                                this.$index = $index;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object = CollectionsKt.firstOrNull(this.$response.getShows());
                                        ShowsResponse showsResponse = this.$response;
                                        ShowInfo showInfo = (ShowInfo)object;
                                        LivestreamEntry livestreamEntry = this.$entry;
                                        boolean bl = false;
                                        boolean bl2 = showsResponse.getError() == null;
                                        livestreamEntry.setShow((ShowInfo)(bl2 ? object : null));
                                        LivestreamPanel.access$getListModel$p(this.this$0).updateEntry(this.$index, this.$entry);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var3_2) goto lbl23
lbl22:
                        // 1 sources

                        return var3_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl43
                    }
                    case 2: {
                        response = (ShowsResponse)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl43
                        }
                        catch (Exception ex) {
                            LivestreamPanel.access$getLOG$cp().error("Failed to load show details", (Throwable)ex);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ex);
                            this.label = 3;
                            v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$entry, this.this$0, this.$index, null){
                                int label;
                                final /* synthetic */ LivestreamEntry $entry;
                                final /* synthetic */ LivestreamPanel this$0;
                                final /* synthetic */ int $index;
                                {
                                    this.$entry = $entry;
                                    this.this$0 = $receiver;
                                    this.$index = $index;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.$entry.setShow(null);
                                            LivestreamPanel.access$getListModel$p(this.this$0).updateEntry(this.$index, this.$entry);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl43
                        }
                    }
                    case 3: {
                        ex = (Exception)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl43:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void checkForExpiredShows() {
        Instant now = Instant.now();
        int n = this.listModel.getSize();
        for (int i = 0; i < n; ++i) {
            LivestreamEntry entry = this.listModel.getElementAt(i);
            ShowInfo show = entry.getShow();
            if (show == null) continue;
            if (show.getEndTime().isBefore(now)) {
                this.loadShowDetailsForEntry(entry, i);
                continue;
            }
            if (!show.getStartTime().isBefore(now)) continue;
            this.listModel.updateEntry(i, entry);
        }
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    private static final void refreshTimer$lambda$0(LivestreamPanel this$0, ActionEvent it) {
        this$0.checkForExpiredShows();
    }

    public static final /* synthetic */ JList access$getList$p(LivestreamPanel $this) {
        return $this.list;
    }

    public static final /* synthetic */ SingleIinaPlayer access$getIinaPlayer$p(LivestreamPanel $this) {
        return $this.iinaPlayer;
    }

    public static final /* synthetic */ OverlayPanel access$getOverlay$p(LivestreamPanel $this) {
        return $this.overlay;
    }

    public static final /* synthetic */ StreamService access$getStreamService$p(LivestreamPanel $this) {
        return $this.streamService;
    }

    public static final /* synthetic */ void access$loadAllShows(LivestreamPanel $this) {
        $this.loadAllShows();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$loadShowDetailsForEntry(LivestreamPanel $this, LivestreamEntry entry, int index) {
        $this.loadShowDetailsForEntry(entry, index);
    }

    public static final /* synthetic */ ShowService access$getShowService$p(LivestreamPanel $this) {
        return $this.showService;
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/gui/tabs/tab_livestreams/LivestreamPanel$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

