/*
 * Decompiled with CFR 0.152.
 */
package mediathek.swing;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmediathek/swing/OverlayPanel;", "Ljavax/swing/JComponent;", "message", "", "<init>", "(Ljava/lang/String;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "MediathekView"})
public final class OverlayPanel
extends JComponent {
    @NotNull
    private final String message;

    public OverlayPanel(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        g.setFont(g.getFont().deriveFont(1, 16.0f));
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(this.message);
        int textHeight = fm.getHeight();
        g.drawString(this.message, (this.getWidth() - textWidth) / 2, (this.getHeight() + textHeight) / 2 - fm.getDescent());
    }
}

