/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.time.LocalDate;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import mediathek.config.Config;
import mediathek.daten.Country;
import mediathek.daten.DatenFilmFlags;
import mediathek.daten.FilmResolution;
import mediathek.daten.abo.DatenAbo;
import mediathek.gui.bookmark.BookmarkData;
import mediathek.tool.FileSize;
import mediathek.tool.FilmSize;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.datum.DatumFilm;
import mediathek.tool.episodes.SeasonEpisode;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatenFilm
implements Comparable<DatenFilm> {
    public static final int FILM_NR = 0;
    public static final int FILM_SENDER = 1;
    public static final int FILM_THEMA = 2;
    public static final int FILM_TITEL = 3;
    public static final int FILM_ABSPIELEN = 4;
    public static final int FILM_AUFZEICHNEN = 5;
    public static final int FILM_MERKEN = 6;
    public static final int FILM_DATUM = 7;
    public static final int FILM_ZEIT = 8;
    public static final int FILM_DAUER = 9;
    public static final int FILM_GROESSE = 10;
    public static final int FILM_HD = 11;
    public static final int FILM_UT = 12;
    public static final int FILM_GEO = 13;
    public static final int FILM_URL = 14;
    public static final int FILM_DATUM_LONG = 15;
    public static final int FILM_REF = 16;
    public static final int MAX_ELEM = 17;
    public static final char COMPRESSION_MARKER = '|';
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final Logger logger = LogManager.getLogger(DatenFilm.class);
    private static final AtomicInteger FILMNR_GENERATOR = new AtomicInteger(0);
    public final EnumSet<Country> countrySet = EnumSet.noneOf(Country.class);
    private final EnumSet<DatenFilmFlags> flags = EnumSet.noneOf(DatenFilmFlags.class);
    private final FilmSize filmSize = new FilmSize();
    private final EnumMap<MapKeys, Object> dataMap = new EnumMap(MapKeys.class);
    LocalDate availableUntil;
    private DatumFilm datumFilm = DatumFilm.UNDEFINED_FILM_DATE;
    private String description;
    private String sender = "";
    private String thema = "";
    private String titel = "";
    private String datum = "";
    private String sendeZeit = "";
    private int filmLength;
    private int season = 0;
    private int episode = 0;

    public DatenFilm() {
        this.dataMap.put(MapKeys.FILM_NR, (Object)FILMNR_GENERATOR.getAndIncrement());
    }

    public DatenFilm(@NotNull DatenFilm other) {
        this.datumFilm = other.datumFilm;
        this.filmSize.setSize(other.filmSize.toString());
        this.description = other.description;
        this.sender = other.sender;
        this.thema = other.thema;
        this.titel = other.titel;
        this.countrySet.addAll(other.countrySet);
        this.dataMap.putAll(other.dataMap);
        this.datum = other.datum;
        this.sendeZeit = other.sendeZeit;
        this.filmLength = other.filmLength;
        this.season = other.season;
        this.episode = other.episode;
        this.availableUntil = other.availableUntil;
    }

    public static boolean isCompressedUrl(@NotNull String requestedUrl) {
        int indexPipe = requestedUrl.indexOf(124);
        return indexPipe != -1;
    }

    @Nullable
    public LocalDate getAvailableUntil() {
        return this.availableUntil;
    }

    public void setAvailableUntil(@Nullable LocalDate availableUntil) {
        this.availableUntil = availableUntil;
    }

    public int getFilmLength() {
        return this.filmLength;
    }

    public void setFilmLength(String dauer) {
        if (dauer == null || dauer.isEmpty()) {
            this.filmLength = 0;
        } else {
            String[] split = dauer.split(":");
            try {
                this.filmLength += Integer.parseInt(split[0]) * 3600;
                this.filmLength += Integer.parseInt(split[1]) * 60;
                this.filmLength += Integer.parseInt(split[2]);
            }
            catch (Exception e) {
                this.filmLength = 0;
            }
        }
    }

    public Optional<DatenAbo> getAboOptional() {
        DatenAbo abo = this.getAbo();
        return abo == null ? Optional.empty() : Optional.of(abo);
    }

    @Nullable
    public DatenAbo getAbo() {
        return this.dataMap.getOrDefault((Object)MapKeys.ABO_DATA, null);
    }

    public void setAbo(@Nullable DatenAbo abo) {
        if (abo == null) {
            this.dataMap.remove((Object)MapKeys.ABO_DATA);
        } else {
            this.dataMap.put(MapKeys.ABO_DATA, (Object)abo);
        }
    }

    public DatumFilm getDatumFilm() {
        return this.datumFilm;
    }

    public String getLowQualityUrl() {
        return (String)this.dataMap.getOrDefault((Object)MapKeys.LOW_QUALITY_URL, "");
    }

    public void setLowQualityUrl(@NotNull String url_low_quality) {
        if (url_low_quality.isEmpty()) {
            this.dataMap.remove((Object)MapKeys.LOW_QUALITY_URL);
        } else {
            this.dataMap.put(MapKeys.LOW_QUALITY_URL, (Object)url_low_quality);
        }
    }

    public String getHighQualityUrl() {
        return (String)this.dataMap.getOrDefault((Object)MapKeys.HIGH_QUALITY_URL, "");
    }

    public void setHighQualityUrl(@NotNull String urlHd) {
        if (urlHd.isEmpty()) {
            this.dataMap.remove((Object)MapKeys.HIGH_QUALITY_URL);
        } else {
            if (DatenFilm.isCompressedUrl(urlHd)) {
                urlHd = this.decompressUrl(urlHd);
            }
            this.dataMap.put(MapKeys.HIGH_QUALITY_URL, (Object)urlHd);
        }
    }

    public void setDatumLong(String datumLong) {
        long datum_long;
        try {
            datum_long = !datumLong.isEmpty() ? Long.parseLong(datumLong) : 0L;
        }
        catch (Exception e) {
            if (Config.isDebugModeEnabled()) {
                logger.error("Failed to parse datum long string: {}", (Object)datumLong);
            }
            datum_long = 0L;
        }
        this.dataMap.put(MapKeys.TEMP_DATUM_LONG, (Object)datum_long);
    }

    public boolean isTrailerTeaser() {
        return this.flags.contains((Object)DatenFilmFlags.TRAILER_TEASER);
    }

    public void setTrailerTeaser(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.TRAILER_TEASER);
        } else {
            this.flags.remove((Object)DatenFilmFlags.TRAILER_TEASER);
        }
    }

    public boolean isDuplicate() {
        return this.flags.contains((Object)DatenFilmFlags.DUPLICATE);
    }

    public void setDuplicate(boolean duplicate) {
        if (duplicate) {
            this.flags.add(DatenFilmFlags.DUPLICATE);
        } else {
            this.flags.remove((Object)DatenFilmFlags.DUPLICATE);
        }
    }

    public boolean isAudioVersion() {
        return this.flags.contains((Object)DatenFilmFlags.AUDIO_VERSION);
    }

    public void setAudioVersion(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.AUDIO_VERSION);
        } else {
            this.flags.remove((Object)DatenFilmFlags.AUDIO_VERSION);
        }
    }

    public boolean isPlayList() {
        return this.flags.contains((Object)DatenFilmFlags.PLAYLIST);
    }

    public void setPlayList(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.PLAYLIST);
        } else {
            this.flags.remove((Object)DatenFilmFlags.PLAYLIST);
        }
    }

    public boolean isSignLanguage() {
        return this.flags.contains((Object)DatenFilmFlags.SIGN_LANGUAGE);
    }

    public void setSignLanguage(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.SIGN_LANGUAGE);
        } else {
            this.flags.remove((Object)DatenFilmFlags.SIGN_LANGUAGE);
        }
    }

    public int getFilmNr() {
        return (Integer)this.dataMap.get((Object)MapKeys.FILM_NR);
    }

    public FilmSize getFileSize() {
        return this.filmSize;
    }

    public String getDescription() {
        return Objects.requireNonNullElse(this.description, "");
    }

    public void setDescription(String desc) {
        if (desc != null && !desc.isEmpty()) {
            this.description = desc;
        }
    }

    public String getWebsiteUrl() {
        return (String)this.dataMap.getOrDefault((Object)MapKeys.WEBSITE_URL, "");
    }

    public void setWebsiteUrl(String link) {
        if (link == null || link.isEmpty()) {
            this.dataMap.remove((Object)MapKeys.WEBSITE_URL);
        } else {
            this.dataMap.put(MapKeys.WEBSITE_URL, (Object)link);
        }
    }

    public boolean isNew() {
        return this.flags.contains((Object)DatenFilmFlags.NEW_ENTRY);
    }

    public void setNew(boolean newFilm) {
        if (newFilm) {
            this.flags.add(DatenFilmFlags.NEW_ENTRY);
        } else {
            this.flags.remove((Object)DatenFilmFlags.NEW_ENTRY);
        }
    }

    public boolean isLivestream() {
        return this.flags.contains((Object)DatenFilmFlags.LIVESTREAM);
    }

    public void setLivestream(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.LIVESTREAM);
        } else {
            this.flags.remove((Object)DatenFilmFlags.LIVESTREAM);
        }
    }

    public void setBurnedInSubtitles(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.BURNED_IN_SUBTITLES);
        } else {
            this.flags.remove((Object)DatenFilmFlags.BURNED_IN_SUBTITLES);
        }
    }

    public boolean hasBurnedInSubtitles() {
        return this.flags.contains((Object)DatenFilmFlags.BURNED_IN_SUBTITLES);
    }

    public boolean hasSubtitle() {
        return this.dataMap.containsKey((Object)MapKeys.SUBTITLE_URL);
    }

    public boolean hasAnySubtitles() {
        return this.hasSubtitle() || this.hasBurnedInSubtitles();
    }

    public String getUrlFuerAufloesung(FilmResolution.Enum resolution) {
        return switch (resolution) {
            case FilmResolution.Enum.LOW, FilmResolution.Enum.HIGH_QUALITY -> this.getUrlNormalOrRequested(resolution);
            default -> this.getUrlNormalQuality();
        };
    }

    public String getFileSizeForUrl(@NotNull String url) {
        if (url.equalsIgnoreCase(this.getUrlNormalQuality())) {
            return this.getFileSize().toString();
        }
        return FileSize.getFileLengthFromUrl(url);
    }

    public HashCode getSha256() {
        return Hashing.sha256().newHasher().putUnencodedChars((CharSequence)this.getSender()).putUnencodedChars((CharSequence)this.getThema()).putUnencodedChars((CharSequence)this.getUrlNormalQuality()).putUnencodedChars((CharSequence)this.getWebsiteUrl()).hash();
    }

    public boolean isHighQuality() {
        return this.dataMap.containsKey((Object)MapKeys.HIGH_QUALITY_URL);
    }

    public boolean hasLowQuality() {
        return this.dataMap.containsKey((Object)MapKeys.LOW_QUALITY_URL);
    }

    @Override
    public int compareTo(@NotNull DatenFilm other) {
        int ret = sorter.compare(this.getSender(), other.getSender());
        if (ret == 0) {
            return sorter.compare(this.getThema(), other.getThema());
        }
        return ret;
    }

    private void setupDatumFilm() {
        if (!this.getSendeDatum().isEmpty()) {
            long datum_long = (Long)this.dataMap.getOrDefault((Object)MapKeys.TEMP_DATUM_LONG, 0L);
            if (datum_long == 0L) {
                this.setSendeDatum("");
                this.setSendeZeit("");
                this.datumFilm = new DatumFilm(0L);
                this.dataMap.remove((Object)MapKeys.TEMP_DATUM_LONG);
            } else {
                this.datumFilm = new DatumFilm(TimeUnit.MILLISECONDS.convert(datum_long, TimeUnit.SECONDS));
                this.dataMap.put(MapKeys.TEMP_DATUM_LONG, (Object)datum_long);
            }
        }
    }

    public void init() {
        this.setupDatumFilm();
    }

    private String getUrlNormalOrRequested(@NotNull FilmResolution.Enum resolution) {
        String ret;
        String requestedUrl = this.getUrlByResolution(resolution);
        if (requestedUrl.isEmpty()) {
            ret = this.getUrlNormalQuality();
        } else {
            try {
                ret = DatenFilm.isCompressedUrl(requestedUrl) ? this.decompressUrl(requestedUrl) : requestedUrl;
            }
            catch (Exception e) {
                ret = "";
                logger.error("getUrlNormalOrRequested(aufl\u00f6sung: {}, requestedUrl: {})", (Object)resolution, (Object)requestedUrl, (Object)e);
            }
        }
        return ret;
    }

    public String decompressUrl(@NotNull String requestedUrl) throws NumberFormatException, IndexOutOfBoundsException {
        int indexPipe = requestedUrl.indexOf(124);
        int i = Integer.parseInt(requestedUrl.substring(0, indexPipe));
        return this.getUrlNormalQuality().substring(0, i) + requestedUrl.substring(indexPipe + 1);
    }

    private String getUrlByResolution(@NotNull FilmResolution.Enum resolution) {
        return switch (resolution) {
            case FilmResolution.Enum.HIGH_QUALITY -> this.getHighQualityUrl();
            case FilmResolution.Enum.LOW -> this.getLowQualityUrl();
            default -> this.getUrlNormalQuality();
        };
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getThema() {
        return this.thema;
    }

    public void setThema(String thema) {
        this.thema = thema;
    }

    public String getTitle() {
        return this.titel;
    }

    public void setTitle(String title) {
        this.titel = title;
    }

    public String getSendeDatum() {
        return this.datum;
    }

    public void setSendeDatum(String sendeDatum) {
        this.datum = sendeDatum;
    }

    public String getSendeZeit() {
        return this.sendeZeit;
    }

    public void setSendeZeit(String sendeZeit) {
        this.sendeZeit = sendeZeit;
    }

    public String getFilmLengthAsString() {
        if (this.filmLength == 0) {
            return "";
        }
        long duration = TimeUnit.MILLISECONDS.convert(this.filmLength, TimeUnit.SECONDS);
        return DurationFormatUtils.formatDuration((long)duration, (String)"HH:mm:ss", (boolean)true);
    }

    public String getUrlNormalQuality() {
        return (String)this.dataMap.getOrDefault((Object)MapKeys.NORMAL_QUALITY_URL, "");
    }

    public void setNormalQualityUrl(@NotNull String url_normal_quality) {
        if (url_normal_quality.isEmpty()) {
            this.dataMap.remove((Object)MapKeys.NORMAL_QUALITY_URL);
        } else {
            this.dataMap.put(MapKeys.NORMAL_QUALITY_URL, (Object)url_normal_quality);
        }
    }

    public String getSubtitleUrl() {
        return (String)this.dataMap.getOrDefault((Object)MapKeys.SUBTITLE_URL, "");
    }

    public void setSubtitleUrl(@NotNull String urlSubtitle) {
        if (urlSubtitle.isEmpty()) {
            this.dataMap.remove((Object)MapKeys.SUBTITLE_URL);
        } else {
            this.dataMap.put(MapKeys.SUBTITLE_URL, (Object)urlSubtitle);
        }
    }

    @Nullable
    public BookmarkData getBookmark() {
        return this.dataMap.getOrDefault((Object)MapKeys.BOOKMARK_DATA, null);
    }

    public void setBookmark(@Nullable BookmarkData bookmark) {
        if (bookmark == null) {
            this.dataMap.remove((Object)MapKeys.BOOKMARK_DATA);
        } else {
            this.dataMap.put(MapKeys.BOOKMARK_DATA, (Object)bookmark);
        }
    }

    public boolean isBookmarked() {
        return this.dataMap.containsKey((Object)MapKeys.BOOKMARK_DATA);
    }

    public void setSeasonEpisode(SeasonEpisode seasonEpisode) {
        this.season = seasonEpisode.season();
        this.episode = seasonEpisode.episode();
    }

    public int getSeason() {
        return this.season;
    }

    public int getEpisode() {
        return this.episode;
    }

    static enum MapKeys {
        FILM_NR,
        SUBTITLE_URL,
        WEBSITE_URL,
        LOW_QUALITY_URL,
        NORMAL_QUALITY_URL,
        HIGH_QUALITY_URL,
        BOOKMARK_DATA,
        ABO_DATA,
        TEMP_DATUM_LONG;

    }
}

