/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bookmark;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import mediathek.gui.bookmark.BookmarkData;
import mediathek.gui.expiration.SenderExpirationService;
import mediathek.swing.IconUtils;
import mediathek.swing.JIkonliSafeButton;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.datum.DateUtil;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign2.MaterialDesignC;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010$\u001a\u00020\tJ\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lmediathek/gui/bookmark/BookmarkEditNoteDialog;", "Ljavax/swing/JDialog;", "owner", "Ljava/awt/Dialog;", "bm", "Lmediathek/gui/bookmark/BookmarkData;", "<init>", "(Ljava/awt/Dialog;Lmediathek/gui/bookmark/BookmarkData;)V", "okPressed", "", "datePicker", "Lorg/jdesktop/swingx/JXDatePicker;", "btnSearch", "Lmediathek/swing/JIkonliSafeButton;", "textArea", "Ljavax/swing/JTextArea;", "okButton", "Ljavax/swing/JButton;", "cancelButton", "busyIndicator", "Lorg/jdesktop/swingx/JXBusyLabel;", "job", "Lkotlinx/coroutines/CompletableJob;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "enableBusyIndicator", "", "value", "dispose", "setupButtonBar", "setupNotizArea", "setupDatePicker", "getNotiz", "", "getAvailableUntilDate", "Ljava/time/LocalDate;", "isOkPressed", "showNotFoundMessage", "initComponents", "MediathekView"})
public final class BookmarkEditNoteDialog
extends JDialog {
    @NotNull
    private final BookmarkData bm;
    private boolean okPressed;
    @NotNull
    private final JXDatePicker datePicker;
    @NotNull
    private final JIkonliSafeButton btnSearch;
    @NotNull
    private final JTextArea textArea;
    @NotNull
    private final JButton okButton;
    @NotNull
    private final JButton cancelButton;
    @NotNull
    private final JXBusyLabel busyIndicator;
    @NotNull
    private final CompletableJob job;
    @NotNull
    private final CoroutineScope coroutineScope;

    public BookmarkEditNoteDialog(@NotNull Dialog owner, @NotNull BookmarkData bm) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)bm, (String)"bm");
        super(owner, true);
        this.bm = bm;
        this.datePicker = new JXDatePicker();
        this.btnSearch = new JIkonliSafeButton();
        this.textArea = new JTextArea();
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Abbrechen");
        this.busyIndicator = new JXBusyLabel();
        this.job = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.job.plus((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)));
        this.setTitle("Notiz hinzuf\u00fcgen");
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.enableBusyIndicator(false);
        this.rootPane.setDefaultButton(this.okButton);
        EscapeKeyHandler.installHandler(this, () -> BookmarkEditNoteDialog._init_$lambda$0(this));
        this.setupButtonBar();
        this.setupNotizArea();
        this.setupDatePicker();
        this.btnSearch.setIcon((Icon)IconUtils.of((Ikon)MaterialDesignC.CLOUD_SEARCH_OUTLINE, 20));
        this.btnSearch.setToolTipText("Auf Website suchen");
        this.btnSearch.addActionListener(arg_0 -> BookmarkEditNoteDialog._init_$lambda$1(this, arg_0));
        SwingUtilities.invokeLater(() -> BookmarkEditNoteDialog._init_$lambda$2(this));
    }

    private final void enableBusyIndicator(boolean value) {
        this.busyIndicator.setBusy(value);
        this.busyIndicator.setVisible(value);
    }

    @Override
    public void dispose() {
        Job.DefaultImpls.cancel$default((Job)((Job)this.job), null, (int)1, null);
        super.dispose();
    }

    private final void setupButtonBar() {
        this.okButton.addActionListener(arg_0 -> BookmarkEditNoteDialog.setupButtonBar$lambda$0(this, arg_0));
        this.cancelButton.addActionListener(arg_0 -> BookmarkEditNoteDialog.setupButtonBar$lambda$1(this, arg_0));
    }

    private final void setupNotizArea() {
        String string = this.bm.getNote();
        if (string == null) {
            string = "";
        }
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    private final void setupDatePicker() {
        block0: {
            LocalDate localDate = this.bm.getAvailableUntil();
            if (localDate == null) break block0;
            LocalDate it = localDate;
            boolean bl = false;
            this.datePicker.setDate(DateUtil.convertToDate(it));
        }
    }

    @NotNull
    public final String getNotiz() {
        String string = this.textArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Nullable
    public final LocalDate getAvailableUntilDate() {
        return DateUtil.convertToLocalDate(this.datePicker.getDate());
    }

    public final boolean isOkPressed() {
        return this.okPressed;
    }

    private final void showNotFoundMessage() {
        JOptionPane.showMessageDialog(this, "Das Ablaufdatum wurde nicht gefunden.", "MediathekView", 2);
    }

    private final void initComponents() {
        JPanel dialogPane = new JPanel(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("dialog").hideMode(3), new AC().fill().gap().fill().gap().fill().gap().fill().gap().grow().fill(), new AC().gap().grow().align("top")));
        int[] nArray = new int[]{0, 0};
        contentPanel.add((Component)new JLabel("Verf\u00fcgbar bis:"), new CC().cell(nArray));
        nArray = new int[]{1, 0};
        contentPanel.add((Component)this.datePicker, new CC().cell(nArray));
        nArray = new int[]{2, 0};
        contentPanel.add((Component)this.btnSearch, new CC().cell(nArray));
        nArray = new int[]{3, 0};
        contentPanel.add((Component)this.busyIndicator, new CC().cell(nArray));
        nArray = new int[]{0, 1};
        contentPanel.add((Component)new JLabel("Notiz:"), new CC().cell(nArray));
        Object object = new JScrollPane(this.textArea);
        JScrollPane $this$initComponents_u24lambda_u240 = object;
        boolean bl = false;
        $this$initComponents_u24lambda_u240.setMinimumSize(new Dimension(400, 150));
        $this$initComponents_u24lambda_u240.setPreferredSize(new Dimension(400, 150));
        JScrollPane scrollPane = object;
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        object = new int[4];
        object[0] = true;
        object[1] = true;
        object[2] = 4;
        object[3] = true;
        contentPanel.add((Component)scrollPane, new CC().cell((int[])object).grow());
        JPanel buttonBar = new JPanel((LayoutManager)new MigLayout(new LC().insets("dialog").alignX("right"), new AC().size("button").fill().gap().size("button").fill(), new AC()));
        int[] nArray2 = new int[]{0, 0};
        buttonBar.add((Component)this.okButton, new CC().cell(nArray2));
        nArray2 = new int[]{1, 0};
        buttonBar.add((Component)this.cancelButton, new CC().cell(nArray2));
        dialogPane.add((Component)contentPanel, "Center");
        dialogPane.add((Component)buttonBar, "South");
        this.getContentPane().add((Component)dialogPane, "Center");
        this.setMinimumSize(new Dimension(450, 300));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private static final void _init_$lambda$0(BookmarkEditNoteDialog this$0) {
        this$0.dispose();
    }

    private static final void _init_$lambda$1(BookmarkEditNoteDialog this$0, ActionEvent it) {
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ BookmarkEditNoteDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BookmarkEditNoteDialog.access$getBtnSearch$p(this.this$0).setEnabled(false);
                        BookmarkEditNoteDialog.access$enableBusyIndicator(this.this$0, true);
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LocalDate>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ BookmarkEditNoteDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        String string = BookmarkEditNoteDialog.access$getBm$p(this.this$0).getDatenFilm().getSender();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSender(...)");
                                        String string2 = BookmarkEditNoteDialog.access$getBm$p(this.this$0).getDatenFilm().getWebsiteUrl();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getWebsiteUrl(...)");
                                        return SenderExpirationService.fetchExpiryDate(string, string2);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super LocalDate> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl13
lbl12:
                        // 1 sources

                        return var3_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            if ((result = (LocalDate)v0) != null) {
                                BookmarkEditNoteDialog.access$getDatePicker$p(this.this$0).setDate(DateUtil.convertToDate(result));
                            } else {
                                BookmarkEditNoteDialog.access$showNotFoundMessage(this.this$0);
                            }
                        }
                        catch (Throwable var2_4) {
                            throw var2_4;
                        }
                        finally {
                            BookmarkEditNoteDialog.access$getBtnSearch$p(this.this$0).setEnabled(true);
                            BookmarkEditNoteDialog.access$enableBusyIndicator(this.this$0, false);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void _init_$lambda$2(BookmarkEditNoteDialog this$0) {
        this$0.textArea.requestFocusInWindow();
    }

    private static final void setupButtonBar$lambda$0(BookmarkEditNoteDialog this$0, ActionEvent it) {
        this$0.okPressed = true;
        this$0.dispose();
    }

    private static final void setupButtonBar$lambda$1(BookmarkEditNoteDialog this$0, ActionEvent it) {
        this$0.dispose();
    }

    public static final /* synthetic */ JIkonliSafeButton access$getBtnSearch$p(BookmarkEditNoteDialog $this) {
        return $this.btnSearch;
    }

    public static final /* synthetic */ void access$enableBusyIndicator(BookmarkEditNoteDialog $this, boolean value) {
        $this.enableBusyIndicator(value);
    }

    public static final /* synthetic */ BookmarkData access$getBm$p(BookmarkEditNoteDialog $this) {
        return $this.bm;
    }

    public static final /* synthetic */ JXDatePicker access$getDatePicker$p(BookmarkEditNoteDialog $this) {
        return $this.datePicker;
    }

    public static final /* synthetic */ void access$showNotFoundMessage(BookmarkEditNoteDialog $this) {
        $this.showNotFoundMessage();
    }
}

