/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mediathek.config.Daten;
import mediathek.mainwindow.MediathekGui;
import mediathek.swing.AppTerminationIndefiniteProgress;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GetFile;
import mediathek.tool.SVGIconUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020\u001dH\u0002R\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lmediathek/gui/dialog/DialogBeenden;", "Ljavax/swing/JDialog;", "parent", "Ljavax/swing/JFrame;", "shouldDownloadAndQuit", "", "<init>", "(Ljavax/swing/JFrame;Z)V", "value", "applicationCanTerminate", "getApplicationCanTerminate", "()Z", "isShutdownRequested", "downloadMonitorWorker", "Lmediathek/gui/dialog/DialogBeenden$WaitForDownloadsWorker;", "comboActions", "Ljavax/swing/JComboBox;", "", "btnContinue", "Ljavax/swing/JButton;", "cbShutdownComputer", "Ljavax/swing/JCheckBox;", "btnCancel", "jButtonHilfe", "comboBoxModel", "Ljavax/swing/DefaultComboBoxModel;", "getComboBoxModel", "()Ljavax/swing/DefaultComboBoxModel;", "escapeHandler", "", "waitUntilDownloadsHaveFinished", "waitForRunningDownloadsOnly", "initComponents", "WaitForDownloadsWorker", "Companion", "MediathekView"})
public final class DialogBeenden
extends JDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean applicationCanTerminate;
    private boolean isShutdownRequested;
    @NotNull
    private final WaitForDownloadsWorker downloadMonitorWorker;
    @NotNull
    private final JComboBox<String> comboActions;
    @NotNull
    private final JButton btnContinue;
    @NotNull
    private final JCheckBox cbShutdownComputer;
    @NotNull
    private final JButton btnCancel;
    @NotNull
    private final JButton jButtonHilfe;
    @NotNull
    private static final String CANCEL_AND_TERMINATE_PROGRAM = "Downloads abbrechen und Programm beenden";
    @NotNull
    private static final String WAIT_FOR_DOWNLOADS_AND_TERMINATE = "Auf Abschlu\u00df aller Downloads warten, danach beenden";
    @NotNull
    private static final String WAIT_FOR_RUNNING_DOWNLOADS_AND_TERMINATE = "Nur auf bereits laufende Downloads warten, danach beenden";

    public DialogBeenden(@NotNull JFrame parent, boolean shouldDownloadAndQuit) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super((Frame)parent, true);
        this.downloadMonitorWorker = new WaitForDownloadsWorker();
        this.comboActions = new JComboBox(this.getComboBoxModel());
        this.btnContinue = new JButton("Weiter");
        this.cbShutdownComputer = new JCheckBox("Rechner herunterfahren");
        this.btnCancel = new JButton("Abbrechen");
        this.jButtonHilfe = new JButton((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
        this.setDefaultCloseOperation(2);
        this.setTitle("MediathekView beenden");
        this.setResizable(false);
        this.initComponents();
        EscapeKeyHandler.installHandler(this, () -> DialogBeenden._init_$lambda$0(this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.escapeHandler();
            }
        });
        this.jButtonHilfe.addActionListener(arg_0 -> DialogBeenden._init_$lambda$1(this, arg_0));
        this.jButtonHilfe.setEnabled(false);
        this.cbShutdownComputer.setEnabled(false);
        this.comboActions.addActionListener(arg_0 -> DialogBeenden._init_$lambda$2(this, arg_0));
        this.cbShutdownComputer.addActionListener(arg_0 -> DialogBeenden._init_$lambda$3(this, arg_0));
        this.btnContinue.addActionListener(arg_0 -> DialogBeenden._init_$lambda$4(this, arg_0));
        this.btnCancel.addActionListener(arg_0 -> DialogBeenden._init_$lambda$5(this, arg_0));
        this.pack();
        this.getRootPane().setDefaultButton(this.btnContinue);
        if (shouldDownloadAndQuit) {
            this.applicationCanTerminate = true;
            SwingUtilities.invokeLater(() -> DialogBeenden._init_$lambda$6(this));
        }
    }

    public final boolean getApplicationCanTerminate() {
        return this.applicationCanTerminate;
    }

    public final boolean isShutdownRequested() {
        return this.isShutdownRequested;
    }

    private final DefaultComboBoxModel<String> getComboBoxModel() {
        String[] stringArray = new String[]{CANCEL_AND_TERMINATE_PROGRAM, WAIT_FOR_DOWNLOADS_AND_TERMINATE, WAIT_FOR_RUNNING_DOWNLOADS_AND_TERMINATE};
        return new DefaultComboBoxModel<String>(stringArray);
    }

    private final void escapeHandler() {
        this.downloadMonitorWorker.cancel(true);
        Component component = this.getGlassPane();
        if (component != null) {
            component.setVisible(false);
        }
        this.applicationCanTerminate = false;
        this.dispose();
    }

    private final void waitUntilDownloadsHaveFinished(boolean waitForRunningDownloadsOnly) {
        this.setGlassPane(new AppTerminationIndefiniteProgress(this.isShutdownRequested));
        Component component = this.getGlassPane();
        if (component != null) {
            component.setVisible(true);
        }
        if (waitForRunningDownloadsOnly) {
            MediathekGui.ui().tabDownloads.stopAllWaitingDownloads();
        }
        this.downloadMonitorWorker.execute();
    }

    static /* synthetic */ void waitUntilDownloadsHaveFinished$default(DialogBeenden dialogBeenden, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        dialogBeenden.waitUntilDownloadsHaveFinished(bl);
    }

    private final void initComponents() {
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        GroupLayout contentPaneLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(contentPaneLayout);
        JLabel jLabel1 = new JLabel("<html>Es sind noch nicht alle Downloads fertig.<br>Wie m\u00f6chten Sie fortfahren?</html>");
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(jLabel1, -1, 521, Short.MAX_VALUE).addComponent(this.comboActions, -1, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHilfe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnContinue)).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.cbShutdownComputer).addGap(0, 351, Short.MAX_VALUE))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboActions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShutdownComputer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnContinue).addComponent(this.btnCancel)).addComponent(this.jButtonHilfe)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private static final void _init_$lambda$0(DialogBeenden this$0) {
        this$0.escapeHandler();
    }

    private static final void _init_$lambda$1(DialogBeenden this$0, ActionEvent it) {
        String string = GetFile.getHilfeSuchen("/mediathek/file/hilfetext_beenden.txt");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHilfeSuchen(...)");
        String msg = ((Object)StringsKt.trim((CharSequence)string)).toString();
        JOptionPane.showMessageDialog(this$0, msg, "MediathekView", -1);
    }

    private static final void _init_$lambda$2(DialogBeenden this$0, ActionEvent it) {
        Object object = Objects.requireNonNull(this$0.comboActions.getSelectedItem());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object;
        if (Intrinsics.areEqual((Object)string, (Object)WAIT_FOR_DOWNLOADS_AND_TERMINATE) || Intrinsics.areEqual((Object)string, (Object)WAIT_FOR_RUNNING_DOWNLOADS_AND_TERMINATE)) {
            this$0.jButtonHilfe.setEnabled(true);
            this$0.cbShutdownComputer.setEnabled(true);
        } else {
            this$0.jButtonHilfe.setEnabled(false);
            this$0.cbShutdownComputer.setEnabled(false);
            this$0.cbShutdownComputer.setSelected(false);
            this$0.isShutdownRequested = false;
        }
    }

    private static final void _init_$lambda$3(DialogBeenden this$0, ActionEvent it) {
        this$0.isShutdownRequested = this$0.cbShutdownComputer.isSelected();
    }

    private static final void _init_$lambda$4(DialogBeenden this$0, ActionEvent it) {
        Object object = Objects.requireNonNull(this$0.comboActions.getSelectedItem());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        switch ((String)object) {
            case "Auf Abschlu\u00df aller Downloads warten, danach beenden": {
                DialogBeenden.waitUntilDownloadsHaveFinished$default(this$0, false, 1, null);
                break;
            }
            case "Nur auf bereits laufende Downloads warten, danach beenden": {
                this$0.waitUntilDownloadsHaveFinished(true);
                break;
            }
            case "Downloads abbrechen und Programm beenden": {
                this$0.applicationCanTerminate = true;
                this$0.dispose();
            }
        }
    }

    private static final void _init_$lambda$5(DialogBeenden this$0, ActionEvent it) {
        this$0.escapeHandler();
    }

    private static final void _init_$lambda$6(DialogBeenden this$0) {
        DialogBeenden.waitUntilDownloadsHaveFinished$default(this$0, false, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lmediathek/gui/dialog/DialogBeenden$Companion;", "", "<init>", "()V", "CANCEL_AND_TERMINATE_PROGRAM", "", "WAIT_FOR_DOWNLOADS_AND_TERMINATE", "WAIT_FOR_RUNNING_DOWNLOADS_AND_TERMINATE", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lmediathek/gui/dialog/DialogBeenden$WaitForDownloadsWorker;", "Ljavax/swing/SwingWorker;", "Ljava/lang/Void;", "<init>", "(Lmediathek/gui/dialog/DialogBeenden;)V", "doInBackground", "done", "", "MediathekView"})
    private final class WaitForDownloadsWorker
    extends SwingWorker<Void, Void> {
        @Override
        @Nullable
        protected Void doInBackground() {
            while (Daten.getInstance().getListeDownloads().unfinishedDownloads() > 0L && !this.isCancelled()) {
                TimeUnit.SECONDS.sleep(1L);
            }
            return null;
        }

        @Override
        protected void done() {
            DialogBeenden.this.applicationCanTerminate = true;
            Component component = DialogBeenden.this.getGlassPane();
            if (component != null) {
                component.setVisible(false);
            }
            DialogBeenden.this.dispose();
        }
    }
}

