/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import com.github.lgooddatepicker.components.DateTimePicker;
import com.github.lgooddatepicker.components.TimePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import mediathek.config.Daten;
import mediathek.daten.DatenDownload;
import mediathek.swing.AppTerminationIndefiniteProgress;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GetFile;
import mediathek.tool.SVGIconUtilities;

public class DialogBeendenZeit
extends JDialog {
    private static final String WAIT_FOR_DOWNLOADS_AND_TERMINATE = "Auf Abschlu\u00df aller Downloads warten und danach Programm beenden";
    private static final String WAIT_FOR_DOWNLOADS_AND_DONT_TERMINATE_PROGRAM = "Auf Abschlu\u00df aller Downloads warten, Programm danach NICHT beenden";
    private static final String DONT_START = "Downloads nicht starten";
    private final ArrayList<DatenDownload> listeDownloadsStarten;
    private boolean applicationCanTerminate;
    private boolean shutdown;
    private JPanel glassPane;
    private AppTerminationIndefiniteProgress progressPanel;
    private BusyWaitWorker downloadMonitorWorker;
    private JComboBox<String> comboActions;
    private JButton btnContinue;
    private JCheckBox cbShutdownComputer;
    private JButton btnCancel;
    private JButton jButtonHilfe;
    private DateTimePicker dateTimePicker;

    public boolean applicationCanTerminate() {
        return this.applicationCanTerminate;
    }

    public boolean isShutdownRequested() {
        return this.shutdown;
    }

    public DialogBeendenZeit(JFrame parent, ArrayList<DatenDownload> listeDownloadsStarten_) {
        super((Frame)parent, true);
        this.initComponents();
        this.dateTimePicker.datePicker.setDateToToday();
        TimePicker timePicker = this.dateTimePicker.timePicker;
        timePicker.setTimeToNow();
        LocalTime selTime = timePicker.getTime();
        selTime = selTime.plusHours(1L).plusMinutes(1L);
        timePicker.setTime(selTime);
        this.listeDownloadsStarten = listeDownloadsStarten_;
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
        EscapeKeyHandler.installHandler(this, this::escapeHandler);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogBeendenZeit this$0;
            {
                DialogBeendenZeit dialogBeendenZeit = this$0;
                Objects.requireNonNull(dialogBeendenZeit);
                this.this$0 = dialogBeendenZeit;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.escapeHandler();
            }
        });
        this.comboActions.setModel(this.getComboBoxModel());
        this.comboActions.addActionListener(actionEvent -> this.setCbShutdownCoputer());
        this.jButtonHilfe.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
        this.jButtonHilfe.addActionListener(actionEvent -> {
            String msg = GetFile.getHilfeSuchen("/mediathek/file/hilfetext_beenden.txt").trim();
            JOptionPane.showMessageDialog(parent, msg, "MediathekView", 1);
        });
        this.setCbShutdownCoputer();
        this.cbShutdownComputer.addActionListener(actionEvent -> {
            this.shutdown = this.cbShutdownComputer.isSelected();
        });
        this.btnContinue.addActionListener(actionEvent -> {
            String strSelectedItem;
            switch (strSelectedItem = Objects.requireNonNull(this.comboActions.getSelectedItem()).toString()) {
                case "Auf Abschlu\u00df aller Downloads warten und danach Programm beenden": {
                    this.applicationCanTerminate = true;
                    this.waitUntilDownloadsHaveFinished();
                    break;
                }
                case "Auf Abschlu\u00df aller Downloads warten, Programm danach NICHT beenden": {
                    this.applicationCanTerminate = false;
                    this.waitUntilDownloadsHaveFinished();
                    break;
                }
                case "Downloads nicht starten": {
                    this.applicationCanTerminate = false;
                    this.dispose();
                }
            }
        });
        this.btnCancel.addActionListener(actionEvent -> this.escapeHandler());
        this.getRootPane().setDefaultButton(this.btnContinue);
        this.pack();
    }

    private void setCbShutdownCoputer() {
        String strSelectedItem = (String)this.comboActions.getSelectedItem();
        if (WAIT_FOR_DOWNLOADS_AND_TERMINATE.equals(strSelectedItem)) {
            this.cbShutdownComputer.setEnabled(true);
        } else {
            this.cbShutdownComputer.setEnabled(false);
            this.cbShutdownComputer.setSelected(false);
            this.shutdown = false;
        }
    }

    private DefaultComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{WAIT_FOR_DOWNLOADS_AND_TERMINATE, WAIT_FOR_DOWNLOADS_AND_DONT_TERMINATE_PROGRAM, DONT_START});
    }

    private void escapeHandler() {
        if (this.downloadMonitorWorker != null) {
            this.downloadMonitorWorker.cancel(true);
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
        this.applicationCanTerminate = false;
        this.dispose();
    }

    private JPanel createGlassPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        this.progressPanel = new AppTerminationIndefiniteProgress(this.isShutdownRequested());
        panel.add((Component)this.progressPanel, "Center");
        return panel;
    }

    private void setTextWait() {
        LocalDateTime dt = this.dateTimePicker.getDateTimePermissive();
        String t = dt.format(DateTimeFormatter.ofPattern("HH:mm"));
        String d = dt.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        this.progressPanel.setMessage(String.format("Downloads werden am %s um %s gestartet.", d, t));
    }

    private void waitUntilDownloadsHaveFinished() {
        this.glassPane = this.createGlassPane();
        this.setGlassPane(this.glassPane);
        this.setTextWait();
        this.glassPane.setVisible(true);
        this.downloadMonitorWorker = new BusyWaitWorker(this);
        this.downloadMonitorWorker.execute();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.comboActions = new JComboBox();
        this.btnContinue = new JButton();
        this.cbShutdownComputer = new JCheckBox();
        this.btnCancel = new JButton();
        this.jButtonHilfe = new JButton();
        JLabel jLabel2 = new JLabel();
        this.dateTimePicker = new DateTimePicker();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setTitle("Zeitverz\u00f6gerter Download-Start");
        Container contentPane = this.getContentPane();
        jLabel1.setText("Wie m\u00f6chten Sie fortfahren wenn alle Downloads fertig sind?");
        this.btnContinue.setText("Weiter");
        this.cbShutdownComputer.setText("Rechner herunterfahren");
        this.btnCancel.setText("Abbrechen");
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        jLabel2.setText("Alle Downloads starten um: ");
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.comboActions, -1, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHilfe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnContinue)).addComponent(this.cbShutdownComputer).addGroup(contentPaneLayout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dateTimePicker, -2, -1, -2))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dateTimePicker, -2, -1, -2).addComponent(jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 94, Short.MAX_VALUE).addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboActions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.cbShutdownComputer).addGap(18, 18, 18).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnContinue).addComponent(this.btnCancel))).addComponent(this.jButtonHilfe)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class BusyWaitWorker
    extends SwingWorker<Void, Void> {
        final /* synthetic */ DialogBeendenZeit this$0;

        private BusyWaitWorker(DialogBeendenZeit dialogBeendenZeit) {
            DialogBeendenZeit dialogBeendenZeit2 = dialogBeendenZeit;
            Objects.requireNonNull(dialogBeendenZeit2);
            this.this$0 = dialogBeendenZeit2;
        }

        @Override
        protected Void doInBackground() throws Exception {
            while (LocalDateTime.now().isBefore(this.this$0.dateTimePicker.getDateTimePermissive())) {
                TimeUnit.SECONDS.sleep(1L);
            }
            this.this$0.progressPanel.setMessage("Warte auf Abschluss der Downloads...");
            DatenDownload.startenDownloads(this.this$0.listeDownloadsStarten);
            while (Daten.getInstance().getListeDownloads().unfinishedDownloads() > 0L && !this.isCancelled()) {
                TimeUnit.SECONDS.sleep(1L);
            }
            return null;
        }

        @Override
        protected void done() {
            this.this$0.glassPane.setVisible(false);
            this.this$0.dispose();
            this.this$0.downloadMonitorWorker = null;
        }
    }
}

