/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.expiration;

import java.time.LocalDate;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mediathek.gui.expiration.ArdMediathekExpiryHelper;
import mediathek.gui.expiration.ArteExpiryHelper;
import mediathek.gui.expiration.ExpiryInfo;
import mediathek.gui.expiration.OrfExpiryHelper;
import mediathek.gui.expiration.ThreeSatExpiryHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lmediathek/gui/expiration/SenderExpirationService;", "", "<init>", "()V", "ARD_SENDERS", "", "", "fetchExpiryDate", "Ljava/time/LocalDate;", "sender", "websiteUrl", "normalizeSender", "MediathekView"})
public final class SenderExpirationService {
    @NotNull
    public static final SenderExpirationService INSTANCE = new SenderExpirationService();
    @NotNull
    private static final Set<String> ARD_SENDERS;

    private SenderExpirationService() {
    }

    @JvmStatic
    @Nullable
    public static final LocalDate fetchExpiryDate(@NotNull String sender, @NotNull String websiteUrl) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)websiteUrl, (String)"websiteUrl");
        String normalizedSender = INSTANCE.normalizeSender(sender);
        return StringsKt.contains$default((CharSequence)normalizedSender, (CharSequence)"arte", (boolean)false, (int)2, null) ? (LocalDate)ArteExpiryHelper.getExpiryInfo(websiteUrl).map(arg_0 -> SenderExpirationService.fetchExpiryDate$lambda$1(SenderExpirationService::fetchExpiryDate$lambda$0, arg_0)).orElse(null) : (Intrinsics.areEqual((Object)normalizedSender, (Object)"3sat") ? (LocalDate)ThreeSatExpiryHelper.getExpiryInfo(websiteUrl).map(arg_0 -> SenderExpirationService.fetchExpiryDate$lambda$3(SenderExpirationService::fetchExpiryDate$lambda$2, arg_0)).orElse(null) : (ARD_SENDERS.contains(normalizedSender) ? (LocalDate)ArdMediathekExpiryHelper.getExpiryInfo(websiteUrl).map(arg_0 -> SenderExpirationService.fetchExpiryDate$lambda$5(SenderExpirationService::fetchExpiryDate$lambda$4, arg_0)).orElse(null) : (Intrinsics.areEqual((Object)normalizedSender, (Object)"orf") ? (LocalDate)OrfExpiryHelper.getExpiryInfo(websiteUrl).map(arg_0 -> SenderExpirationService.fetchExpiryDate$lambda$7(SenderExpirationService::fetchExpiryDate$lambda$6, arg_0)).orElse(null) : null)));
    }

    private final String normalizeSender(String sender) {
        String string = ((Object)StringsKt.trim((CharSequence)sender)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("[^a-z0-9]");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    private static final LocalDate fetchExpiryDate$lambda$0(ExpiryInfo it) {
        return it.expiryDate();
    }

    private static final LocalDate fetchExpiryDate$lambda$1(Function1 $tmp0, Object p0) {
        return (LocalDate)$tmp0.invoke(p0);
    }

    private static final LocalDate fetchExpiryDate$lambda$2(ExpiryInfo it) {
        return it.expiryDate();
    }

    private static final LocalDate fetchExpiryDate$lambda$3(Function1 $tmp0, Object p0) {
        return (LocalDate)$tmp0.invoke(p0);
    }

    private static final LocalDate fetchExpiryDate$lambda$4(ExpiryInfo it) {
        return it.expiryDate();
    }

    private static final LocalDate fetchExpiryDate$lambda$5(Function1 $tmp0, Object p0) {
        return (LocalDate)$tmp0.invoke(p0);
    }

    private static final LocalDate fetchExpiryDate$lambda$6(ExpiryInfo it) {
        return it.expiryDate();
    }

    private static final LocalDate fetchExpiryDate$lambda$7(Function1 $tmp0, Object p0) {
        return (LocalDate)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"ard", "ardalpha", "br", "funknet", "hr", "mdr", "ndr", "one", "phoenix", "radiobremntv", "rbb", "sr", "swr", "tagesschau24", "wdr"};
        ARD_SENDERS = SetsKt.setOf((Object[])objectArray);
    }
}

