/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_livestreams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import mediathek.gui.tabs.tab_livestreams.ListCell;
import mediathek.gui.tabs.tab_livestreams.LivestreamEntry;
import mediathek.gui.tabs.tab_livestreams.SenderUtils;
import mediathek.gui.tabs.tab_livestreams.icons.SvgIconCache;
import mediathek.gui.tabs.tab_livestreams.services.ShowInfo;
import mediathek.tool.datum.DateUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmediathek/gui/tabs/tab_livestreams/LivestreamRenderer;", "Ljavax/swing/JPanel;", "Ljavax/swing/ListCellRenderer;", "Lmediathek/gui/tabs/tab_livestreams/LivestreamEntry;", "<init>", "()V", "listCell", "Lmediathek/gui/tabs/tab_livestreams/ListCell;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "Companion", "MediathekView"})
public final class LivestreamRenderer
extends JPanel
implements ListCellRenderer<LivestreamEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ListCell listCell = new ListCell();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm").withZone(DateUtil.MV_DEFAULT_TIMEZONE);
    private static final long REMAINING_TIME_THRESHOLD = TimeUnit.SECONDS.convert(5L, TimeUnit.MINUTES);
    @NotNull
    private static final Color COLOR_ORANGE = new Color(255, 140, 0);
    public static final int ICON_SIZE = 64;

    public LivestreamRenderer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setMinimumSize(new Dimension(100, 200));
        this.add((Component)this.listCell, "Center");
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends LivestreamEntry> list, @NotNull LivestreamEntry value, int index, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (list.getWidth() <= 0 || list.getHeight() <= 0) {
            this.listCell.getLblSender().setText("");
            this.listCell.getLblTitle().setText("");
            this.listCell.setSubtitle("");
            this.listCell.getLblZeitraum().setText("");
            this.listCell.getProgressBar().setValue(0);
            return this;
        }
        String sanitized = SenderUtils.Companion.sanitizeName(value.getStreamName());
        String string = sanitized.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        URL iconUrl = SvgIconCache.INSTANCE.getIconUrl(string);
        this.listCell.getLblSender().setSenderIcon(iconUrl, 64);
        ShowInfo show = value.getShow();
        if (show != null && show.getStartTime().isBefore(Instant.now()) && show.getEndTime().isAfter(Instant.now())) {
            if (show.getSubtitle() != null) {
                this.listCell.getLblTitle().setText(show.getTitle());
                this.listCell.setSubtitle(show.getSubtitle());
            } else {
                this.listCell.getLblTitle().setText(show.getTitle());
                this.listCell.setSubtitle("");
            }
            String zeitraum = this.formatter.format(show.getStartTime()) + " - " + this.formatter.format(show.getEndTime());
            this.listCell.getLblZeitraum().setText(zeitraum);
            long total = RangesKt.coerceAtLeast((long)(show.getEndTime().getEpochSecond() - show.getStartTime().getEpochSecond()), (long)1L);
            long elapsed = Instant.now().getEpochSecond() - show.getStartTime().getEpochSecond();
            long remaining = show.getEndTime().getEpochSecond() - Instant.now().getEpochSecond();
            this.listCell.getProgressBar().setMaximum((int)total);
            this.listCell.getProgressBar().setValue((int)RangesKt.coerceAtLeast((long)elapsed, (long)0L));
            boolean bl = 1L <= remaining ? remaining <= REMAINING_TIME_THRESHOLD : false;
            if (bl) {
                this.listCell.getProgressBar().setForeground(COLOR_ORANGE);
                this.listCell.getLblZeitraum().setForeground(COLOR_ORANGE);
            } else {
                this.listCell.getProgressBar().setForeground(UIManager.getColor("ProgressBar.foreground"));
                this.listCell.getLblZeitraum().setForeground(this.getForeground());
            }
        } else {
            this.listCell.getLblTitle().setText("Keine Sendung oder au\u00dferhalb des Zeitraums");
            this.listCell.setSubtitle("");
            this.listCell.getLblZeitraum().setText("");
            this.listCell.getProgressBar().setMaximum(100);
            this.listCell.getProgressBar().setMinimum(0);
            this.listCell.getProgressBar().setValue(0);
        }
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.listCell.getLblSender().setForeground(this.getForeground());
        this.listCell.getLblTitle().setForeground(this.getForeground());
        Color color = this.getForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
        this.listCell.setSubtitleForegroundColor(color);
        this.listCell.getLblZeitraum().setForeground(this.getForeground());
        return this;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmediathek/gui/tabs/tab_livestreams/LivestreamRenderer$Companion;", "", "<init>", "()V", "REMAINING_TIME_THRESHOLD", "", "COLOR_ORANGE", "Ljava/awt/Color;", "ICON_SIZE", "", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

