/*
 * Decompiled with CFR 0.152.
 */
package mediathek.windows;

import java.awt.Taskbar;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.threads.IndicatorThread;
import mediathek.windows.MediathekGuiWindows;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmediathek/windows/TaskbarIndicatorThread;", "Lmediathek/tool/threads/IndicatorThread;", "parent", "Lmediathek/windows/MediathekGuiWindows;", "<init>", "(Lmediathek/windows/MediathekGuiWindows;)V", "Ljavax/swing/JFrame;", "setThreadExecutionState", "Ljava/lang/invoke/MethodHandle;", "disableStandby", "", "enableStandby", "run", "Companion", "MediathekView"})
public final class TaskbarIndicatorThread
extends IndicatorThread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JFrame parent;
    @Nullable
    private final MethodHandle setThreadExecutionState;
    private static final Logger logger = LogManager.getLogger();

    public TaskbarIndicatorThread(@NotNull MediathekGuiWindows parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.setName("TaskbarIndicatorThread");
        this.parent = parent;
        Linker linker = Linker.nativeLinker();
        boolean bl = false;
        SymbolLookup kernel32 = SymbolLookup.libraryLookup("kernel32.dll", Arena.global());
        MemoryLayout[] memoryLayoutArray = new MemoryLayout[]{ValueLayout.JAVA_INT};
        this.setThreadExecutionState = linker.downcallHandle(kernel32.find("SetThreadExecutionState").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, memoryLayoutArray), new Linker.Option[0]);
    }

    private final void disableStandby() {
        Object res;
        Object object = this.setThreadExecutionState;
        if (object == null || (object = object.invoke(-2147483647)) == null) {
            object = 0;
        }
        if ((Integer)(res = object) == 0) {
            logger.error("disableStandby() failed!");
        }
    }

    private final void enableStandby() {
        Object res;
        Object object = this.setThreadExecutionState;
        if (object == null || (object = object.invoke(Integer.MIN_VALUE)) == null) {
            object = 0;
        }
        if ((Integer)(res = object) == 0) {
            logger.error("enableStandby() failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Taskbar taskbar = Taskbar.getTaskbar();
        try {
            while (!this.isInterrupted()) {
                int percentage = (int)this.calculateOverallPercentage();
                taskbar.setWindowProgressValue(this.parent, percentage);
                taskbar.setWindowProgressState(this.parent, Taskbar.State.NORMAL);
                this.disableStandby();
                TimeUnit.MILLISECONDS.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            taskbar.setWindowProgressState(this.parent, Taskbar.State.OFF);
            this.enableStandby();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmediathek/windows/TaskbarIndicatorThread$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

